/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade;

import com.google.common.base.MoreObjects;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.KerberosDetails;
import id.onyx.obdp.server.serveraction.kerberos.KDCType;
import id.onyx.obdp.server.serveraction.kerberos.KerberosInvalidConfigurationException;
import id.onyx.obdp.server.stack.upgrade.Condition;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.SecurityType;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlType(name="security")
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class SecurityCondition
extends Condition {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityCondition.class);
    @XmlAttribute(name="type")
    public SecurityType securityType;
    @XmlAttribute(name="kdc-type", required=false)
    public KDCType kdctype;

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.securityType).add("kdcType", (Object)this.kdctype).omitNullValues().toString();
    }

    @Override
    public boolean isSatisfied(UpgradeContext upgradeContext) {
        Cluster cluster = upgradeContext.getCluster();
        if (cluster.getSecurityType() != this.securityType) {
            return false;
        }
        switch (this.securityType) {
            case KERBEROS: {
                if (null != this.kdctype) {
                    try {
                        KerberosDetails kerberosDetails = upgradeContext.getKerberosDetails();
                        return kerberosDetails.getKdcType() == this.kdctype;
                    }
                    catch (OBDPException | KerberosInvalidConfigurationException kerberosException) {
                        LOG.error("Unable to determine if this upgrade condition is met because there was a problem parsing the Kerberos configruations for the KDC Type", kerberosException);
                        return false;
                    }
                }
                return true;
            }
            case NONE: {
                return true;
            }
        }
        return true;
    }
}

