/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade;

import com.google.common.collect.ArrayListMultimap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.CommandRepository;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.ActionExecutionContext;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.OperatingSystemResourceProvider;
import id.onyx.obdp.server.controller.internal.RepositoryResourceProvider;
import id.onyx.obdp.server.controller.internal.RepositoryVersionResourceProvider;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.orm.entities.RepoDefinitionEntity;
import id.onyx.obdp.server.orm.entities.RepoOsEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.RepositoryInfo;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.ServiceOsSpecific;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.repository.ClusterVersionSummary;
import id.onyx.obdp.server.state.repository.VersionDefinitionXml;
import id.onyx.obdp.server.state.stack.OsFamily;
import id.onyx.obdp.server.state.stack.RepoTag;
import id.onyx.obdp.spi.RepositoryType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RepositoryVersionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryVersionHelper.class);
    @Inject
    private Gson gson;
    @Inject
    private Provider<OBDPMetaInfo> ami;
    @Inject
    private Provider<Configuration> configuration;
    @Inject
    private Provider<OsFamily> os_family;
    @Inject
    Provider<Clusters> clusters;

    private RepositoryVersionEntity getRepositoryVersionEntity(Cluster cluster, ServiceComponent component) throws SystemException {
        RepositoryVersionEntity repositoryEntity = null;
        if (null != component) {
            repositoryEntity = component.getDesiredRepositoryVersion();
        } else {
            LOG.info("Service component not passed in, attempt to resolve the repository for cluster {}", (Object)cluster.getClusterName());
        }
        if (null == repositoryEntity && null != component) {
            try {
                Service service = cluster.getService(component.getServiceName());
                repositoryEntity = service.getDesiredRepositoryVersion();
            }
            catch (OBDPException e) {
                throw new SystemException("Unhandled exception", e);
            }
        }
        if (null == repositoryEntity) {
            LOG.info("Cluster {} has no specific Repository Versions.  Using stack-defined values", (Object)cluster.getClusterName());
            return null;
        }
        return repositoryEntity;
    }

    public List<RepoOsEntity> parseOperatingSystems(String repositoriesJson) throws Exception {
        ArrayList<RepoOsEntity> operatingSystems = new ArrayList<RepoOsEntity>();
        JsonArray rootJson = new JsonParser().parse(repositoriesJson).getAsJsonArray();
        for (JsonElement operatingSystemJson : rootJson) {
            JsonObject osObj = operatingSystemJson.getAsJsonObject();
            RepoOsEntity operatingSystemEntity = new RepoOsEntity();
            operatingSystemEntity.setFamily(osObj.get(OperatingSystemResourceProvider.OPERATING_SYSTEM_OS_TYPE_PROPERTY_ID).getAsString());
            if (osObj.has("OperatingSystems/ambari_managed_repositories")) {
                operatingSystemEntity.setAmbariManaged(osObj.get("OperatingSystems/ambari_managed_repositories").getAsBoolean());
            }
            for (JsonElement repositoryElement : osObj.get(RepositoryVersionResourceProvider.SUBRESOURCE_REPOSITORIES_PROPERTY_ID).getAsJsonArray()) {
                JsonArray jsonArray;
                RepoDefinitionEntity repositoryEntity = new RepoDefinitionEntity();
                JsonObject repositoryJson = repositoryElement.getAsJsonObject();
                repositoryEntity.setBaseUrl(repositoryJson.get(RepositoryResourceProvider.REPOSITORY_BASE_URL_PROPERTY_ID).getAsString());
                repositoryEntity.setRepoName(repositoryJson.get(RepositoryResourceProvider.REPOSITORY_REPO_NAME_PROPERTY_ID).getAsString());
                repositoryEntity.setRepoID(repositoryJson.get(RepositoryResourceProvider.REPOSITORY_REPO_ID_PROPERTY_ID).getAsString());
                if (repositoryJson.get(RepositoryResourceProvider.REPOSITORY_DISTRIBUTION_PROPERTY_ID) != null) {
                    repositoryEntity.setDistribution(repositoryJson.get(RepositoryResourceProvider.REPOSITORY_DISTRIBUTION_PROPERTY_ID).getAsString());
                }
                if (repositoryJson.get(RepositoryResourceProvider.REPOSITORY_COMPONENTS_PROPERTY_ID) != null) {
                    repositoryEntity.setComponents(repositoryJson.get(RepositoryResourceProvider.REPOSITORY_COMPONENTS_PROPERTY_ID).getAsString());
                }
                if (repositoryJson.get(RepositoryResourceProvider.REPOSITORY_MIRRORS_LIST_PROPERTY_ID) != null) {
                    repositoryEntity.setMirrors(repositoryJson.get(RepositoryResourceProvider.REPOSITORY_MIRRORS_LIST_PROPERTY_ID).getAsString());
                }
                if (repositoryJson.getAsJsonObject().get(RepositoryResourceProvider.REPOSITORY_UNIQUE_PROPERTY_ID) != null) {
                    repositoryEntity.setUnique(repositoryJson.getAsJsonObject().get(RepositoryResourceProvider.REPOSITORY_UNIQUE_PROPERTY_ID).getAsBoolean());
                }
                if (repositoryJson.get(RepositoryResourceProvider.REPOSITORY_APPLICABLE_SERVICES_PROPERTY_ID) != null) {
                    LinkedList<String> applicableServices = new LinkedList<String>();
                    jsonArray = repositoryJson.get(RepositoryResourceProvider.REPOSITORY_APPLICABLE_SERVICES_PROPERTY_ID).getAsJsonArray();
                    for (JsonElement je : jsonArray) {
                        applicableServices.add(je.getAsString());
                    }
                    repositoryEntity.setApplicableServices(applicableServices);
                }
                if (null != repositoryJson.get(RepositoryResourceProvider.REPOSITORY_TAGS_PROPERTY_ID)) {
                    HashSet<RepoTag> tags = new HashSet<RepoTag>();
                    jsonArray = repositoryJson.get(RepositoryResourceProvider.REPOSITORY_TAGS_PROPERTY_ID).getAsJsonArray();
                    for (JsonElement je : jsonArray) {
                        tags.add(RepoTag.valueOf(je.getAsString()));
                    }
                    repositoryEntity.setTags(tags);
                }
                operatingSystemEntity.addRepoDefinition(repositoryEntity);
            }
            operatingSystems.add(operatingSystemEntity);
        }
        return operatingSystems;
    }

    public List<RepoOsEntity> createRepoOsEntities(List<RepositoryInfo> repositories) {
        ArrayList<RepoOsEntity> repoOsEntities = new ArrayList<RepoOsEntity>();
        ArrayListMultimap operatingSystems = ArrayListMultimap.create();
        for (RepositoryInfo repositoryInfo : repositories) {
            operatingSystems.put((Object)repositoryInfo.getOsType(), (Object)repositoryInfo);
        }
        for (Map.Entry entry : operatingSystems.asMap().entrySet()) {
            RepoOsEntity operatingSystemEntity = new RepoOsEntity();
            ArrayList<RepoDefinitionEntity> repositoriesList = new ArrayList<RepoDefinitionEntity>();
            for (RepositoryInfo repository : (Collection)entry.getValue()) {
                RepoDefinitionEntity repositoryDefinition = new RepoDefinitionEntity();
                repositoryDefinition.setBaseUrl(repository.getBaseUrl());
                repositoryDefinition.setRepoName(repository.getRepoName());
                repositoryDefinition.setRepoID(repository.getRepoId());
                repositoryDefinition.setDistribution(repository.getDistribution());
                repositoryDefinition.setComponents(repository.getComponents());
                repositoryDefinition.setMirrors(repository.getMirrorsList());
                repositoryDefinition.setUnique(repository.isUnique());
                repositoryDefinition.setTags(repository.getTags());
                repositoryDefinition.setApplicableServices(repository.getApplicableServices());
                repositoriesList.add(repositoryDefinition);
                operatingSystemEntity.setAmbariManaged(repository.isAmbariManagedRepositories());
            }
            operatingSystemEntity.addRepoDefinitionEntities(repositoriesList);
            operatingSystemEntity.setFamily((String)entry.getKey());
            repoOsEntities.add(operatingSystemEntity);
        }
        return repoOsEntities;
    }

    public String getUpgradePackageName(String stackName, String stackVersion, String repositoryVersion, UpgradeType upgradeType) throws OBDPException {
        Map<String, UpgradePack> upgradePacks = ((OBDPMetaInfo)this.ami.get()).getUpgradePacks(stackName, stackVersion);
        for (UpgradePack upgradePack : upgradePacks.values()) {
            String upgradePackName = upgradePack.getName();
            if (null != upgradeType && upgradePack.getType() != upgradeType) continue;
            if (StringUtils.isBlank((String)upgradePack.getTarget())) {
                LOG.error("Upgrade pack " + upgradePackName + " is corrupted, it should contain <target> node");
                continue;
            }
            if (!upgradePack.canBeApplied(repositoryVersion)) continue;
            return upgradePackName;
        }
        throw new OBDPException("There were no suitable upgrade packs for stack " + stackName + " " + stackVersion + (String)(null != upgradeType ? " and upgrade type " + upgradeType : ""));
    }

    public Map<String, String> buildRoleParams(OBDPManagementController amc, RepositoryVersionEntity repoVersion, String osFamily, Set<String> servicesOnHost) throws SystemException {
        StackId stackId = repoVersion.getStackId();
        ArrayList<ServiceOsSpecific.Package> packages = new ArrayList<ServiceOsSpecific.Package>();
        for (String serviceName : servicesOnHost) {
            ServiceInfo info;
            try {
                if (((OBDPMetaInfo)this.ami.get()).isServiceRemovedInStack(stackId.getStackName(), stackId.getStackVersion(), serviceName)) {
                    LOG.info(String.format("%s has been removed from stack %s-%s. Skip calculating its installation packages", stackId.getStackName(), stackId.getStackVersion(), serviceName));
                    continue;
                }
                info = ((OBDPMetaInfo)this.ami.get()).getService(stackId.getStackName(), stackId.getStackVersion(), serviceName);
            }
            catch (OBDPException e) {
                throw new SystemException(String.format("Cannot obtain stack information for %s-%s", stackId.getStackName(), stackId.getStackVersion()), e);
            }
            List<ServiceOsSpecific.Package> packagesForService = amc.getPackagesForServiceHost(info, new HashMap<String, String>(), osFamily);
            List<String> blacklistedPackagePrefixes = ((Configuration)this.configuration.get()).getRollingUpgradeSkipPackagesPrefixes();
            for (ServiceOsSpecific.Package aPackage : packagesForService) {
                if (aPackage.getSkipUpgrade().booleanValue()) continue;
                boolean blacklisted = false;
                for (String prefix : blacklistedPackagePrefixes) {
                    if (!aPackage.getName().startsWith(prefix)) continue;
                    blacklisted = true;
                    break;
                }
                if (blacklisted) continue;
                packages.add(aPackage);
            }
        }
        HashMap<String, String> roleParams = new HashMap<String, String>();
        roleParams.put("stack_id", stackId.getStackId());
        roleParams.put("package_list", this.gson.toJson(packages));
        return roleParams;
    }

    public RepoOsEntity getOSEntityForHost(Host host, RepositoryVersionEntity repoVersion) throws SystemException {
        String osFamily = host.getOsFamily();
        RepoOsEntity osEntity = null;
        for (RepoOsEntity operatingSystem : repoVersion.getRepoOsEntities()) {
            if (!osFamily.equals(operatingSystem.getFamily())) continue;
            osEntity = operatingSystem;
            break;
        }
        if (null == osEntity) {
            throw new SystemException(String.format("Operating System matching %s could not be found", osFamily));
        }
        return osEntity;
    }

    public CommandRepository getCommandRepository(RepositoryVersionEntity repoVersion, RepoOsEntity osEntity) throws SystemException {
        CommandRepository commandRepo = new CommandRepository();
        boolean sysPreppedHost = ((Configuration)this.configuration.get()).areHostsSysPrepped().equalsIgnoreCase("true");
        if (null == repoVersion) {
            throw new SystemException("Repository version entity is not provided");
        }
        commandRepo.setRepositories(osEntity.getFamily(), osEntity.getRepoDefinitionEntities());
        commandRepo.setRepoVersion(repoVersion.getVersion());
        commandRepo.setRepositoryVersionId(repoVersion.getId());
        commandRepo.setResolved(repoVersion.isResolved());
        commandRepo.setStackName(repoVersion.getStackId().getStackName());
        commandRepo.getFeature().setPreInstalled(((Configuration)this.configuration.get()).areHostsSysPrepped());
        commandRepo.getFeature().setIsScoped(!sysPreppedHost);
        if (!osEntity.isAmbariManaged()) {
            commandRepo.setNonManaged();
        } else if (repoVersion.isLegacy()) {
            commandRepo.setLegacyRepoFileName(repoVersion.getStackName(), repoVersion.getVersion());
            commandRepo.setLegacyRepoId(repoVersion.getVersion());
            commandRepo.getFeature().setIsScoped(false);
        } else {
            commandRepo.setRepoFileName(repoVersion.getStackName(), repoVersion.getId());
            commandRepo.setUniqueSuffix(String.format("-repo-%s", repoVersion.getId()));
        }
        if (((Configuration)this.configuration.get()).arePackagesLegacyOverridden()) {
            LOG.warn("Legacy override option is turned on, disabling CommandRepositoryFeature.scoped feature");
            commandRepo.getFeature().setIsScoped(false);
        }
        return commandRepo;
    }

    public CommandRepository getCommandRepository(Cluster cluster, ServiceComponent component, Host host) throws SystemException {
        RepositoryVersionEntity repoVersion = this.getRepositoryVersionEntity(cluster, component);
        RepoOsEntity osEntity = this.getOSEntityForHost(host, repoVersion);
        return this.getCommandRepository(repoVersion, osEntity);
    }

    public CommandRepository getCommandRepository(Cluster cluster, Service service, Host host, String componentName) throws OBDPException {
        CommandRepository commandRepository = null;
        try {
            if (null != componentName) {
                ServiceComponent serviceComponent = service.getServiceComponent(componentName);
                commandRepository = this.getCommandRepository(cluster, serviceComponent, host);
            } else {
                RepositoryVersionEntity repoVersion = service.getDesiredRepositoryVersion();
                RepoOsEntity osEntity = this.getOSEntityForHost(host, repoVersion);
                commandRepository = this.getCommandRepository(repoVersion, osEntity);
            }
        }
        catch (SystemException e) {
            LOG.debug("Unable to find command repository with a correct operating system for host {}", (Object)host, (Object)e);
        }
        return commandRepository;
    }

    @Deprecated
    public void addRepoInfoToHostLevelParams(Cluster cluster, ActionExecutionContext actionContext, RepositoryVersionEntity repositoryVersion, Map<String, String> hostLevelParams, String hostName) throws OBDPException {
        if (null == repositoryVersion) {
            if (null != actionContext.getStackId()) {
                StackId stackId = actionContext.getStackId();
                hostLevelParams.put("stack_name", stackId.getStackName());
                hostLevelParams.put("stack_version", stackId.getStackVersion());
            }
            return;
        }
        StackId stackId = repositoryVersion.getStackId();
        hostLevelParams.put("stack_name", stackId.getStackName());
        hostLevelParams.put("stack_version", stackId.getStackVersion());
    }

    @Deprecated
    private JsonArray getBaseUrls(Cluster cluster, ServiceComponent component, Host host) throws SystemException {
        List<RepositoryInfo> repoInfoList;
        Map<String, List<RepositoryInfo>> repos;
        String hostOsType = host.getOsType();
        String hostOsFamily = host.getOsFamily();
        String hostName = host.getHostName();
        StackId stackId = component.getDesiredStackId();
        try {
            repos = ((OBDPMetaInfo)this.ami.get()).getRepository(stackId.getStackName(), stackId.getStackVersion());
        }
        catch (OBDPException e) {
            throw new SystemException("Unhandled exception", e);
        }
        String family = ((OsFamily)this.os_family.get()).find(hostOsType);
        if (null == family) {
            family = hostOsFamily;
        }
        if (repos.containsKey(hostOsType)) {
            repoInfoList = repos.get(hostOsType);
        } else if (null != family && repos.containsKey(family)) {
            repoInfoList = repos.get(family);
        } else {
            repoInfoList = null;
            LOG.warn("Could not retrieve repo information for host, hostname=" + hostName + ", clusterName=" + cluster.getClusterName() + ", stackInfo=" + stackId.getStackId());
        }
        return null == repoInfoList ? null : (JsonArray)this.gson.toJsonTree(repoInfoList);
    }

    public void addCommandRepositoryToContext(ActionExecutionContext context, RepositoryVersionEntity repoVersion, RepoOsEntity osEntity) throws SystemException {
        CommandRepository commandRepo = this.getCommandRepository(repoVersion, osEntity);
        ClusterVersionSummary summary = null;
        if (RepositoryType.STANDARD != repoVersion.getType()) {
            try {
                Cluster cluster = ((Clusters)this.clusters.get()).getCluster(context.getClusterName());
                VersionDefinitionXml xml = repoVersion.getRepositoryXml();
                summary = xml.getClusterSummary(cluster, (OBDPMetaInfo)this.ami.get());
            }
            catch (Exception e) {
                LOG.warn("Could not determine repository from %s/%s.  Will not pass cluster version.");
            }
        }
        ClusterVersionSummary clusterSummary = summary;
        context.addVisitor(command -> {
            if (null == command.getRepositoryFile()) {
                command.setRepositoryFile(commandRepo);
            }
            if (null != clusterSummary) {
                Map<String, Object> params = command.getRoleParameters();
                if (null == params) {
                    params = new HashMap<String, Object>();
                    command.setRoleParameters(params);
                }
                params.put("cluster_version_summary", clusterSummary);
            }
        });
    }

    public String getRepoInfoString(Cluster cluster, ServiceComponent component, Host host) throws OBDPException, SystemException {
        return this.gson.toJson((Object)this.getCommandRepository(cluster, component, host));
    }
}

