/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade;

import com.google.gson.JsonObject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleCommandFactory;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.metadata.RoleCommandOrder;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.stack.HostsType;
import id.onyx.obdp.server.stack.upgrade.Grouping;
import id.onyx.obdp.server.stack.upgrade.HostOrderItem;
import id.onyx.obdp.server.stack.upgrade.ManualTask;
import id.onyx.obdp.server.stack.upgrade.RestartTask;
import id.onyx.obdp.server.stack.upgrade.ServiceCheckTask;
import id.onyx.obdp.server.stack.upgrade.StopTask;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapperBuilder;
import id.onyx.obdp.server.stack.upgrade.orchestrate.TaskWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.stageplanner.RoleGraph;
import id.onyx.obdp.server.stageplanner.RoleGraphFactory;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.StackId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlType(name="host-order")
public class HostOrderGrouping
extends Grouping {
    private static final String TYPE = "type";
    private static final String HOST = "host";
    private static final Logger LOG = LoggerFactory.getLogger(HostOrderGrouping.class);
    private List<HostOrderItem> m_hostOrderItems;

    public void setHostOrderItems(List<HostOrderItem> hostOrderItems) {
        this.m_hostOrderItems = hostOrderItems;
    }

    @Override
    public StageWrapperBuilder getBuilder() {
        return new HostBuilder(this);
    }

    private static class HostBuilder
    extends StageWrapperBuilder {
        private final List<HostOrderItem> hostOrderItems;

        protected HostBuilder(HostOrderGrouping grouping) {
            super(grouping);
            this.hostOrderItems = grouping.m_hostOrderItems;
        }

        @Override
        public void add(UpgradeContext upgradeContext, HostsType hostsType, String service, boolean clientOnly, UpgradePack.ProcessingComponent pc, Map<String, String> params) {
        }

        @Override
        public List<StageWrapper> build(UpgradeContext upgradeContext, List<StageWrapper> stageWrappers) {
            ArrayList<StageWrapper> wrappers = new ArrayList<StageWrapper>(stageWrappers);
            for (HostOrderItem orderItem : this.hostOrderItems) {
                switch (orderItem.getType()) {
                    case HOST_UPGRADE: {
                        wrappers.addAll(this.buildHosts(upgradeContext, orderItem.getActionItems()));
                        break;
                    }
                    case SERVICE_CHECK: {
                        wrappers.addAll(this.buildServiceChecks(upgradeContext, orderItem.getActionItems()));
                    }
                }
            }
            return wrappers;
        }

        private List<StageWrapper> buildHosts(UpgradeContext upgradeContext, List<String> hosts) {
            if (CollectionUtils.isEmpty(hosts)) {
                return Collections.emptyList();
            }
            Cluster cluster = upgradeContext.getCluster();
            ArrayList<StageWrapper> wrappers = new ArrayList<StageWrapper>();
            HostRoleCommandFactory hrcFactory = upgradeContext.getHostRoleCommandFactory();
            RoleCommandOrder roleCommandOrder = this.getRoleCommandOrderForUpgrade(cluster);
            for (String hostName : hosts) {
                ArrayList<TaskWrapper> stopTasks = new ArrayList<TaskWrapper>();
                HashMap<String, Map<String, HostRoleCommand>> restartCommandsForHost = new HashMap<String, Map<String, HostRoleCommand>>();
                HashMap<String, HostRoleCommand> restartCommandsByRole = new HashMap<String, HostRoleCommand>();
                restartCommandsForHost.put(hostName, restartCommandsByRole);
                for (ServiceComponentHost sch : cluster.getServiceComponentHosts(hostName)) {
                    if (!this.isVersionAdvertised(upgradeContext, sch)) continue;
                    HostsType hostsType = upgradeContext.getResolver().getMasterAndHosts(sch.getServiceName(), sch.getServiceComponentName());
                    if (null != hostsType && !hostsType.getHosts().contains(hostName)) {
                        RepositoryVersionEntity targetRepositoryVersion = upgradeContext.getTargetRepositoryVersion(sch.getServiceName());
                        LOG.warn("Host {} could not be orchestrated. Either there are no components for {}/{} or the target version {} is already current.", new Object[]{hostName, sch.getServiceName(), sch.getServiceComponentName(), targetRepositoryVersion.getVersion()});
                        continue;
                    }
                    if (!sch.isClientComponent()) {
                        stopTasks.add(new TaskWrapper(sch.getServiceName(), sch.getServiceComponentName(), Collections.singleton(hostName), new StopTask()));
                    }
                    Role role = Role.valueOf(sch.getServiceComponentName());
                    HostRoleCommand hostRoleCommand = hrcFactory.create(hostName, role, null, RoleCommand.START);
                    restartCommandsByRole.put(role.name(), hostRoleCommand);
                }
                if (stopTasks.isEmpty() && restartCommandsByRole.isEmpty()) {
                    LOG.info("There were no {} commands generated for {}", (Object)upgradeContext.getDirection().getText(false), (Object)hostName);
                    continue;
                }
                RoleGraphFactory roleGraphFactory = upgradeContext.getRoleGraphFactory();
                RoleGraph roleGraph = roleGraphFactory.createNew(roleCommandOrder);
                List<Map<String, List<HostRoleCommand>>> stages = roleGraph.getOrderedHostRoleCommands(restartCommandsForHost);
                ArrayList<StageWrapper> stageWrappers = new ArrayList<StageWrapper>();
                int phaseCounter = 1;
                for (Map<String, List<HostRoleCommand>> stage : stages) {
                    List<HostRoleCommand> stageCommandsForHost = stage.get(hostName);
                    String stageTitle = String.format("Starting components on %s (phase %d)", hostName, phaseCounter++);
                    ArrayList<TaskWrapper> taskWrappers = new ArrayList<TaskWrapper>();
                    for (HostRoleCommand command : stageCommandsForHost) {
                        StackId stackId = upgradeContext.getRepositoryVersion().getStackId();
                        String componentName = command.getRole().name();
                        String serviceName = null;
                        try {
                            OBDPMetaInfo obdpMetaInfo = upgradeContext.getAmbariMetaInfo();
                            serviceName = obdpMetaInfo.getComponentToService(stackId.getStackName(), stackId.getStackVersion(), componentName);
                        }
                        catch (OBDPException ambariException) {
                            LOG.error("Unable to lookup service by component {} for stack {}-{}", new Object[]{componentName, stackId.getStackName(), stackId.getStackVersion()});
                        }
                        TaskWrapper taskWrapper = new TaskWrapper(serviceName, componentName, Collections.singleton(hostName), new RestartTask());
                        taskWrappers.add(taskWrapper);
                    }
                    if (taskWrappers.isEmpty()) continue;
                    StageWrapper startWrapper = new StageWrapper(StageWrapper.Type.RESTART, stageTitle, taskWrappers.toArray(new TaskWrapper[taskWrappers.size()]));
                    stageWrappers.add(startWrapper);
                }
                ManualTask mt = new ManualTask();
                String message = String.format("Please acknowledge that host %s has been prepared.", hostName);
                mt.messages.add(message);
                JsonObject structuredOut = new JsonObject();
                structuredOut.addProperty(HostOrderGrouping.TYPE, HostOrderItem.HostOrderActionType.HOST_UPGRADE.toString());
                structuredOut.addProperty(HostOrderGrouping.HOST, hostName);
                mt.structuredOut = structuredOut.toString();
                if (!stopTasks.isEmpty()) {
                    StageWrapper stopWrapper = new StageWrapper(StageWrapper.Type.STOP, String.format("Stop on %s", hostName), stopTasks.toArray(new TaskWrapper[stopTasks.size()]));
                    wrappers.add(stopWrapper);
                }
                StageWrapper manualWrapper = new StageWrapper(StageWrapper.Type.SERVER_SIDE_ACTION, "Manual Confirmation", new TaskWrapper(null, null, Collections.emptySet(), mt));
                wrappers.add(manualWrapper);
                wrappers.addAll(stageWrappers);
            }
            return wrappers;
        }

        private List<StageWrapper> buildServiceChecks(UpgradeContext upgradeContext, List<String> serviceChecks) {
            if (CollectionUtils.isEmpty(serviceChecks)) {
                return Collections.emptyList();
            }
            ArrayList<StageWrapper> wrappers = new ArrayList<StageWrapper>();
            Cluster cluster = upgradeContext.getCluster();
            for (String serviceName : serviceChecks) {
                boolean hasService = false;
                try {
                    cluster.getService(serviceName);
                    hasService = true;
                }
                catch (Exception e) {
                    LOG.warn("Service {} not found to orchestrate", (Object)serviceName);
                }
                if (!hasService) continue;
                StageWrapper wrapper = new StageWrapper(StageWrapper.Type.SERVICE_CHECK, String.format("Service Check %s", upgradeContext.getServiceDisplay(serviceName)), new TaskWrapper(serviceName, "", Collections.emptySet(), new ServiceCheckTask()));
                wrappers.add(wrapper);
            }
            return wrappers;
        }

        private boolean isVersionAdvertised(UpgradeContext upgradeContext, ServiceComponentHost sch) {
            RepositoryVersionEntity targetRepositoryVersion = upgradeContext.getTargetRepositoryVersion(sch.getServiceName());
            StackId targetStack = targetRepositoryVersion.getStackId();
            try {
                ComponentInfo component = upgradeContext.getAmbariMetaInfo().getComponent(targetStack.getStackName(), targetStack.getStackVersion(), sch.getServiceName(), sch.getServiceComponentName());
                return component.isVersionAdvertised();
            }
            catch (OBDPException e) {
                LOG.warn("Could not determine if {}/{}/{} could be upgraded; returning false", new Object[]{targetStack, sch.getServiceName(), sch.getServiceComponentName(), e});
                return false;
            }
        }

        private RoleCommandOrder getRoleCommandOrderForUpgrade(Cluster cluster) {
            RoleCommandOrder roleCommandOrder = cluster.getRoleCommandOrder();
            try {
                roleCommandOrder = (RoleCommandOrder)roleCommandOrder.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                LOG.warn("Unable to clone role command order and apply overrides for this upgrade", (Throwable)cloneNotSupportedException);
            }
            LinkedHashSet<String> sectionKeys = roleCommandOrder.getSectionKeys();
            sectionKeys.add("host_ordered_upgrade");
            roleCommandOrder.initialize(cluster, sectionKeys);
            return roleCommandOrder;
        }
    }
}

