/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade;

import com.esotericsoftware.yamlbeans.YamlReader;
import com.google.common.base.MoreObjects;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.stack.HostsType;
import id.onyx.obdp.server.stack.upgrade.ClusterGrouping;
import id.onyx.obdp.server.stack.upgrade.ColocatedGrouping;
import id.onyx.obdp.server.stack.upgrade.Condition;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.stack.upgrade.HostOrderGrouping;
import id.onyx.obdp.server.stack.upgrade.ParallelClientGrouping;
import id.onyx.obdp.server.stack.upgrade.ParallelScheduler;
import id.onyx.obdp.server.stack.upgrade.RestartGrouping;
import id.onyx.obdp.server.stack.upgrade.ServiceCheckGrouping;
import id.onyx.obdp.server.stack.upgrade.ServiceCheckTask;
import id.onyx.obdp.server.stack.upgrade.StartGrouping;
import id.onyx.obdp.server.stack.upgrade.StopGrouping;
import id.onyx.obdp.server.stack.upgrade.Task;
import id.onyx.obdp.server.stack.upgrade.UpdateStackGrouping;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.stack.upgrade.UpgradeScope;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapperBuilder;
import id.onyx.obdp.server.stack.upgrade.orchestrate.TaskWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.TaskWrapperBuilder;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.utils.SetUtils;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.commons.lang.StringUtils;

@XmlSeeAlso(value={ColocatedGrouping.class, ClusterGrouping.class, UpdateStackGrouping.class, ServiceCheckGrouping.class, RestartGrouping.class, StartGrouping.class, StopGrouping.class, HostOrderGrouping.class, ParallelClientGrouping.class})
public class Grouping {
    private static final String RACKS_YAML_KEY_NAME = "racks";
    private static final String HOSTS_YAML_KEY_NAME = "hosts";
    private static final String HOST_GROUPS_YAML_KEY_NAME = "hostGroups";
    @XmlAttribute(name="name")
    public String name;
    @XmlAttribute(name="title")
    public String title;
    @XmlElement(name="add-after-group")
    public String addAfterGroup;
    @XmlElement(name="add-after-group-entry")
    public String addAfterGroupEntry;
    @XmlElement(name="skippable", defaultValue="false")
    public boolean skippable = false;
    @XmlElement(name="supports-auto-skip-failure", defaultValue="true")
    public boolean supportsAutoSkipOnFailure = true;
    @XmlElement(name="allow-retry", defaultValue="true")
    public boolean allowRetry = true;
    @XmlElement(name="service")
    public List<UpgradePack.OrderService> services = new ArrayList<UpgradePack.OrderService>();
    @XmlElement(name="service-check", defaultValue="true")
    public boolean performServiceCheck = true;
    @XmlElement(name="direction")
    public Direction intendedDirection = null;
    @XmlElement(name="parallel-scheduler")
    public ParallelScheduler parallelScheduler;
    @XmlElement(name="scope")
    public UpgradeScope scope = UpgradeScope.ANY;
    @XmlElement(name="condition")
    public Condition condition;

    public final boolean isProcessingGroup() {
        return this.serviceCheckAfterProcessing();
    }

    protected boolean serviceCheckAfterProcessing() {
        return true;
    }

    public StageWrapperBuilder getBuilder() {
        return new DefaultBuilder(this, this.performServiceCheck);
    }

    private static List<TaskBucket> buckets(List<Task> tasks) {
        if (null == tasks || tasks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TaskBucket> holders = new ArrayList<TaskBucket>();
        TaskBucket current = null;
        int i = 0;
        for (Task t : tasks) {
            if (i == 0) {
                current = new TaskBucket(t);
                holders.add(current);
            } else if (i > 0 && t.getType() != tasks.get(i - 1).getType()) {
                current = new TaskBucket(t);
                holders.add(current);
            } else {
                current.tasks.add(t);
            }
            ++i;
        }
        return holders;
    }

    public void merge(Iterator<Grouping> iterator) throws OBDPException {
        HashMap<String, List<UpgradePack.OrderService>> skippedServices = new HashMap<String, List<UpgradePack.OrderService>>();
        while (iterator.hasNext()) {
            Grouping group = iterator.next();
            boolean added = this.addGroupingServices(group.services, group.addAfterGroupEntry);
            if (added) {
                this.addSkippedServices(skippedServices, group.services);
                continue;
            }
            if (skippedServices.containsKey(group.addAfterGroupEntry)) {
                List tmp = (List)skippedServices.get(group.addAfterGroupEntry);
                tmp.addAll(group.services);
                continue;
            }
            skippedServices.put(group.addAfterGroupEntry, group.services);
        }
    }

    private boolean addGroupingServices(List<UpgradePack.OrderService> servicesToAdd, String after) {
        if (after == null) {
            this.services.addAll(servicesToAdd);
            return true;
        }
        for (int index = this.services.size() - 1; index >= 0; --index) {
            UpgradePack.OrderService service = this.services.get(index);
            if (!service.serviceName.equals(after)) continue;
            this.services.addAll(index + 1, servicesToAdd);
            return true;
        }
        return false;
    }

    private void addSkippedServices(Map<String, List<UpgradePack.OrderService>> skippedServices, List<UpgradePack.OrderService> servicesJustAdded) {
        for (UpgradePack.OrderService service : servicesJustAdded) {
            if (!skippedServices.containsKey(service.serviceName)) continue;
            List<UpgradePack.OrderService> servicesToAdd = skippedServices.remove(service.serviceName);
            this.addGroupingServices(servicesToAdd, service.serviceName);
            this.addSkippedServices(skippedServices, servicesToAdd);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    private static class DefaultBuilder
    extends StageWrapperBuilder {
        private List<StageWrapper> m_stages = new ArrayList<StageWrapper>();
        private Set<String> m_servicesToCheck = new HashSet<String>();
        private boolean m_serviceCheck = true;

        private DefaultBuilder(Grouping grouping, boolean serviceCheck) {
            super(grouping);
            this.m_serviceCheck = serviceCheck;
        }

        @Override
        public void add(UpgradeContext context, HostsType hostsType, String service, boolean clientOnly, UpgradePack.ProcessingComponent pc, Map<String, String> params) {
            List<TaskBucket> buckets = Grouping.buckets(this.resolveTasks(context, true, pc));
            for (TaskBucket bucket : buckets) {
                List<TaskWrapper> preTasks = TaskWrapperBuilder.getTaskList(service, pc.name, hostsType, bucket.tasks, params);
                List<List<TaskWrapper>> organizedTasks = this.organizeTaskWrappersBySyncRules(preTasks);
                for (List<TaskWrapper> tasks : organizedTasks) {
                    this.addTasksToStageInBatches(tasks, "Preparing", context, service, pc, params);
                }
            }
            Task t = this.resolveTask(context, pc);
            if (null != t) {
                TaskWrapper tw = new TaskWrapper(service, pc.name, hostsType.getHosts(), params, Collections.singletonList(t));
                this.addTasksToStageInBatches(Collections.singletonList(tw), t.getActionVerb(), context, service, pc, params);
            }
            buckets = Grouping.buckets(this.resolveTasks(context, false, pc));
            for (TaskBucket bucket : buckets) {
                List<TaskWrapper> postTasks = TaskWrapperBuilder.getTaskList(service, pc.name, hostsType, bucket.tasks, params);
                List<List<TaskWrapper>> organizedTasks = this.organizeTaskWrappersBySyncRules(postTasks);
                for (List<TaskWrapper> tasks : organizedTasks) {
                    this.addTasksToStageInBatches(tasks, "Completing", context, service, pc, params);
                }
            }
            if (this.m_serviceCheck && !clientOnly) {
                this.m_servicesToCheck.add(service);
            }
        }

        private List<List<TaskWrapper>> organizeTaskWrappersBySyncRules(List<TaskWrapper> tasks) {
            ArrayList<List<TaskWrapper>> groupedTasks = new ArrayList<List<TaskWrapper>>();
            ArrayList<TaskWrapper> subTasks = new ArrayList<TaskWrapper>();
            for (TaskWrapper tw : tasks) {
                if (tw.isAnyTaskSequential()) {
                    if (!subTasks.isEmpty()) {
                        groupedTasks.add(subTasks);
                        subTasks = new ArrayList();
                    }
                    groupedTasks.add(Collections.singletonList(tw));
                    continue;
                }
                subTasks.add(tw);
            }
            if (!subTasks.isEmpty()) {
                groupedTasks.add(subTasks);
            }
            return groupedTasks;
        }

        private void addTasksToStageInBatches(List<TaskWrapper> tasks, String verb, UpgradeContext ctx, String service, UpgradePack.ProcessingComponent pc, Map<String, String> params) {
            if (tasks == null || tasks.isEmpty() || tasks.get(0).getTasks() == null || tasks.get(0).getTasks().isEmpty()) {
                return;
            }
            StageWrapper.Type type = tasks.get(0).getTasks().get(0).getStageWrapperType();
            for (TaskWrapper tw : tasks) {
                List<Set<String>> hostSets = null;
                int parallel = this.getParallelHostCount(ctx, 1);
                String rackYamlFile = ctx.getResolver().getValueFromDesiredConfigurations("cluster-env", "rack_yaml_file_path");
                if (StringUtils.isNotEmpty((String)rackYamlFile)) {
                    Map<String, Set<String>> hostsByRack = this.organizeHostsByRack(tw.getHosts(), rackYamlFile);
                    for (String string : hostsByRack.keySet()) {
                        List<Set<String>> hostSetsForRack = SetUtils.split(hostsByRack.get(string), parallel);
                        if (hostSets == null) {
                            hostSets = hostSetsForRack;
                            continue;
                        }
                        hostSets.addAll(hostSetsForRack);
                    }
                } else {
                    hostSets = SetUtils.split(tw.getHosts(), parallel);
                }
                int numBatchesNeeded = hostSets.size();
                int batchNum = 0;
                for (Set set : hostSets) {
                    String stageText = this.getStageText(verb, ctx.getComponentDisplay(service, pc.name), set, ++batchNum, numBatchesNeeded);
                    StageWrapper stage = new StageWrapper(type, stageText, params, new TaskWrapper(service, pc.name, (Set<String>)set, params, tw.getTasks()));
                    this.m_stages.add(stage);
                }
            }
        }

        private Map<String, Set<String>> organizeHostsByRack(Set<String> hosts, String rackYamlFile) {
            try {
                Map<String, String> hostToRackMap = DefaultBuilder.getHostToRackMap(rackYamlFile);
                HashMap<String, Set<String>> rackToHostsMap = new HashMap<String, Set<String>>();
                for (String host : hosts) {
                    if (hostToRackMap.containsKey(host)) {
                        String rack = hostToRackMap.get(host);
                        if (!rackToHostsMap.containsKey(rack)) {
                            rackToHostsMap.put(rack, new HashSet());
                        }
                        ((Set)rackToHostsMap.get(rack)).add(host);
                        continue;
                    }
                    throw new RuntimeException(String.format("Rack mapping is not present for host name: %s", host));
                }
                return rackToHostsMap;
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to generate Rack to Hosts mapping. filePath: %s", rackYamlFile), e);
            }
        }

        private static Map<String, String> getHostToRackMap(String rackYamlFile) throws IOException {
            Map rackHostsMap;
            try (YamlReader yamlReader = new YamlReader((Reader)new FileReader(rackYamlFile));){
                rackHostsMap = (Map)yamlReader.read();
            }
            Map racks = (Map)rackHostsMap.get(Grouping.RACKS_YAML_KEY_NAME);
            HashMap<String, String> hostToRackMap = new HashMap<String, String>();
            for (Map.Entry entry : racks.entrySet()) {
                Map rackInfoMap = (Map)entry.getValue();
                String rackName = (String)entry.getKey();
                if (rackInfoMap.containsKey(Grouping.HOSTS_YAML_KEY_NAME)) {
                    List hostList = (List)rackInfoMap.get(Grouping.HOSTS_YAML_KEY_NAME);
                    for (String host : hostList) {
                        hostToRackMap.put(host, rackName);
                    }
                }
                if (!rackInfoMap.containsKey(Grouping.HOST_GROUPS_YAML_KEY_NAME)) continue;
                List hostGroups = (List)rackInfoMap.get(Grouping.HOST_GROUPS_YAML_KEY_NAME);
                for (Map hostGroup : hostGroups) {
                    if (!hostGroup.containsKey(Grouping.HOSTS_YAML_KEY_NAME)) continue;
                    List hostList = (List)hostGroup.get(Grouping.HOSTS_YAML_KEY_NAME);
                    for (String host : hostList) {
                        hostToRackMap.put(host, rackName);
                    }
                }
            }
            return hostToRackMap;
        }

        @Override
        public List<StageWrapper> build(UpgradeContext upgradeContext, List<StageWrapper> stageWrappers) {
            if (!stageWrappers.isEmpty()) {
                this.m_stages.addAll(0, stageWrappers);
            }
            ArrayList<TaskWrapper> tasks = new ArrayList<TaskWrapper>();
            ArrayList<String> displays = new ArrayList<String>();
            for (String service : this.m_servicesToCheck) {
                tasks.add(new TaskWrapper(service, "", Collections.emptySet(), new ServiceCheckTask()));
                displays.add(upgradeContext.getServiceDisplay(service));
            }
            if (upgradeContext.getDirection().isUpgrade() && this.m_serviceCheck && this.m_servicesToCheck.size() > 0) {
                StageWrapper wrapper = new StageWrapper(StageWrapper.Type.SERVICE_CHECK, "Service Check " + StringUtils.join(displays, (String)", "), tasks.toArray(new TaskWrapper[0]));
                this.m_stages.add(wrapper);
            }
            return this.m_stages;
        }
    }

    private static class TaskBucket {
        private StageWrapper.Type type;
        private List<Task> tasks = new ArrayList<Task>();

        private TaskBucket(Task initial) {
            switch (initial.getType()) {
                case CONFIGURE: 
                case CREATE_AND_CONFIGURE: 
                case SERVER_ACTION: 
                case MANUAL: 
                case ADD_COMPONENT: {
                    this.type = StageWrapper.Type.SERVER_SIDE_ACTION;
                    break;
                }
                case EXECUTE: {
                    this.type = StageWrapper.Type.UPGRADE_TASKS;
                    break;
                }
                case CONFIGURE_FUNCTION: {
                    this.type = StageWrapper.Type.CONFIGURE;
                    break;
                }
                case RESTART: {
                    this.type = StageWrapper.Type.RESTART;
                    break;
                }
                case START: {
                    this.type = StageWrapper.Type.START;
                    break;
                }
                case STOP: {
                    this.type = StageWrapper.Type.STOP;
                    break;
                }
                case SERVICE_CHECK: {
                    this.type = StageWrapper.Type.SERVICE_CHECK;
                    break;
                }
                case REGENERATE_KEYTABS: {
                    this.type = StageWrapper.Type.REGENERATE_KEYTABS;
                }
            }
            this.tasks.add(initial);
        }
    }
}

