/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade;

import com.google.gson.Gson;
import id.onyx.obdp.server.serveraction.upgrades.ConfigureAction;
import id.onyx.obdp.server.stack.upgrade.ConfigUpgradeChangeDefinition;
import id.onyx.obdp.server.stack.upgrade.ConfigUpgradePack;
import id.onyx.obdp.server.stack.upgrade.PropertyKeyState;
import id.onyx.obdp.server.stack.upgrade.ServerSideActionTask;
import id.onyx.obdp.server.stack.upgrade.Task;
import id.onyx.obdp.server.stack.upgrade.TransferOperation;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapper;
import id.onyx.obdp.server.state.Cluster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="configure")
public class ConfigureTask
extends ServerSideActionTask {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigureTask.class);
    public static final String PARAMETER_CONFIG_TYPE = "configure-task-config-type";
    public static final String PARAMETER_KEY_VALUE_PAIRS = "configure-task-key-value-pairs";
    public static final String PARAMETER_TRANSFERS = "configure-task-transfers";
    public static final String PARAMETER_REPLACEMENTS = "configure-task-replacements";
    public static final String PARAMETER_INSERTIONS = "configure-task-insertions";
    public static final String PARAMETER_ASSOCIATED_SERVICE = "configure-task-associated-service";
    public static final String actionVerb = "Configuring";
    private Gson m_gson = new Gson();
    @XmlAttribute(name="id")
    public String id;
    @XmlAttribute(name="supports-patch")
    public boolean supportsPatch = false;
    @XmlTransient
    public String associatedService;

    public ConfigureTask() {
        this.implClass = ConfigureAction.class.getName();
    }

    @Override
    public Task.Type getType() {
        return Task.Type.CONFIGURE;
    }

    @Override
    public StageWrapper.Type getStageWrapperType() {
        return StageWrapper.Type.SERVER_SIDE_ACTION;
    }

    @Override
    public String getActionVerb() {
        return actionVerb;
    }

    public String getId() {
        return this.id;
    }

    public String getSummary(ConfigUpgradePack configUpgradePack) {
        ConfigUpgradeChangeDefinition definition;
        if (StringUtils.isNotBlank((String)this.id) && null != configUpgradePack && null != (definition = configUpgradePack.enumerateConfigChangesByID().get(this.id)) && StringUtils.isNotBlank((String)definition.summary)) {
            return definition.summary;
        }
        return super.getSummary();
    }

    public Map<String, String> getConfigurationChanges(Cluster cluster, ConfigUpgradePack configUpgradePack) {
        List<ConfigUpgradeChangeDefinition.Insert> insertions;
        List<ConfigUpgradeChangeDefinition.Transfer> transfers;
        HashMap<String, String> configParameters = new HashMap<String, String>();
        if (this.id == null || this.id.isEmpty()) {
            LOG.warn("Config task id is not defined, skipping config change");
            return configParameters;
        }
        if (configUpgradePack == null) {
            LOG.warn("Config upgrade pack is not defined, skipping config change");
            return configParameters;
        }
        ConfigUpgradeChangeDefinition definition = configUpgradePack.enumerateConfigChangesByID().get(this.id);
        if (definition == null) {
            LOG.warn(String.format("Can not resolve config change definition by id %s, skipping config change", this.id));
            return configParameters;
        }
        if (null != definition.getConfigType()) {
            configParameters.put(PARAMETER_CONFIG_TYPE, definition.getConfigType());
        }
        if (null != definition.getKeyValuePairs() && !definition.getKeyValuePairs().isEmpty()) {
            List<ConfigUpgradeChangeDefinition.ConfigurationKeyValue> allowedSets = this.getValidSets(cluster, definition.getConfigType(), definition.getKeyValuePairs());
            configParameters.put(PARAMETER_KEY_VALUE_PAIRS, this.m_gson.toJson(allowedSets));
        }
        if (null != (transfers = definition.getTransfers()) && !transfers.isEmpty()) {
            List<ConfigUpgradeChangeDefinition.Transfer> allowedTransfers = this.getValidTransfers(cluster, definition.getConfigType(), definition.getTransfers());
            configParameters.put(PARAMETER_TRANSFERS, this.m_gson.toJson(allowedTransfers));
        }
        ArrayList<ConfigUpgradeChangeDefinition.Replace> replacements = new ArrayList<ConfigUpgradeChangeDefinition.Replace>();
        replacements.addAll(definition.getReplacements());
        replacements.addAll(definition.getRegexReplacements(cluster));
        if (!replacements.isEmpty()) {
            List<ConfigUpgradeChangeDefinition.Replace> allowedReplacements = this.getValidReplacements(cluster, definition.getConfigType(), replacements);
            configParameters.put(PARAMETER_REPLACEMENTS, this.m_gson.toJson(allowedReplacements));
        }
        if (!(insertions = definition.getInsertions()).isEmpty()) {
            configParameters.put(PARAMETER_INSERTIONS, this.m_gson.toJson(insertions));
        }
        if (StringUtils.isNotEmpty((String)this.associatedService)) {
            configParameters.put(PARAMETER_ASSOCIATED_SERVICE, this.associatedService);
        }
        return configParameters;
    }

    private List<ConfigUpgradeChangeDefinition.Replace> getValidReplacements(Cluster cluster, String configType, List<ConfigUpgradeChangeDefinition.Replace> replacements) {
        ArrayList<ConfigUpgradeChangeDefinition.Replace> allowedReplacements = new ArrayList<ConfigUpgradeChangeDefinition.Replace>();
        for (ConfigUpgradeChangeDefinition.Replace replacement : replacements) {
            if (!this.isValidConditionSettings(cluster, configType, replacement.key, replacement.ifKey, replacement.ifType, replacement.ifValue, replacement.ifKeyState)) continue;
            allowedReplacements.add(replacement);
        }
        return allowedReplacements;
    }

    private List<ConfigUpgradeChangeDefinition.ConfigurationKeyValue> getValidSets(Cluster cluster, String configType, List<ConfigUpgradeChangeDefinition.ConfigurationKeyValue> sets) {
        ArrayList<ConfigUpgradeChangeDefinition.ConfigurationKeyValue> allowedSets = new ArrayList<ConfigUpgradeChangeDefinition.ConfigurationKeyValue>();
        for (ConfigUpgradeChangeDefinition.ConfigurationKeyValue configurationKeyValue : sets) {
            if (!this.isValidConditionSettings(cluster, configType, configurationKeyValue.key, configurationKeyValue.ifKey, configurationKeyValue.ifType, configurationKeyValue.ifValue, configurationKeyValue.ifKeyState)) continue;
            allowedSets.add(configurationKeyValue);
        }
        return allowedSets;
    }

    private List<ConfigUpgradeChangeDefinition.Transfer> getValidTransfers(Cluster cluster, String configType, List<ConfigUpgradeChangeDefinition.Transfer> transfers) {
        ArrayList<ConfigUpgradeChangeDefinition.Transfer> allowedTransfers = new ArrayList<ConfigUpgradeChangeDefinition.Transfer>();
        for (ConfigUpgradeChangeDefinition.Transfer transfer : transfers) {
            String key = "";
            key = transfer.operation == TransferOperation.DELETE ? transfer.deleteKey : transfer.fromKey;
            if (!this.isValidConditionSettings(cluster, configType, key, transfer.ifKey, transfer.ifType, transfer.ifValue, transfer.ifKeyState)) continue;
            allowedTransfers.add(transfer);
        }
        return allowedTransfers;
    }

    private boolean isValidConditionSettings(Cluster cluster, String configType, String targetPropertyKey, String ifKey, String ifType, String ifValue, PropertyKeyState ifKeyState) {
        boolean ifKeyStateIsValid;
        boolean isValid = false;
        boolean ifKeyIsNotBlank = StringUtils.isNotBlank((String)ifKey);
        boolean ifTypeIsNotBlank = StringUtils.isNotBlank((String)ifType);
        boolean ifValueIsNotNull = null != ifValue;
        boolean bl = ifKeyStateIsValid = PropertyKeyState.PRESENT == ifKeyState || PropertyKeyState.ABSENT == ifKeyState;
        if (ifKeyIsNotBlank && ifTypeIsNotBlank && (ifValueIsNotNull || ifKeyStateIsValid)) {
            isValid = true;
        } else if (!(ifKeyIsNotBlank || ifTypeIsNotBlank || ifValueIsNotNull || ifKeyStateIsValid)) {
            isValid = true;
        }
        return isValid;
    }
}

