/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade;

import com.google.common.base.MoreObjects;
import id.onyx.obdp.server.stack.upgrade.Condition;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Config;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;

@XmlType(name="config")
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class ConfigurationCondition
extends Condition {
    @XmlAttribute(name="type")
    public String type;
    @XmlAttribute(name="property")
    public String property;
    @XmlAttribute(name="value")
    public String value;
    @XmlAttribute(name="return_value_if_config_missing")
    public boolean returnValueIfConfigMissing;
    @XmlAttribute(name="comparison")
    public ComparisonType comparisonType;

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("property", (Object)this.property).add("value", (Object)this.value).add("comparison", (Object)this.comparisonType).omitNullValues().toString();
    }

    @Override
    public boolean isSatisfied(UpgradeContext upgradeContext) {
        Cluster cluster = upgradeContext.getCluster();
        boolean propertyExists = false;
        Config config = cluster.getDesiredConfigByType(this.type);
        Map<String, String> properties = null;
        if (null != config && (properties = config.getProperties()).containsKey(this.property)) {
            propertyExists = true;
        }
        if (this.comparisonType == ComparisonType.EXISTS) {
            return propertyExists;
        }
        if (this.comparisonType == ComparisonType.NOT_EXISTS) {
            return !propertyExists;
        }
        if (!propertyExists) {
            return this.returnValueIfConfigMissing;
        }
        String propertyValue = properties.get(this.property);
        switch (this.comparisonType) {
            case EQUALS: {
                return StringUtils.equals((String)propertyValue, (String)this.value);
            }
            case NOT_EQUALS: {
                return !StringUtils.equals((String)propertyValue, (String)this.value);
            }
            case CONTAINS: {
                return StringUtils.contains((String)propertyValue, (String)this.value);
            }
            case NOT_CONTAINS: {
                return !StringUtils.contains((String)propertyValue, (String)this.value);
            }
        }
        return false;
    }

    @XmlEnum
    public static enum ComparisonType {
        EQUALS,
        NOT_EQUALS,
        CONTAINS,
        NOT_CONTAINS,
        EXISTS,
        NOT_EXISTS;

    }
}

