/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade;

import id.onyx.obdp.server.stack.upgrade.ConfigUpgradeChangeDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="upgrade-config-changes")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ConfigUpgradePack {
    @XmlElementWrapper(name="services")
    @XmlElement(name="service")
    public List<AffectedService> services;
    private Map<String, ConfigUpgradeChangeDefinition> changesById;
    private static final Logger LOG = LoggerFactory.getLogger(ConfigUpgradePack.class);

    public ConfigUpgradePack() {
    }

    public ConfigUpgradePack(List<AffectedService> services) {
        this.services = services;
    }

    public Map<String, AffectedService> getServiceMap() {
        HashMap<String, AffectedService> result = new HashMap<String, AffectedService>();
        for (AffectedService service : this.services) {
            result.put(service.name, service);
        }
        return result;
    }

    public Map<String, ConfigUpgradeChangeDefinition> enumerateConfigChangesByID() {
        if (this.changesById == null) {
            this.changesById = new HashMap<String, ConfigUpgradeChangeDefinition>();
            for (AffectedService service : this.services) {
                for (AffectedComponent component : service.components) {
                    for (ConfigUpgradeChangeDefinition changeDefinition : component.changes) {
                        if (changeDefinition.id == null) {
                            LOG.warn(String.format("Config upgrade change definition for service %s, component %s has no id", service.name, component.name));
                        } else if (this.changesById.containsKey(changeDefinition.id)) {
                            LOG.warn("Duplicate config upgrade change definition with ID " + changeDefinition.id);
                        }
                        this.changesById.put(changeDefinition.id, changeDefinition);
                    }
                }
            }
        }
        return this.changesById;
    }

    public static ConfigUpgradePack merge(ArrayList<ConfigUpgradePack> cups) {
        Map mergedComponentMap;
        HashMap mergedServiceMap = new HashMap();
        for (ConfigUpgradePack configUpgradePack : cups) {
            for (AffectedService service : configUpgradePack.services) {
                if (!mergedServiceMap.containsKey(service.name)) {
                    mergedServiceMap.put(service.name, new HashMap());
                }
                mergedComponentMap = (Map)mergedServiceMap.get(service.name);
                for (AffectedComponent component : service.components) {
                    AffectedComponent mergedComponent;
                    if (!mergedComponentMap.containsKey(component.name)) {
                        mergedComponent = new AffectedComponent();
                        mergedComponent.name = component.name;
                        mergedComponent.changes = new ArrayList<ConfigUpgradeChangeDefinition>();
                        mergedComponentMap.put(component.name, mergedComponent);
                    }
                    mergedComponent = (AffectedComponent)mergedComponentMap.get(component.name);
                    mergedComponent.changes.addAll(component.changes);
                }
            }
        }
        ArrayList<AffectedService> mergedServices = new ArrayList<AffectedService>();
        for (String serviceName : mergedServiceMap.keySet()) {
            AffectedService mergedService = new AffectedService();
            mergedComponentMap = (Map)mergedServiceMap.get(serviceName);
            mergedService.name = serviceName;
            mergedService.components = new ArrayList(mergedComponentMap.values());
            mergedServices.add(mergedService);
        }
        return new ConfigUpgradePack(mergedServices);
    }

    public static class AffectedService {
        @XmlAttribute
        public String name;
        @XmlElement(name="component")
        public List<AffectedComponent> components;

        public Map<String, AffectedComponent> getComponentMap() {
            HashMap<String, AffectedComponent> result = new HashMap<String, AffectedComponent>();
            for (AffectedComponent component : this.components) {
                result.put(component.name, component);
            }
            return result;
        }
    }

    public static class AffectedComponent {
        @XmlAttribute
        public String name;
        @XmlElementWrapper(name="changes")
        @XmlElement(name="definition")
        public List<ConfigUpgradeChangeDefinition> changes;
    }
}

