/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade;

import com.google.common.base.MoreObjects;
import id.onyx.obdp.server.stack.upgrade.PropertyKeyState;
import id.onyx.obdp.server.stack.upgrade.TransferCoercionType;
import id.onyx.obdp.server.stack.upgrade.TransferOperation;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ConfigUpgradeChangeDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigUpgradeChangeDefinition.class);
    public static final String PARAMETER_CONFIG_TYPE = "configure-task-config-type";
    public static final String PARAMETER_KEY_VALUE_PAIRS = "configure-task-key-value-pairs";
    public static final String PARAMETER_TRANSFERS = "configure-task-transfers";
    public static final String PARAMETER_REPLACEMENTS = "configure-task-replacements";
    public static final String actionVerb = "Configuring";
    public static final Float DEFAULT_PRIORITY = Float.valueOf(1.0f);
    @XmlAttribute(name="summary")
    public String summary;
    @XmlAttribute(name="id", required=true)
    public String id;
    @XmlElement(name="type")
    private String configType;
    @XmlElement(name="set")
    private List<ConfigurationKeyValue> keyValuePairs;
    @XmlElement(name="transfer")
    private List<Transfer> transfers;
    @XmlElement(name="replace")
    private List<Replace> replacements;
    @XmlElement(name="regex-replace")
    private List<RegexReplace> regexReplacements;
    @XmlElement(name="insert")
    private List<Insert> inserts;

    public String getConfigType() {
        return this.configType;
    }

    public List<ConfigurationKeyValue> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    public List<Transfer> getTransfers() {
        if (null == this.transfers) {
            return Collections.emptyList();
        }
        ArrayList<Transfer> list = new ArrayList<Transfer>();
        for (Transfer t : this.transfers) {
            switch (t.operation) {
                case COPY: 
                case MOVE: {
                    if (null != t.fromKey && null != t.toKey) {
                        list.add(t);
                        break;
                    }
                    LOG.warn(String.format("Transfer %s is invalid", t));
                    break;
                }
                case DELETE: {
                    if (null != t.deleteKey) {
                        list.add(t);
                        break;
                    }
                    LOG.warn(String.format("Transfer %s is invalid", t));
                }
            }
        }
        return list;
    }

    public List<Replace> getReplacements() {
        if (null == this.replacements) {
            return Collections.emptyList();
        }
        ArrayList<Replace> list = new ArrayList<Replace>();
        for (Replace r : this.replacements) {
            if (StringUtils.isBlank((String)r.key) || StringUtils.isEmpty((String)r.find) || null == r.replaceWith) {
                LOG.warn(String.format("Replacement %s is invalid", r));
                continue;
            }
            list.add(r);
        }
        return list;
    }

    public List<Replace> getRegexReplacements(Cluster cluster) {
        if (null == this.regexReplacements) {
            return Collections.emptyList();
        }
        ArrayList<Replace> list = new ArrayList<Replace>();
        for (RegexReplace regexReplaceObj : this.regexReplacements) {
            if (StringUtils.isBlank((String)regexReplaceObj.key) || StringUtils.isEmpty((String)regexReplaceObj.find) || null == regexReplaceObj.replaceWith) {
                LOG.warn(String.format("Replacement %s is invalid", regexReplaceObj));
                continue;
            }
            try {
                Replace rep;
                Config config = cluster.getDesiredConfigByType(this.configType);
                Map<String, String> properties = config.getProperties();
                String content = properties.get(regexReplaceObj.key);
                Pattern REGEX = Pattern.compile(regexReplaceObj.find, 8);
                Matcher patternMatchObj = REGEX.matcher(content);
                if (regexReplaceObj.matchAll) {
                    while (patternMatchObj.find()) {
                        regexReplaceObj.find = patternMatchObj.group();
                        if (!StringUtils.isNotBlank((String)regexReplaceObj.find)) continue;
                        rep = regexReplaceObj.copyToReplaceObject();
                        list.add(rep);
                    }
                    continue;
                }
                if (!patternMatchObj.find() || patternMatchObj.groupCount() != 1) continue;
                regexReplaceObj.find = patternMatchObj.group();
                rep = regexReplaceObj.copyToReplaceObject();
                list.add(rep);
            }
            catch (Exception e) {
                LOG.error(String.format("There was an error while trying to execute a regex replacement for %s/%s. The regular expression was %s", this.configType, regexReplaceObj.key, regexReplaceObj.find), (Throwable)e);
            }
        }
        return list;
    }

    public List<Insert> getInsertions() {
        if (null == this.inserts) {
            return Collections.emptyList();
        }
        return this.inserts;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="transfer")
    public static class Transfer
    extends Masked {
        @XmlAttribute(name="operation")
        public TransferOperation operation;
        @XmlAttribute(name="from-type")
        public String fromType;
        @XmlAttribute(name="from-key")
        public String fromKey;
        @XmlAttribute(name="to-key")
        public String toKey;
        @XmlAttribute(name="delete-key")
        public String deleteKey;
        @XmlAttribute(name="preserve-edits")
        public boolean preserveEdits = false;
        @XmlAttribute(name="default-value")
        public String defaultValue;
        @XmlAttribute(name="coerce-to")
        public TransferCoercionType coerceTo;
        @XmlElement(name="keep-key")
        public List<String> keepKeys = new ArrayList<String>();

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("operation", (Object)this.operation).add("fromType", (Object)this.fromType).add("fromKey", (Object)this.fromKey).add("toKey", (Object)this.toKey).add("deleteKey", (Object)this.deleteKey).add("preserveEdits", this.preserveEdits).add("defaultValue", (Object)this.defaultValue).add("coerceTo", (Object)this.coerceTo).add("ifKey", (Object)this.ifKey).add("ifType", (Object)this.ifType).add("ifValue", (Object)this.ifValue).add("ifKeyState", (Object)this.ifKeyState).add("keepKeys", this.keepKeys).omitNullValues().toString();
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="replace")
    public static class Replace
    extends Masked {
        @XmlAttribute(name="key")
        public String key;
        @XmlAttribute(name="find")
        public String find;
        @XmlAttribute(name="replace-with")
        public String replaceWith;

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("find", (Object)this.find).add("replaceWith", (Object)this.replaceWith).add("ifKey", (Object)this.ifKey).add("ifType", (Object)this.ifType).add("ifValue", (Object)this.ifValue).add("ifKeyState", (Object)this.ifKeyState).omitNullValues().toString();
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="regex-replace")
    public static class RegexReplace
    extends Masked {
        @XmlAttribute(name="key")
        public String key;
        @XmlAttribute(name="find")
        public String find;
        @XmlAttribute(name="replace-with")
        public String replaceWith;
        @XmlAttribute(name="match-all")
        public boolean matchAll = false;

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("find", (Object)this.find).add("replaceWith", (Object)this.replaceWith).add("ifKey", (Object)this.ifKey).add("ifType", (Object)this.ifType).add("ifValue", (Object)this.ifValue).add("ifKeyState", (Object)this.ifKeyState).omitNullValues().toString();
        }

        public Replace copyToReplaceObject() {
            Replace rep = new Replace();
            rep.find = this.find;
            rep.key = this.key;
            rep.replaceWith = this.replaceWith;
            rep.ifKey = this.ifKey;
            rep.ifType = this.ifType;
            rep.ifValue = this.ifValue;
            rep.ifKeyState = this.ifKeyState;
            return rep;
        }
    }

    @XmlEnum
    public static enum IfValueMatchType {
        EXACT,
        PARTIAL;

    }

    @XmlEnum
    public static enum InsertType {
        PREPEND,
        APPEND;

    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="insert")
    public static class Insert
    extends Masked {
        @XmlAttribute(name="key", required=true)
        public String key;
        @XmlAttribute(name="value", required=true)
        public String value;
        @XmlAttribute(name="insert-type", required=true)
        public InsertType insertType = InsertType.APPEND;
        @XmlAttribute(name="newline-before")
        public boolean newlineBefore = false;
        @XmlAttribute(name="newline-after")
        public boolean newlineAfter = false;

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("insertType", (Object)this.insertType).add("key", (Object)this.key).add("value", (Object)this.value).add("newlineBefore", this.newlineBefore).add("newlineAfter", this.newlineAfter).omitNullValues().toString();
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="set")
    public static class ConfigurationKeyValue
    extends Masked {
        @XmlAttribute(name="key")
        public String key;
        @XmlAttribute(name="value")
        public String value;

        public String toString() {
            return MoreObjects.toStringHelper((String)"Set").add("key", (Object)this.key).add("value", (Object)this.value).add("ifKey", (Object)this.ifKey).add("ifType", (Object)this.ifType).add("ifValue", (Object)this.ifValue).add("ifKeyState", (Object)this.ifKeyState).omitNullValues().toString();
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Masked
    extends ConditionalField {
        @XmlAttribute(name="mask")
        public boolean mask = false;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ConditionalField {
        @XmlAttribute(name="if-key")
        public String ifKey;
        @XmlAttribute(name="if-type")
        public String ifType;
        @XmlAttribute(name="if-value")
        public String ifValue;
        @XmlAttribute(name="if-value-not-matched")
        public boolean ifValueNotMatched = false;
        @XmlAttribute(name="if-value-match-type")
        public IfValueMatchType ifValueMatchType = IfValueMatchType.EXACT;
        @XmlAttribute(name="if-key-state")
        public PropertyKeyState ifKeyState;
    }
}

