/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import id.onyx.obdp.server.stack.HostsType;
import id.onyx.obdp.server.stack.upgrade.Batch;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.stack.upgrade.Grouping;
import id.onyx.obdp.server.stack.upgrade.ManualTask;
import id.onyx.obdp.server.stack.upgrade.ParallelScheduler;
import id.onyx.obdp.server.stack.upgrade.RestartTask;
import id.onyx.obdp.server.stack.upgrade.ServiceCheckTask;
import id.onyx.obdp.server.stack.upgrade.Task;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapperBuilder;
import id.onyx.obdp.server.stack.upgrade.orchestrate.TaskWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.TaskWrapperBuilder;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.utils.SetUtils;
import id.onyx.obdp.spi.upgrade.OrchestrationOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlType(name="colocated")
public class ColocatedGrouping
extends Grouping {
    private static final Logger LOG = LoggerFactory.getLogger(ColocatedGrouping.class);
    @XmlElement(name="batch")
    public Batch batch;

    @Override
    public StageWrapperBuilder getBuilder() {
        return new MultiHomedBuilder(this, this.batch, this.performServiceCheck, this.parallelScheduler);
    }

    private static class MultiHomedBuilder
    extends StageWrapperBuilder {
        private Batch m_batch;
        private boolean m_serviceCheck = true;
        private List<TaskProxy> initialBatch = new LinkedList<TaskProxy>();
        private List<TaskProxy> finalBatches = new LinkedList<TaskProxy>();

        private MultiHomedBuilder(Grouping grouping, Batch batch, boolean serviceCheck, ParallelScheduler parallel) {
            super(grouping);
            this.m_batch = batch;
            this.m_serviceCheck = serviceCheck;
        }

        @Override
        public void add(UpgradeContext context, HostsType hostsType, String service, boolean clientOnly, UpgradePack.ProcessingComponent pc, Map<String, String> params) {
            int count = Double.valueOf(Math.ceil((double)this.m_batch.percent / 100.0 * (double)hostsType.getHosts().size())).intValue();
            LinkedHashSet first = new LinkedHashSet();
            LinkedHashSet remaining = new LinkedHashSet();
            hostsType.getHosts().stream().forEach(hostName -> {
                if (first.size() < count) {
                    first.add(hostName);
                } else {
                    remaining.add(hostName);
                }
            });
            List<Task> preTasks = this.resolveTasks(context, true, pc);
            Task task = this.resolveTask(context, pc);
            List<Task> postTasks = this.resolveTasks(context, false, pc);
            AtomicBoolean processInitial = new AtomicBoolean(true);
            int parallelCount = -1;
            OrchestrationOptions options = context.getOrchestrationOptions();
            if (null != options) {
                parallelCount = context.getOrchestrationOptions().getConcurrencyCount(context.getCluster().buildClusterInformation(), service, pc.name);
            }
            if (parallelCount < 1) {
                parallelCount = this.getParallelHostCount(context, 1);
            }
            int hostCount = parallelCount;
            Stream.of(first, remaining).forEach(hosts -> {
                List<TaskProxy> targetList = processInitial.get() ? this.initialBatch : this.finalBatches;
                List<Set<Set>> hostSplit = SetUtils.split(hosts, hostCount);
                hostSplit.forEach(hostSet -> {
                    TaskProxy proxy;
                    StageWrapper.Type type;
                    List tasks = preTasks;
                    if (CollectionUtils.isNotEmpty((Collection)preTasks)) {
                        type = ((Task)preTasks.get(0)).getStageWrapperType();
                        proxy = new TaskProxy();
                        proxy.clientOnly = clientOnly;
                        proxy.message = this.getStageText("Preparing", context.getComponentDisplay(service, pc.name), (Set<String>)hostSet);
                        proxy.tasks.addAll(TaskWrapperBuilder.getTaskList(service, pc.name, HostsType.normal(new LinkedHashSet<String>((Collection<String>)hostSet)), tasks, params));
                        proxy.service = service;
                        proxy.component = pc.name;
                        proxy.type = type;
                        targetList.add(proxy);
                    }
                    if (null != task && RestartTask.class.isInstance(task)) {
                        proxy = new TaskProxy();
                        proxy.clientOnly = clientOnly;
                        proxy.tasks.add(new TaskWrapper(service, pc.name, (Set<String>)hostSet, params, task));
                        proxy.restart = true;
                        proxy.service = service;
                        proxy.component = pc.name;
                        proxy.type = StageWrapper.Type.RESTART;
                        proxy.message = this.getStageText("Restarting", context.getComponentDisplay(service, pc.name), (Set<String>)hostSet);
                        targetList.add(proxy);
                    }
                    tasks = postTasks;
                    if (CollectionUtils.isNotEmpty((Collection)preTasks)) {
                        type = ((Task)preTasks.get(0)).getStageWrapperType();
                        proxy = new TaskProxy();
                        proxy.clientOnly = clientOnly;
                        proxy.message = this.getStageText("Completing", context.getComponentDisplay(service, pc.name), (Set<String>)hostSet);
                        proxy.tasks.addAll(TaskWrapperBuilder.getTaskList(service, pc.name, HostsType.normal(new LinkedHashSet<String>((Collection<String>)hostSet)), tasks, params));
                        proxy.service = service;
                        proxy.component = pc.name;
                        proxy.type = type;
                        targetList.add(proxy);
                    }
                });
                processInitial.set(false);
            });
        }

        @Override
        public List<StageWrapper> build(UpgradeContext upgradeContext, List<StageWrapper> stageWrappers) {
            final ArrayList visitedServerSideTasks = new ArrayList();
            Predicate<Task> predicate = new Predicate<Task>(){

                public boolean apply(Task input) {
                    if (visitedServerSideTasks.contains(input)) {
                        return false;
                    }
                    if (input.getType().isServerAction()) {
                        visitedServerSideTasks.add(input);
                    }
                    return true;
                }
            };
            ArrayList<StageWrapper> results = new ArrayList<StageWrapper>(stageWrappers);
            if (LOG.isDebugEnabled()) {
                LOG.debug("RU initial: {}", this.initialBatch);
                LOG.debug("RU final: {}", this.finalBatches);
            }
            List<StageWrapper> befores = this.fromProxies(upgradeContext.getDirection(), this.initialBatch, predicate);
            results.addAll(befores);
            if (!befores.isEmpty()) {
                ManualTask task = new ManualTask();
                task.summary = this.m_batch.summary;
                ArrayList<String> messages = new ArrayList<String>();
                messages.add(this.m_batch.message);
                task.messages = messages;
                this.formatFirstBatch(upgradeContext, task, befores);
                StageWrapper wrapper = new StageWrapper(StageWrapper.Type.SERVER_SIDE_ACTION, "Validate Partial " + upgradeContext.getDirection().getText(true), new TaskWrapper(null, null, Collections.emptySet(), task));
                results.add(wrapper);
            }
            results.addAll(this.fromProxies(upgradeContext.getDirection(), this.finalBatches, predicate));
            return results;
        }

        private List<StageWrapper> fromProxies(Direction direction, List<TaskProxy> proxies, Predicate<Task> predicate) {
            ArrayList<StageWrapper> results = new ArrayList<StageWrapper>();
            HashSet serviceChecks = new HashSet();
            proxies.forEach(proxy -> {
                StageWrapper wrapper = null;
                ArrayList<StageWrapper> execwrappers = new ArrayList<StageWrapper>();
                if (!proxy.clientOnly) {
                    serviceChecks.add(proxy.service);
                }
                if (!proxy.restart) {
                    Object[] tasks = proxy.getTasksArray(predicate);
                    if (LOG.isDebugEnabled()) {
                        for (Object tw : tasks) {
                            LOG.debug("{}", tw);
                        }
                    }
                    if (ArrayUtils.isNotEmpty((Object[])tasks)) {
                        wrapper = new StageWrapper(proxy.type, proxy.message, (TaskWrapper[])tasks);
                    }
                } else {
                    TaskWrapper[] tasks = proxy.getTasksArray(null);
                    if (LOG.isDebugEnabled()) {
                        for (TaskWrapper tw : tasks) {
                            LOG.debug("{}", (Object)tw);
                        }
                    }
                    execwrappers.add(new StageWrapper(StageWrapper.Type.RESTART, proxy.message, tasks));
                }
                if (null != wrapper) {
                    results.add(wrapper);
                }
                if (execwrappers.size() > 0) {
                    results.addAll(execwrappers);
                }
            });
            if (direction.isUpgrade() && this.m_serviceCheck && serviceChecks.size() > 0) {
                ArrayList<TaskWrapper> tasks = new ArrayList<TaskWrapper>();
                HashSet<String> displays = new HashSet<String>();
                for (String service : serviceChecks) {
                    tasks.add(new TaskWrapper(service, "", Collections.emptySet(), new ServiceCheckTask()));
                    displays.add(service);
                }
                StageWrapper wrapper = new StageWrapper(StageWrapper.Type.SERVICE_CHECK, "Service Check " + StringUtils.join(displays, (String)", "), tasks.toArray(new TaskWrapper[tasks.size()]));
                results.add(wrapper);
            }
            return results;
        }

        private void formatFirstBatch(UpgradeContext ctx, ManualTask task, List<StageWrapper> wrappers) {
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            HashMap compLocations = new HashMap();
            for (StageWrapper sw : wrappers) {
                for (TaskWrapper tw : sw.getTasks()) {
                    if (!StringUtils.isNotEmpty((String)tw.getService()) || !StringUtils.isNotBlank((String)tw.getComponent())) continue;
                    for (String host : tw.getHosts()) {
                        if (!compLocations.containsKey(host)) {
                            compLocations.put(host, new HashSet());
                        }
                        ((Set)compLocations.get(host)).add(tw.getComponent());
                    }
                    names.add(ctx.getComponentDisplay(tw.getService(), tw.getComponent()));
                }
            }
            for (int i = 0; i < task.messages.size(); ++i) {
                Object message = (String)task.messages.get(i);
                if (!((String)message).contains("{{components}}")) continue;
                StringBuilder stringBuilder = new StringBuilder();
                ArrayList compNames = new ArrayList(names);
                if (compNames.size() == 1) {
                    stringBuilder.append((String)compNames.get(0));
                } else if (names.size() > 1) {
                    String last = (String)compNames.remove(compNames.size() - 1);
                    stringBuilder.append(StringUtils.join(compNames, (String)", "));
                    stringBuilder.append(" and ").append(last);
                }
                message = ((String)message).replace("{{components}}", stringBuilder.toString());
                task.messages.set(i, message);
            }
            JsonArray arr = new JsonArray();
            for (Map.Entry entry : compLocations.entrySet()) {
                JsonObject obj = new JsonObject();
                obj.addProperty("host_name", (String)entry.getKey());
                JsonArray comps = new JsonArray();
                for (String comp : (Set)entry.getValue()) {
                    comps.add((JsonElement)new JsonPrimitive(comp));
                }
                obj.add("components", (JsonElement)comps);
                arr.add((JsonElement)obj);
            }
            JsonObject master = new JsonObject();
            master.add("topology", (JsonElement)arr);
            task.structuredOut = master.toString();
        }
    }

    private static class TaskProxy {
        private boolean restart = false;
        private String service;
        private String component;
        private String message;
        private StageWrapper.Type type;
        private boolean clientOnly = false;
        private List<TaskWrapper> tasks = new ArrayList<TaskWrapper>();

        private TaskProxy() {
        }

        public String toString() {
            Object s = "";
            for (TaskWrapper t : this.tasks) {
                s = (String)s + this.component + "/" + t.getTasks() + " ";
            }
            return s;
        }

        private TaskWrapper[] getTasksArray(Predicate<Task> predicate) {
            if (null == predicate) {
                return this.tasks.toArray(new TaskWrapper[this.tasks.size()]);
            }
            ArrayList<TaskWrapper> interim = new ArrayList<TaskWrapper>();
            for (TaskWrapper wrapper : this.tasks) {
                Collection filtered = Collections2.filter(wrapper.getTasks(), predicate);
                if (!CollectionUtils.isNotEmpty((Collection)filtered)) continue;
                interim.add(wrapper);
            }
            return interim.toArray(new TaskWrapper[interim.size()]);
        }
    }
}

