/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack.upgrade;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.stack.HostsType;
import id.onyx.obdp.server.stack.upgrade.ExecuteHostType;
import id.onyx.obdp.server.stack.upgrade.ExecuteStage;
import id.onyx.obdp.server.stack.upgrade.ExecuteTask;
import id.onyx.obdp.server.stack.upgrade.Grouping;
import id.onyx.obdp.server.stack.upgrade.Task;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapperBuilder;
import id.onyx.obdp.server.stack.upgrade.orchestrate.TaskWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.MaintenanceState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="cluster")
public class ClusterGrouping
extends Grouping {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterGrouping.class);
    @XmlElement(name="execute-stage")
    public List<ExecuteStage> executionStages;

    @Override
    public ClusterBuilder getBuilder() {
        return new ClusterBuilder(this);
    }

    @Override
    protected boolean serviceCheckAfterProcessing() {
        return false;
    }

    private StageWrapper getServerActionStageWrapper(UpgradeContext ctx, ExecuteStage execution) {
        String service = execution.service;
        String component = execution.component;
        Task task = execution.task;
        Set<String> realHosts = Collections.emptySet();
        if (StringUtils.isNotEmpty((String)service) && StringUtils.isNotEmpty((String)component)) {
            HostsType hosts = ctx.getResolver().getMasterAndHosts(service, component);
            if (null == hosts || hosts.getHosts().isEmpty()) {
                return null;
            }
            realHosts = new LinkedHashSet<String>(hosts.getHosts());
        }
        if (Task.Type.MANUAL == task.getType()) {
            return new StageWrapper(StageWrapper.Type.SERVER_SIDE_ACTION, execution.title, new TaskWrapper(service, component, realHosts, task));
        }
        return new StageWrapper(StageWrapper.Type.SERVER_SIDE_ACTION, execution.title, new TaskWrapper(null, null, Collections.emptySet(), task));
    }

    private StageWrapper getRegenerateKeytabsWrapper(UpgradeContext ctx, ExecuteStage execution) {
        Task task = execution.task;
        HostsType hosts = HostsType.healthy(ctx.getCluster());
        return new StageWrapper(StageWrapper.Type.REGENERATE_KEYTABS, execution.title, new TaskWrapper(null, null, hosts.getHosts(), task));
    }

    private StageWrapper getExecuteStageWrapper(UpgradeContext ctx, ExecuteStage execution) {
        String service = execution.service;
        String component = execution.component;
        ExecuteTask et = (ExecuteTask)execution.task;
        if (StringUtils.isNotBlank((String)service) && StringUtils.isNotBlank((String)component)) {
            if (!ctx.isScoped(execution.scope)) {
                return null;
            }
            if (!ctx.isServiceSupported(service)) {
                return null;
            }
            HostsType hosts = ctx.getResolver().getMasterAndHosts(service, component);
            if (hosts != null) {
                Set<String> realHosts = new LinkedHashSet<String>(hosts.getHosts());
                if (ExecuteHostType.MASTER == et.hosts && hosts.hasMasters()) {
                    realHosts = hosts.getMasters();
                }
                if (ExecuteHostType.ANY == et.hosts && !hosts.getHosts().isEmpty()) {
                    realHosts = Collections.singleton(hosts.getHosts().iterator().next());
                }
                if (ExecuteHostType.FIRST == et.hosts && !hosts.getHighAvailabilityHosts().isEmpty()) {
                    ArrayList<String> sortedHosts = new ArrayList<String>(hosts.getHosts());
                    Collections.sort(sortedHosts, String.CASE_INSENSITIVE_ORDER);
                    realHosts = Collections.singleton((String)sortedHosts.get(0));
                }
                if (realHosts.isEmpty()) {
                    return null;
                }
                return new StageWrapper(StageWrapper.Type.UPGRADE_TASKS, execution.title, new TaskWrapper(service, component, realHosts, et));
            }
        } else if (null == service && null == component) {
            Cluster cluster = ctx.getCluster();
            HashSet<String> hostNames = new HashSet<String>();
            for (Host host : ctx.getCluster().getHosts()) {
                MaintenanceState maintenanceState = host.getMaintenanceState(cluster.getClusterId());
                if (maintenanceState != MaintenanceState.OFF) continue;
                hostNames.add(host.getHostName());
            }
            return new StageWrapper(StageWrapper.Type.UPGRADE_TASKS, execution.title, new TaskWrapper(service, component, hostNames, et));
        }
        return null;
    }

    @Override
    public void merge(Iterator<Grouping> iterator) throws OBDPException {
        if (this.executionStages == null) {
            this.executionStages = new ArrayList<ExecuteStage>();
        }
        HashMap<String, List<ExecuteStage>> skippedStages = new HashMap<String, List<ExecuteStage>>();
        while (iterator.hasNext()) {
            Grouping next = iterator.next();
            if (!(next instanceof ClusterGrouping)) {
                throw new OBDPException("Invalid group type " + next.getClass().getSimpleName() + " expected cluster group");
            }
            ClusterGrouping clusterGroup = (ClusterGrouping)next;
            boolean added = this.addGroupingStages(clusterGroup.executionStages, clusterGroup.addAfterGroupEntry);
            if (added) {
                this.addSkippedStages(skippedStages, clusterGroup.executionStages);
                continue;
            }
            if (skippedStages.containsKey(next.addAfterGroupEntry)) {
                List tmp = (List)skippedStages.get(clusterGroup.addAfterGroupEntry);
                tmp.addAll(clusterGroup.executionStages);
                continue;
            }
            skippedStages.put(clusterGroup.addAfterGroupEntry, clusterGroup.executionStages);
        }
    }

    private boolean addGroupingStages(List<ExecuteStage> stagesToAdd, String after) {
        if (after == null) {
            this.executionStages.addAll(stagesToAdd);
            return true;
        }
        for (int index = this.executionStages.size() - 1; index >= 0; --index) {
            ExecuteStage stage = this.executionStages.get(index);
            if ((stage.service == null || !stage.service.equals(after)) && !stage.title.equals(after)) continue;
            this.executionStages.addAll(index + 1, stagesToAdd);
            return true;
        }
        return false;
    }

    private void addSkippedStages(Map<String, List<ExecuteStage>> skippedStages, List<ExecuteStage> stagesJustAdded) {
        for (ExecuteStage stage : stagesJustAdded) {
            if (!skippedStages.containsKey(stage.service)) continue;
            List<ExecuteStage> stagesToAdd = skippedStages.remove(stage.service);
            this.addGroupingStages(stagesToAdd, stage.service);
            this.addSkippedStages(skippedStages, stagesToAdd);
        }
    }

    public class ClusterBuilder
    extends StageWrapperBuilder {
        private ClusterBuilder(Grouping grouping) {
            super(grouping);
        }

        @Override
        public void add(UpgradeContext ctx, HostsType hostsType, String service, boolean clientOnly, UpgradePack.ProcessingComponent pc, Map<String, String> params) {
        }

        @Override
        public List<StageWrapper> build(UpgradeContext upgradeContext, List<StageWrapper> stageWrappers) {
            if (null == ClusterGrouping.this.executionStages) {
                return stageWrappers;
            }
            ArrayList<StageWrapper> results = new ArrayList<StageWrapper>(stageWrappers);
            for (ExecuteStage execution : ClusterGrouping.this.executionStages) {
                if (null != execution.intendedDirection && execution.intendedDirection != upgradeContext.getDirection()) continue;
                if (null != execution.condition && !execution.condition.isSatisfied(upgradeContext)) {
                    LOG.info("Skipping {} while building upgrade orchestration due to {}", (Object)execution, (Object)execution.condition);
                    continue;
                }
                if (StringUtils.isNotBlank((String)execution.service) && !upgradeContext.isServiceSupported(execution.service)) continue;
                if (null != execution.task.condition && !execution.task.condition.isSatisfied(upgradeContext)) {
                    LOG.info("Skipping {} while building upgrade orchestration due to {}", (Object)execution, (Object)execution.task.condition);
                    continue;
                }
                Task task = execution.task;
                StageWrapper wrapper = null;
                switch (task.getType()) {
                    case MANUAL: 
                    case SERVER_ACTION: 
                    case CONFIGURE: 
                    case ADD_COMPONENT: {
                        wrapper = ClusterGrouping.this.getServerActionStageWrapper(upgradeContext, execution);
                        break;
                    }
                    case EXECUTE: {
                        wrapper = ClusterGrouping.this.getExecuteStageWrapper(upgradeContext, execution);
                        break;
                    }
                    case REGENERATE_KEYTABS: {
                        wrapper = ClusterGrouping.this.getRegenerateKeytabsWrapper(upgradeContext, execution);
                        break;
                    }
                }
                if (null == wrapper) continue;
                results.add(wrapper);
            }
            return results;
        }
    }
}

