/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import com.google.common.collect.ListMultimap;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.ClusterServiceEntity;
import id.onyx.obdp.server.orm.entities.RepoOsEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.stack.RepoUtil;
import id.onyx.obdp.server.stack.StackManager;
import id.onyx.obdp.server.stack.upgrade.RepositoryVersionHelper;
import id.onyx.obdp.server.state.RepositoryInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateActiveRepoVersionOnStartup {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateActiveRepoVersionOnStartup.class);
    ClusterDAO clusterDao;
    RepositoryVersionDAO repositoryVersionDao;
    RepositoryVersionHelper repositoryVersionHelper;
    StackManager stackManager;

    @Inject
    public UpdateActiveRepoVersionOnStartup(ClusterDAO clusterDao, RepositoryVersionDAO repositoryVersionDao, RepositoryVersionHelper repositoryVersionHelper, OBDPMetaInfo metaInfo) {
        this.clusterDao = clusterDao;
        this.repositoryVersionDao = repositoryVersionDao;
        this.repositoryVersionHelper = repositoryVersionHelper;
        this.stackManager = metaInfo.getStackManager();
    }

    @Transactional
    public void process() throws OBDPException {
        LOG.info("Updating existing repo versions with service repos.");
        try {
            List<ClusterEntity> clusters = this.clusterDao.findAll();
            for (ClusterEntity cluster : clusters) {
                for (ClusterServiceEntity service : cluster.getClusterServiceEntities()) {
                    RepositoryVersionEntity repositoryVersion = service.getServiceDesiredStateEntity().getDesiredRepositoryVersion();
                    StackId stackId = repositoryVersion.getStackId();
                    StackInfo stack = this.stackManager.getStack(stackId.getStackName(), stackId.getStackVersion());
                    if (stack != null) {
                        if (!this.updateRepoVersion(stack, repositoryVersion)) continue;
                        this.repositoryVersionDao.merge(repositoryVersion);
                        continue;
                    }
                    throw new OBDPException(String.format("Stack %s %s was not found on the file system. In the event that it was removed, please ensure that it exists before starting Ambari Server.", stackId.getStackName(), stackId.getStackVersion()));
                }
            }
        }
        catch (Exception ex) {
            throw new OBDPException("An error occured during updating current repository versions with stack repositories.", (Throwable)ex);
        }
    }

    private boolean updateRepoVersion(StackInfo stackInfo, RepositoryVersionEntity repoVersion) throws Exception {
        ListMultimap<String, RepositoryInfo> serviceReposByOs = stackInfo.getRepositoriesByOs();
        List<RepoOsEntity> operatingSystems = repoVersion.getRepoOsEntities();
        boolean changed = RepoUtil.addServiceReposToOperatingSystemEntities(operatingSystems, serviceReposByOs);
        if (changed) {
            repoVersion.addRepoOsEntities(operatingSystems);
        }
        return changed;
    }
}

