/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import com.fasterxml.jackson.databind.ObjectMapper;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.stack.BaseModule;
import id.onyx.obdp.server.stack.ExtensionModule;
import id.onyx.obdp.server.stack.ServiceModule;
import id.onyx.obdp.server.stack.StackModule;
import id.onyx.obdp.server.stack.Validable;
import id.onyx.obdp.server.state.ThemeInfo;
import id.onyx.obdp.server.state.theme.Theme;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeModule
extends BaseModule<ThemeModule, ThemeInfo>
implements Validable {
    private static final Logger LOG = LoggerFactory.getLogger(ThemeModule.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    public static final String THEME_KEY = "Theme";
    private ThemeInfo moduleInfo;
    private boolean valid = true;
    private Set<String> errors = new HashSet<String>();

    public ThemeModule(File themeFile) {
        this(themeFile, new ThemeInfo());
    }

    public ThemeModule(File themeFile, ThemeInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
        if (!moduleInfo.isDeleted().booleanValue() && themeFile != null) {
            LOG.debug("Looking for theme in {}", (Object)themeFile.getAbsolutePath());
            FileReader reader = null;
            try {
                reader = new FileReader(themeFile);
            }
            catch (FileNotFoundException e) {
                LOG.error("Theme file not found");
            }
            try {
                Theme theme = (Theme)mapper.readValue((Reader)reader, Theme.class);
                HashMap<String, Theme> map = new HashMap<String, Theme>();
                map.put(THEME_KEY, theme);
                moduleInfo.setThemeMap(map);
                LOG.debug("Loaded theme: {}", (Object)moduleInfo);
            }
            catch (IOException e) {
                LOG.error("Unable to parse theme file ", (Throwable)e);
                this.setValid(false);
                this.addError("Unable to parse theme file " + themeFile);
            }
        }
    }

    public ThemeModule(ThemeInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }

    @Override
    public void resolve(ThemeModule parent, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        ThemeInfo parentModuleInfo = parent.getModuleInfo();
        if (parent.getModuleInfo() != null && !this.moduleInfo.isDeleted().booleanValue()) {
            if (this.moduleInfo.getThemeMap() == null || this.moduleInfo.getThemeMap().isEmpty()) {
                this.moduleInfo.setThemeMap(parentModuleInfo.getThemeMap());
            } else if (parentModuleInfo.getThemeMap() != null && !parentModuleInfo.getThemeMap().isEmpty()) {
                Theme childTheme = this.moduleInfo.getThemeMap().get(THEME_KEY);
                Theme parentTheme = parentModuleInfo.getThemeMap().get(THEME_KEY);
                childTheme.mergeWithParent(parentTheme);
            }
        }
    }

    @Override
    public ThemeInfo getModuleInfo() {
        return this.moduleInfo;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public String getId() {
        return this.moduleInfo.getFileName();
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public void addError(String error) {
        this.errors.add(error);
    }

    @Override
    public void addErrors(Collection<String> errors) {
        this.errors.addAll(errors);
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }
}

