/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.stack.RepoUtil;
import id.onyx.obdp.server.stack.RepositoryFolderAndXml;
import id.onyx.obdp.server.stack.ServiceDirectory;
import id.onyx.obdp.server.state.stack.RepositoryXml;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackServiceDirectory
extends ServiceDirectory {
    private static final Logger LOG = LoggerFactory.getLogger(StackServiceDirectory.class);
    @Nullable
    private RepositoryXml repoFile;
    @Nullable
    private String repoDir;

    public StackServiceDirectory(String servicePath) throws OBDPException {
        super(servicePath);
    }

    @Nullable
    public RepositoryXml getRepoFile() {
        return this.repoFile;
    }

    @Nullable
    public String getRepoDir() {
        return this.repoDir;
    }

    @Override
    public String getAdvisorName(String serviceName) {
        if (this.getAdvisorFile() == null || serviceName == null) {
            return null;
        }
        File serviceDir = new File(this.getAbsolutePath());
        File stackVersionDir = serviceDir.getParentFile().getParentFile();
        File stackDir = stackVersionDir.getParentFile();
        String stackName = stackDir.getName();
        String versionString = stackVersionDir.getName().replaceAll("\\.", "");
        Object advisorClassName = stackName + versionString + serviceName + "ServiceAdvisor";
        advisorClassName = ((String)advisorClassName).replaceAll("[^a-zA-Z0-9]+", "");
        return advisorClassName;
    }

    private void parseRepoFile(Collection<String> subDirs) {
        RepositoryFolderAndXml repoDirAndXml = RepoUtil.parseRepoFile(this.directory, subDirs, this.unmarshaller);
        this.repoDir = (String)repoDirAndXml.repoDir.orNull();
        this.repoFile = (RepositoryXml)repoDirAndXml.repoXml.orNull();
        if (this.repoFile == null || !this.repoFile.isValid()) {
            LOG.info("No repository information defined for , serviceName=" + this.getName() + ", repoFolder=" + this.getPath() + File.separator + "repos");
        }
    }

    @Override
    protected void parsePath() throws OBDPException {
        super.parsePath();
        List<String> subDirs = Arrays.asList(this.directory.list());
        this.parseRepoFile(subDirs);
    }

    @Override
    protected File getResourcesDirectory() {
        File serviceDir = new File(this.getAbsolutePath());
        return serviceDir.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
    }

    @Override
    public String getService() {
        File serviceDir = new File(this.getAbsolutePath());
        return serviceDir.getName();
    }

    @Override
    public String getStack() {
        File serviceDir = new File(this.getAbsolutePath());
        File stackVersionDir = serviceDir.getParentFile().getParentFile();
        File stackDir = stackVersionDir.getParentFile();
        String stackId = String.format("%s-%s", stackDir.getName(), stackVersionDir.getName());
        return stackId;
    }
}

