/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.stack.BaseModule;
import id.onyx.obdp.server.stack.ConfigurationDirectory;
import id.onyx.obdp.server.stack.ConfigurationModule;
import id.onyx.obdp.server.stack.ExtensionModule;
import id.onyx.obdp.server.stack.ModuleFileUnmarshaller;
import id.onyx.obdp.server.stack.ModuleState;
import id.onyx.obdp.server.stack.ServiceDirectory;
import id.onyx.obdp.server.stack.ServiceModule;
import id.onyx.obdp.server.stack.StackContext;
import id.onyx.obdp.server.stack.StackDirectory;
import id.onyx.obdp.server.stack.StackServiceDirectory;
import id.onyx.obdp.server.stack.Validable;
import id.onyx.obdp.server.stack.upgrade.ConfigUpgradePack;
import id.onyx.obdp.server.stack.upgrade.Grouping;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.state.BulkCommandDefinition;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.ExtensionInfo;
import id.onyx.obdp.server.state.PropertyDependencyInfo;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.RefreshCommand;
import id.onyx.obdp.server.state.RepositoryInfo;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.stack.RepositoryXml;
import id.onyx.obdp.server.state.stack.ServiceMetainfoXml;
import id.onyx.obdp.server.state.stack.StackMetainfoXml;
import java.io.File;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackModule
extends BaseModule<StackModule, StackInfo>
implements Validable {
    private StackContext stackContext;
    private Map<String, ConfigurationModule> configurationModules = new HashMap<String, ConfigurationModule>();
    private Map<String, ServiceModule> serviceModules = new HashMap<String, ServiceModule>();
    private Map<String, ExtensionModule> extensionModules = new HashMap<String, ExtensionModule>();
    private StackInfo stackInfo;
    private StackDirectory stackDirectory;
    private String id;
    protected boolean valid = true;
    ModuleFileUnmarshaller unmarshaller = new ModuleFileUnmarshaller();
    private static final Logger LOG = LoggerFactory.getLogger(StackModule.class);
    private Set<String> errorSet = new HashSet<String>();

    public StackModule(StackDirectory stackDirectory, StackContext stackContext) {
        this.stackDirectory = stackDirectory;
        this.stackContext = stackContext;
        this.stackInfo = new StackInfo();
        this.populateStackInfo();
    }

    public Map<String, ServiceModule> getServiceModules() {
        return this.serviceModules;
    }

    public Map<String, ExtensionModule> getExtensionModules() {
        return this.extensionModules;
    }

    @Override
    public void resolve(StackModule parentModule, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        this.moduleState = ModuleState.VISITED;
        LOG.info(String.format("Resolve: %s:%s", this.stackInfo.getName(), this.stackInfo.getVersion()));
        String parentVersion = this.stackInfo.getParentStackVersion();
        this.mergeServicesWithExplicitParent(allStacks, commonServices, extensions);
        this.addExtensionServices();
        if (parentVersion != null) {
            this.mergeStackWithParent(parentVersion, allStacks, commonServices, extensions);
        }
        for (ExtensionInfo extension : this.stackInfo.getExtensions()) {
            String extensionKey = extension.getName() + "/" + extension.getVersion();
            ExtensionModule extensionModule = extensions.get(extensionKey);
            if (extensionModule == null) {
                throw new OBDPException("Extension '" + this.stackInfo.getName() + ":" + this.stackInfo.getVersion() + "' specifies an extension " + extensionKey + " that doesn't exist");
            }
            this.mergeStackWithExtension(extensionModule, allStacks, commonServices, extensions);
        }
        this.processUpgradePacks();
        this.processRepositories();
        this.processPropertyDependencies();
        this.validateBulkCommandComponents(allStacks);
        this.moduleState = ModuleState.RESOLVED;
    }

    @Override
    public StackInfo getModuleInfo() {
        return this.stackInfo;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void finalizeModule() {
        this.finalizeChildModules(this.serviceModules.values());
        this.finalizeChildModules(this.configurationModules.values());
        for (ServiceModule module : this.serviceModules.values()) {
            this.mergeRoleCommandOrder(module);
        }
        ArrayList<String> servicesWithNoConfigs = new ArrayList<String>();
        for (ServiceModule serviceModule : this.serviceModules.values()) {
            if (serviceModule.hasConfigs()) continue;
            servicesWithNoConfigs.add(serviceModule.getId());
        }
        this.stackInfo.setServicesWithNoConfigs(servicesWithNoConfigs);
    }

    public StackDirectory getStackDirectory() {
        return this.stackDirectory;
    }

    private void mergeStackWithParent(String parentVersion, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        String parentStackKey = this.stackInfo.getName() + "/" + parentVersion;
        StackModule parentStack = allStacks.get(parentStackKey);
        if (parentStack == null) {
            throw new OBDPException("Stack '" + this.stackInfo.getName() + ":" + this.stackInfo.getVersion() + "' specifies a parent that doesn't exist");
        }
        this.resolveStack(parentStack, allStacks, commonServices, extensions);
        this.mergeConfigurations(parentStack, allStacks, commonServices, extensions);
        this.mergeRoleCommandOrder(parentStack);
        if (this.stackInfo.getKerberosDescriptorPreConfigurationFileLocation() == null) {
            this.stackInfo.setKerberosDescriptorPreConfigurationFileLocation(parentStack.getModuleInfo().getKerberosDescriptorPreConfigurationFileLocation());
        }
        this.mergeServicesWithParent(parentStack, allStacks, commonServices, extensions);
    }

    private void mergeStackWithExtension(ExtensionModule extension, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
    }

    private void mergeServicesWithParent(StackModule parentStack, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        this.stackInfo.getServices().clear();
        Collection<ServiceModule> mergedModules = this.mergeChildModules(allStacks, commonServices, extensions, this.serviceModules, parentStack.serviceModules);
        ArrayList<String> removedServices = new ArrayList<String>();
        for (ServiceModule module : mergedModules) {
            if (module.isDeleted()) {
                removedServices.add(module.getId());
                continue;
            }
            this.serviceModules.put(module.getId(), module);
            this.stackInfo.getServices().add(module.getModuleInfo());
        }
        this.stackInfo.setRemovedServices(removedServices);
    }

    private void mergeServicesWithExplicitParent(Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        for (ServiceModule service : this.serviceModules.values()) {
            ServiceInfo serviceInfo = service.getModuleInfo();
            String parent = serviceInfo.getParent();
            if (parent == null) continue;
            this.mergeServiceWithExplicitParent(service, parent, allStacks, commonServices, extensions);
        }
    }

    private void mergeServiceWithExplicitParent(ServiceModule service, String parent, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        LOG.info(String.format("Merge service %s with explicit parent: %s", service.getModuleInfo().getName(), parent));
        if (this.isCommonServiceParent(parent)) {
            this.mergeServiceWithCommonServiceParent(service, parent, allStacks, commonServices, extensions);
        } else if (this.isExtensionServiceParent(parent)) {
            this.mergeServiceWithExtensionServiceParent(service, parent, allStacks, commonServices, extensions);
        } else {
            this.mergeServiceWithStackServiceParent(service, parent, allStacks, commonServices, extensions);
        }
    }

    private boolean isCommonServiceParent(String parent) {
        return parent != null && !parent.isEmpty() && parent.split("/")[0].equalsIgnoreCase("common-services");
    }

    private boolean isExtensionServiceParent(String parent) {
        return parent != null && !parent.isEmpty() && parent.split("/")[0].equalsIgnoreCase("extensions");
    }

    private void addExtensionServices() throws OBDPException {
        for (ExtensionModule extension : this.extensionModules.values()) {
            for (Map.Entry<String, ServiceModule> entry : extension.getServiceModules().entrySet()) {
                this.serviceModules.put(entry.getKey(), entry.getValue());
            }
            this.stackInfo.addExtension(extension.getModuleInfo());
        }
    }

    private void mergeServiceWithCommonServiceParent(ServiceModule service, String parent, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        ServiceInfo serviceInfo = service.getModuleInfo();
        String[] parentToks = parent.split("/");
        if (parentToks.length != 3 || !parentToks[0].equalsIgnoreCase("common-services")) {
            throw new OBDPException("The service '" + serviceInfo.getName() + "' in stack '" + this.stackInfo.getName() + ":" + this.stackInfo.getVersion() + "' extends an invalid parent: '" + parent + "'");
        }
        String baseServiceKey = parentToks[1] + "/" + parentToks[2];
        ServiceModule baseService = commonServices.get(baseServiceKey);
        if (baseService == null) {
            this.setValid(false);
            this.stackInfo.setValid(false);
            String error = "The service '" + serviceInfo.getName() + "' in stack '" + this.stackInfo.getName() + ":" + this.stackInfo.getVersion() + "' extends a non-existent service: '" + parent + "'";
            this.addError(error);
            this.stackInfo.addError(error);
        } else if (baseService.isValid()) {
            service.resolveExplicit(baseService, allStacks, commonServices, extensions);
        } else {
            this.setValid(false);
            this.stackInfo.setValid(false);
            this.addErrors(baseService.getErrors());
            this.stackInfo.addErrors(baseService.getErrors());
        }
    }

    private void mergeServiceWithExtensionServiceParent(ServiceModule service, String parent, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        ServiceInfo serviceInfo = service.getModuleInfo();
        String[] parentToks = parent.split("/");
        if (parentToks.length != 4 || !parentToks[0].equalsIgnoreCase("extensions")) {
            throw new OBDPException("The service '" + serviceInfo.getName() + "' in stack '" + this.stackInfo.getName() + ":" + this.stackInfo.getVersion() + "' extends an invalid parent: '" + parent + "'");
        }
        String extensionKey = parentToks[1] + "/" + parentToks[2];
        ExtensionModule extension = extensions.get(extensionKey);
        if (extension == null || !extension.isValid()) {
            this.setValid(false);
            this.addError("The service '" + serviceInfo.getName() + "' in stack '" + this.stackInfo.getName() + ":" + this.stackInfo.getVersion() + "' extends a non-existent service: '" + parent + "'");
        } else {
            this.resolveExtension(extension, allStacks, commonServices, extensions);
            ServiceModule parentService = extension.getServiceModules().get(parentToks[3]);
            if (parentService == null || !parentService.isValid()) {
                this.setValid(false);
                this.addError("The service '" + serviceInfo.getName() + "' in stack '" + this.stackInfo.getName() + ":" + this.stackInfo.getVersion() + "' extends a non-existent service: '" + parent + "'");
            } else {
                service.resolve(parentService, allStacks, commonServices, extensions);
            }
        }
    }

    private void mergeServiceWithStackServiceParent(ServiceModule service, String parent, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        ServiceInfo serviceInfo = service.getModuleInfo();
        String[] parentToks = parent.split("/");
        if (parentToks.length != 3 || parentToks[0].equalsIgnoreCase("extensions") || parentToks[0].equalsIgnoreCase("common-services")) {
            throw new OBDPException("The service '" + serviceInfo.getName() + "' in stack '" + this.stackInfo.getName() + ":" + this.stackInfo.getVersion() + "' extends an invalid parent: '" + parent + "'");
        }
        String baseStackKey = parentToks[0] + "/" + parentToks[1];
        StackModule baseStack = allStacks.get(baseStackKey);
        if (baseStack == null) {
            throw new OBDPException("The service '" + serviceInfo.getName() + "' in stack '" + this.stackInfo.getName() + ":" + this.stackInfo.getVersion() + "' extends a service in a non-existent stack: '" + baseStackKey + "'");
        }
        this.resolveStack(baseStack, allStacks, commonServices, extensions);
        ServiceModule baseService = baseStack.serviceModules.get(parentToks[2]);
        if (baseService == null) {
            throw new OBDPException("The service '" + serviceInfo.getName() + "' in stack '" + this.stackInfo.getName() + ":" + this.stackInfo.getVersion() + "' extends a non-existent service: '" + parent + "'");
        }
        service.resolveExplicit(baseService, allStacks, commonServices, extensions);
    }

    private void populateStackInfo() {
        this.stackInfo.setName(this.stackDirectory.getStackDirName());
        this.stackInfo.setVersion(this.stackDirectory.getName());
        this.id = String.format("%s:%s", this.stackInfo.getName(), this.stackInfo.getVersion());
        LOG.debug("Adding new stack to known stacks, stackName = {}, stackVersion = {}", (Object)this.stackInfo.getName(), (Object)this.stackInfo.getVersion());
        StackMetainfoXml smx = this.stackDirectory.getMetaInfoFile();
        if (smx != null) {
            if (!smx.isValid()) {
                this.stackInfo.setValid(false);
                this.stackInfo.addErrors(smx.getErrors());
            }
            this.stackInfo.setMinJdk(smx.getMinJdk());
            this.stackInfo.setMaxJdk(smx.getMaxJdk());
            this.stackInfo.setActive(smx.getVersion().isActive());
            this.stackInfo.setParentStackVersion(smx.getExtends());
            this.stackInfo.setRcoFileLocation(this.stackDirectory.getRcoFilePath());
            this.stackInfo.setKerberosDescriptorPreConfigurationFileLocation(this.stackDirectory.getKerberosDescriptorPreconfigureFilePath());
            this.stackInfo.setUpgradesFolder(this.stackDirectory.getUpgradesDir());
            this.stackInfo.setUpgradePacks(this.stackDirectory.getUpgradePacks());
            this.stackInfo.setConfigUpgradePack(this.stackDirectory.getConfigUpgradePack());
            this.stackInfo.setRoleCommandOrder(this.stackDirectory.getRoleCommandOrder());
            this.stackInfo.setReleaseVersionClass(smx.getVersion().getReleaseVersion());
            this.stackInfo.setLibraryClassLoader(this.stackDirectory.getLibraryClassLoader());
            this.populateConfigurationModules();
        }
        try {
            RepositoryXml rxml = this.stackDirectory.getRepoFile();
            if (rxml != null && !rxml.isValid()) {
                this.stackInfo.setValid(false);
                this.stackInfo.addErrors(rxml.getErrors());
            }
            this.populateServices();
            if (!this.stackInfo.isValid()) {
                this.setValid(false);
                this.addErrors(this.stackInfo.getErrors());
            }
        }
        catch (Exception e) {
            String error = "Exception caught while populating services for stack: " + this.stackInfo.getName() + "-" + this.stackInfo.getVersion();
            this.setValid(false);
            this.stackInfo.setValid(false);
            this.addError(error);
            this.stackInfo.addError(error);
            LOG.error(error);
        }
    }

    private void populateServices() throws OBDPException {
        for (ServiceDirectory serviceDir : this.stackDirectory.getServiceDirectories()) {
            this.populateService(serviceDir);
        }
    }

    private void populateService(ServiceDirectory serviceDirectory) {
        ArrayList<ServiceModule> serviceModules = new ArrayList<ServiceModule>();
        ServiceMetainfoXml metaInfoXml = serviceDirectory.getMetaInfoFile();
        if (!metaInfoXml.isValid()) {
            this.stackInfo.setValid(metaInfoXml.isValid());
            this.setValid(metaInfoXml.isValid());
            this.stackInfo.addErrors(metaInfoXml.getErrors());
            this.addErrors(metaInfoXml.getErrors());
            return;
        }
        List<ServiceInfo> serviceInfos = metaInfoXml.getServices();
        for (ServiceInfo serviceInfo : serviceInfos) {
            ServiceModule serviceModule = new ServiceModule(this.stackContext, serviceInfo, serviceDirectory);
            serviceModules.add(serviceModule);
            if (serviceModule.isValid()) continue;
            this.stackInfo.setValid(false);
            this.setValid(false);
            this.stackInfo.addErrors(serviceModule.getErrors());
            this.addErrors(serviceModule.getErrors());
        }
        this.addServices(serviceModules);
    }

    private void populateConfigurationModules() {
        ConfigurationDirectory configDirectory = this.stackDirectory.getConfigurationDirectory("configuration", "properties");
        if (configDirectory != null) {
            for (ConfigurationModule config : configDirectory.getConfigurationModules()) {
                if (this.stackInfo.isValid()) {
                    this.stackInfo.setValid(config.isValid());
                    this.stackInfo.addErrors(config.getErrors());
                }
                this.stackInfo.getProperties().addAll(config.getModuleInfo().getProperties());
                this.stackInfo.setConfigTypeAttributes(config.getConfigType(), config.getModuleInfo().getAttributes());
                this.configurationModules.put(config.getConfigType(), config);
            }
        }
    }

    private void mergeConfigurations(StackModule parent, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        this.stackInfo.getProperties().clear();
        this.stackInfo.setAllConfigAttributes(new HashMap<String, Map<String, Map<String, String>>>());
        Collection<ConfigurationModule> mergedModules = this.mergeChildModules(allStacks, commonServices, extensions, this.configurationModules, parent.configurationModules);
        for (ConfigurationModule module : mergedModules) {
            if (module.isDeleted()) continue;
            this.configurationModules.put(module.getId(), module);
            this.stackInfo.getProperties().addAll(module.getModuleInfo().getProperties());
            this.stackInfo.setConfigTypeAttributes(module.getConfigType(), module.getModuleInfo().getAttributes());
        }
    }

    private void resolveStack(StackModule stackToBeResolved, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        if (stackToBeResolved.getModuleState() == ModuleState.INIT) {
            stackToBeResolved.resolve(null, allStacks, commonServices, extensions);
        } else if (stackToBeResolved.getModuleState() == ModuleState.VISITED) {
            throw new OBDPException("Cycle detected while parsing stack definition");
        }
        if (!stackToBeResolved.isValid() || stackToBeResolved.getModuleInfo() != null && !stackToBeResolved.getModuleInfo().isValid()) {
            this.setValid(stackToBeResolved.isValid());
            this.stackInfo.setValid(stackToBeResolved.stackInfo.isValid());
            this.addErrors(stackToBeResolved.getErrors());
            this.stackInfo.addErrors(stackToBeResolved.getErrors());
        }
    }

    private void resolveExtension(ExtensionModule extension, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        if (extension.getModuleState() == ModuleState.INIT) {
            extension.resolve(null, allStacks, commonServices, extensions);
        } else if (extension.getModuleState() == ModuleState.VISITED) {
            throw new OBDPException("Cycle detected while parsing extension definition");
        }
        if (!extension.isValid() || extension.getModuleInfo() != null && !extension.getModuleInfo().isValid()) {
            this.setValid(false);
            this.addError("Stack includes an invalid extension: " + extension.getModuleInfo().getName());
        }
    }

    private void addService(ServiceModule service) {
        ServiceInfo serviceInfo = service.getModuleInfo();
        ServiceModule previousValue = this.serviceModules.put(service.getId(), service);
        if (previousValue == null) {
            this.stackInfo.getServices().add(serviceInfo);
        }
    }

    private void addServices(Collection<ServiceModule> services) {
        for (ServiceModule service : services) {
            this.addService(service);
        }
    }

    private void processPropertyDependencies() {
        HashMap<PropertyDependencyInfo, Set<PropertyDependencyInfo>> dependedByMap = new HashMap<PropertyDependencyInfo, Set<PropertyDependencyInfo>>();
        for (ServiceModule serviceModule : this.serviceModules.values()) {
            HashMap<String, Map<String, String>> componentRefreshCommandsMap = new HashMap<String, Map<String, String>>();
            for (PropertyInfo pi : serviceModule.getModuleInfo().getProperties()) {
                for (PropertyDependencyInfo pdi : pi.getDependsOnProperties()) {
                    String type = ConfigHelper.fileNameToConfigType(pi.getFilename());
                    String name = pi.getName();
                    PropertyDependencyInfo propertyDependency = new PropertyDependencyInfo(type, name);
                    if (dependedByMap.keySet().contains(pdi)) {
                        ((Set)dependedByMap.get(pdi)).add(propertyDependency);
                        continue;
                    }
                    HashSet<PropertyDependencyInfo> newDependenciesSet = new HashSet<PropertyDependencyInfo>();
                    newDependenciesSet.add(propertyDependency);
                    dependedByMap.put(pdi, newDependenciesSet);
                }
                if (pi.getSupportedRefreshCommands() == null || pi.getSupportedRefreshCommands().size() <= 0) continue;
                String type = ConfigHelper.fileNameToConfigType(pi.getFilename());
                String propertyName = type + "/" + pi.getName();
                HashMap<String, String> refreshCommandPropertyMap = (HashMap<String, String>)componentRefreshCommandsMap.get(propertyName);
                for (RefreshCommand refreshCommand : pi.getSupportedRefreshCommands()) {
                    String componentName = refreshCommand.getComponentName();
                    if (refreshCommandPropertyMap == null) {
                        refreshCommandPropertyMap = new HashMap<String, String>();
                        componentRefreshCommandsMap.put(propertyName, refreshCommandPropertyMap);
                    }
                    refreshCommandPropertyMap.put(componentName, refreshCommand.getCommand());
                }
            }
            this.stackInfo.getRefreshCommandConfiguration().addRefreshCommands(componentRefreshCommandsMap);
        }
        for (ServiceModule serviceModule : this.serviceModules.values()) {
            this.addDependedByProperties(dependedByMap, serviceModule.getModuleInfo().getProperties());
        }
        this.addDependedByProperties(dependedByMap, this.stackInfo.getProperties());
    }

    private void addDependedByProperties(Map<PropertyDependencyInfo, Set<PropertyDependencyInfo>> dependedByMap, Collection<PropertyInfo> properties) {
        for (PropertyInfo pi : properties) {
            String name;
            String type = ConfigHelper.fileNameToConfigType(pi.getFilename());
            Set<PropertyDependencyInfo> set = dependedByMap.remove(new PropertyDependencyInfo(type, name = pi.getName()));
            if (set == null) continue;
            pi.getDependedByProperties().addAll(set);
        }
    }

    private void processUpgradePacks() throws OBDPException {
        if (this.stackInfo.getUpgradePacks() == null) {
            return;
        }
        for (UpgradePack pack : this.stackInfo.getUpgradePacks().values()) {
            ArrayList<UpgradePack> servicePacks = new ArrayList<UpgradePack>();
            for (ServiceModule module : this.serviceModules.values()) {
                UpgradePack servicePack;
                File upgradesFolder = module.getModuleInfo().getServiceUpgradesFolder();
                if (upgradesFolder == null || (servicePack = this.getServiceUpgradePack(pack, upgradesFolder)) == null) continue;
                servicePacks.add(servicePack);
            }
            if (servicePacks.size() <= 0) continue;
            LOG.info("Merging service specific upgrades for pack: " + pack.getName());
            this.mergeUpgradePack(pack, servicePacks);
        }
        ConfigUpgradePack configPack = this.stackInfo.getConfigUpgradePack();
        if (configPack == null) {
            return;
        }
        for (ServiceModule module : this.serviceModules.values()) {
            File upgradesFolder = module.getModuleInfo().getServiceUpgradesFolder();
            if (upgradesFolder == null) continue;
            this.mergeConfigUpgradePack(configPack, upgradesFolder);
        }
    }

    private void mergeConfigUpgradePack(ConfigUpgradePack pack, File upgradesFolder) throws OBDPException {
        File stackFolder = new File(upgradesFolder, this.stackInfo.getName());
        File versionFolder = new File(stackFolder, this.stackInfo.getVersion());
        File serviceConfig = new File(versionFolder, "config-upgrade.xml");
        if (!serviceConfig.exists()) {
            return;
        }
        try {
            ConfigUpgradePack serviceConfigPack = this.unmarshaller.unmarshal(ConfigUpgradePack.class, serviceConfig);
            pack.services.addAll(serviceConfigPack.services);
        }
        catch (Exception e) {
            throw new OBDPException("Unable to parse service config upgrade file at location: " + serviceConfig.getAbsolutePath(), (Throwable)e);
        }
    }

    private UpgradePack getServiceUpgradePack(UpgradePack pack, File upgradesFolder) throws OBDPException {
        File stackFolder = new File(upgradesFolder, this.stackInfo.getName());
        File versionFolder = new File(stackFolder, this.stackInfo.getVersion());
        File servicePackFile = new File(versionFolder, pack.getName() + ".xml");
        LOG.info("Service folder: " + servicePackFile.getAbsolutePath());
        if (servicePackFile.exists()) {
            return this.parseServiceUpgradePack(pack, servicePackFile);
        }
        UpgradePack child = this.findServiceUpgradePack(pack, stackFolder);
        return null == child ? null : this.parseServiceUpgradePack(pack, child);
    }

    private void mergeUpgradePack(UpgradePack pack, List<UpgradePack> servicePacks) throws OBDPException {
        List<Grouping> originalGroups = pack.getAllGroups();
        HashMap<String, Object> allGroupMap = new HashMap<String, Object>();
        for (Grouping group : originalGroups) {
            ArrayList<Grouping> list = new ArrayList<Grouping>();
            list.add(group);
            allGroupMap.put(group.name, list);
        }
        for (UpgradePack servicePack : servicePacks) {
            for (Grouping group : servicePack.getAllGroups()) {
                List<Grouping> list;
                if (servicePack.isAllTarget() && !allGroupMap.keySet().contains(group.addAfterGroup)) {
                    LOG.warn("Service Upgrade Pack specified after-group of {}, but that is not found in {}", (Object)group.addAfterGroup, (Object)StringUtils.join(allGroupMap.keySet(), (char)','));
                    continue;
                }
                if (allGroupMap.containsKey(group.name)) {
                    list = (List)allGroupMap.get(group.name);
                    Grouping first = (Grouping)list.get(0);
                    if (!first.getClass().equals(group.getClass())) {
                        throw new OBDPException("Expected class: " + first.getClass() + " instead of " + group.getClass());
                    }
                    if (group.addAfterGroupEntry == null && first.addAfterGroupEntry != null) {
                        list.add(0, group);
                        continue;
                    }
                    list.add(group);
                    continue;
                }
                list = new ArrayList<Grouping>();
                list.add(group);
                allGroupMap.put(group.name, list);
            }
        }
        HashMap<String, Grouping> mergedGroupMap = new HashMap<String, Grouping>();
        for (String key : allGroupMap.keySet()) {
            Iterator<Grouping> iterator = ((List)allGroupMap.get(key)).iterator();
            Grouping group = (Grouping)iterator.next();
            if (iterator.hasNext()) {
                group.merge(iterator);
            }
            mergedGroupMap.put(key, group);
        }
        this.orderGroups(originalGroups, mergedGroupMap);
    }

    private void orderGroups(List<Grouping> groups, Map<String, Grouping> mergedGroupMap) throws OBDPException {
        HashMap<String, List<Grouping>> skippedGroups = new HashMap<String, List<Grouping>>();
        for (Map.Entry<String, Grouping> entry : mergedGroupMap.entrySet()) {
            Grouping group = entry.getValue();
            if (groups.contains(group)) continue;
            boolean added = this.addGrouping(groups, group);
            if (added) {
                this.addSkippedGroup(groups, skippedGroups, group);
                continue;
            }
            List<Grouping> tmp = null;
            if (skippedGroups.containsKey(group.addAfterGroup)) {
                tmp = (List)skippedGroups.get(group.addAfterGroup);
            } else {
                tmp = new ArrayList();
                skippedGroups.put(group.addAfterGroup, tmp);
            }
            tmp.add(group);
        }
        if (!skippedGroups.isEmpty()) {
            throw new OBDPException("Missing groups: " + skippedGroups.keySet());
        }
    }

    private boolean addGrouping(List<Grouping> groups, Grouping group) throws OBDPException {
        if (group.addAfterGroup == null) {
            throw new OBDPException("Group " + group.name + " needs to specify which group it should come after");
        }
        for (int index = groups.size() - 1; index >= 0; --index) {
            String name = groups.get((int)index).name;
            if (!name.equals(group.addAfterGroup)) continue;
            groups.add(index + 1, group);
            LOG.debug("Added group/after: {}/{}", (Object)group.name, (Object)group.addAfterGroup);
            return true;
        }
        return false;
    }

    private void addSkippedGroup(List<Grouping> groups, Map<String, List<Grouping>> skippedGroups, Grouping groupJustAdded) throws OBDPException {
        if (skippedGroups.containsKey(groupJustAdded.name)) {
            List<Grouping> groupsToAdd = skippedGroups.remove(groupJustAdded.name);
            for (Grouping group : groupsToAdd) {
                boolean added = this.addGrouping(groups, group);
                if (added) {
                    this.addSkippedGroup(groups, skippedGroups, group);
                    continue;
                }
                throw new OBDPException("Failed to add group " + group.name);
            }
        }
    }

    private UpgradePack findServiceUpgradePack(UpgradePack base, File upgradeStackDirectory) {
        if (!upgradeStackDirectory.exists() || !upgradeStackDirectory.isDirectory()) {
            return null;
        }
        File[] upgradeFiles = upgradeStackDirectory.listFiles(StackDirectory.XML_FILENAME_FILTER);
        if (0 == upgradeFiles.length) {
            return null;
        }
        for (File f : upgradeFiles) {
            try {
                UpgradePack upgradePack = this.unmarshaller.unmarshal(UpgradePack.class, f);
                if (!upgradePack.isAllTarget() || upgradePack.getType() != base.getType()) continue;
                return upgradePack;
            }
            catch (Exception e) {
                LOG.warn("File {} does not appear to be an upgrade pack and will be skipped ({})", (Object)f.getAbsolutePath(), (Object)e.getMessage());
            }
        }
        return null;
    }

    private UpgradePack parseServiceUpgradePack(UpgradePack parent, File serviceFile) throws OBDPException {
        UpgradePack pack = null;
        try {
            pack = this.unmarshaller.unmarshal(UpgradePack.class, serviceFile);
        }
        catch (Exception e) {
            throw new OBDPException("Unable to parse service upgrade file at location: " + serviceFile.getAbsolutePath(), (Throwable)e);
        }
        return this.parseServiceUpgradePack(parent, pack);
    }

    private UpgradePack parseServiceUpgradePack(UpgradePack parent, UpgradePack child) {
        parent.mergePrerequisiteChecks(child);
        parent.mergeProcessing(child);
        return child;
    }

    private void processRepositories() throws OBDPException {
        List<RepositoryInfo> stackRepos = Collections.emptyList();
        RepositoryXml rxml = this.stackDirectory.getRepoFile();
        if (null != rxml) {
            this.stackInfo.setRepositoryXml(rxml);
            LOG.debug("Adding repositories to stack, stackName={}, stackVersion={}, repoFolder={}", new Object[]{this.stackInfo.getName(), this.stackInfo.getVersion(), this.stackDirectory.getRepoDir()});
            stackRepos = rxml.getRepositories();
            this.stackInfo.getRepositories().addAll(stackRepos);
        }
        LOG.debug("Process service custom repositories");
        Collection<RepositoryInfo> serviceRepos = this.getUniqueServiceRepos(stackRepos);
        this.stackInfo.getRepositories().addAll(serviceRepos);
        if (null != rxml && null != rxml.getLatestURI() && stackRepos.size() > 0) {
            this.registerRepoUpdateTask(rxml);
        }
    }

    private void registerRepoUpdateTask(RepositoryXml rxml) {
        String latest = rxml.getLatestURI();
        if (StringUtils.isBlank((String)latest)) {
            return;
        }
        URI uri = StackModule.getURI(this, latest);
        if (null == uri) {
            LOG.warn("Could not determine how to load stack {}-{} latest definition for {}", new Object[]{this.stackInfo.getName(), this.stackInfo.getVersion(), latest});
            return;
        }
        this.stackContext.registerRepoUpdateTask(uri, this);
    }

    public static URI getURI(StackModule module, String uriString) {
        URI uri = null;
        if (uriString.startsWith("http")) {
            try {
                uri = new URI(uriString);
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            uri = '.' == uriString.charAt(0) ? new File(module.getStackDirectory().getRepoDir(), uriString).toURI() : new File(uriString).toURI();
        }
        return uri;
    }

    private Collection<RepositoryInfo> getUniqueServiceRepos(List<RepositoryInfo> stackRepos) {
        List<RepositoryInfo> serviceRepos = this.getAllServiceRepos();
        ImmutableListMultimap serviceReposByOsType = Multimaps.index(serviceRepos, RepositoryInfo.GET_OSTYPE_FUNCTION);
        ImmutableListMultimap stackReposByOsType = Multimaps.index(stackRepos, RepositoryInfo.GET_OSTYPE_FUNCTION);
        HashMap<CallSite, RepositoryInfo> uniqueServiceRepos = new HashMap<CallSite, RepositoryInfo>();
        for (String osType : serviceReposByOsType.keySet()) {
            ImmutableList stackReposForOsType = stackReposByOsType.containsKey((Object)osType) ? stackReposByOsType.get((Object)osType) : Collections.emptyList();
            ImmutableList serviceReposForOsType = serviceReposByOsType.get((Object)osType);
            ImmutableSet stackRepoNames = ImmutableSet.copyOf((Collection)Lists.transform((List)stackReposForOsType, RepositoryInfo.GET_REPO_NAME_FUNCTION));
            ImmutableSet stackRepoUrls = ImmutableSet.copyOf((Collection)Lists.transform((List)stackReposForOsType, RepositoryInfo.SAFE_GET_BASE_URL_FUNCTION));
            Set<String> duplicateServiceRepoNames = StackModule.findDuplicates((List<RepositoryInfo>)serviceReposForOsType, RepositoryInfo.GET_REPO_NAME_FUNCTION);
            Set<String> duplicateServiceRepoUrls = StackModule.findDuplicates((List<RepositoryInfo>)serviceReposForOsType, RepositoryInfo.SAFE_GET_BASE_URL_FUNCTION);
            for (RepositoryInfo repo : serviceReposForOsType) {
                if (stackRepoUrls.contains(repo.getBaseUrl())) {
                    LOG.warn("Service repo has a base url that is identical to that of a stack repo: {}", (Object)repo);
                } else if (duplicateServiceRepoUrls.contains(repo.getBaseUrl())) {
                    LOG.warn("Service repo has a base url that is identical to that of another service repo: {}", (Object)repo);
                }
                if (stackRepoNames.contains(repo.getRepoName())) {
                    LOG.warn("Discarding service repository with the same name as one of the stack repos: {}", (Object)repo);
                    continue;
                }
                if (duplicateServiceRepoNames.contains(repo.getRepoName())) {
                    LOG.warn("Discarding service repository with duplicate name and different content: {}", (Object)repo);
                    continue;
                }
                String key = repo.getOsType() + "-" + repo.getRepoName() + "-" + repo.getRepoId();
                if (uniqueServiceRepos.containsKey(key)) {
                    ((RepositoryInfo)uniqueServiceRepos.get(key)).getApplicableServices().addAll(repo.getApplicableServices());
                    continue;
                }
                uniqueServiceRepos.put((CallSite)((Object)key), repo);
            }
        }
        return uniqueServiceRepos.values();
    }

    private static Set<String> findDuplicates(List<RepositoryInfo> input, Function<RepositoryInfo, String> keyExtractor) {
        ImmutableListMultimap itemsByKey = Multimaps.index(input, keyExtractor);
        HashSet<String> duplicates = new HashSet<String>();
        for (Map.Entry entry : itemsByKey.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            HashSet differingItems = new HashSet();
            differingItems.addAll((Collection)entry.getValue());
            if (differingItems.size() <= 1) continue;
            duplicates.add((String)entry.getKey());
        }
        return duplicates;
    }

    private List<RepositoryInfo> getAllServiceRepos() {
        ArrayList<RepositoryInfo> repos = new ArrayList<RepositoryInfo>();
        for (ServiceModule sm : this.serviceModules.values()) {
            StackServiceDirectory ssd;
            RepositoryXml serviceRepoXml;
            ServiceDirectory sd = sm.getServiceDirectory();
            if (!(sd instanceof StackServiceDirectory) || null == (serviceRepoXml = (ssd = (StackServiceDirectory)sd).getRepoFile())) continue;
            List<RepositoryInfo> serviceRepos = serviceRepoXml.getRepositories();
            for (RepositoryInfo serviceRepo : serviceRepos) {
                serviceRepo.getApplicableServices().add(sm.getId());
            }
            repos.addAll(serviceRepos);
            if (null == serviceRepoXml.getLatestURI()) continue;
            this.registerRepoUpdateTask(serviceRepoXml);
        }
        return repos;
    }

    private void mergeRoleCommandOrder(StackModule parentStack) {
        this.stackInfo.getRoleCommandOrder().merge(parentStack.stackInfo.getRoleCommandOrder());
    }

    private void mergeRoleCommandOrder(ServiceModule service) {
        if (service.getModuleInfo().getRoleCommandOrder() == null) {
            return;
        }
        this.stackInfo.getRoleCommandOrder().merge(service.getModuleInfo().getRoleCommandOrder(), true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Role Command Order for {}-{} service {}", new Object[]{this.stackInfo.getName(), this.stackInfo.getVersion(), service.getModuleInfo().getName()});
            this.stackInfo.getRoleCommandOrder().printRoleCommandOrder(LOG);
        }
    }

    private void validateBulkCommandComponents(Map<String, StackModule> allStacks) {
        if (null != this.stackInfo) {
            String currentStackId = this.stackInfo.getName() + "/" + this.stackInfo.getVersion();
            LOG.debug("Validate bulk command components for: {}", (Object)currentStackId);
            StackModule currentStack = allStacks.get(currentStackId);
            if (null != currentStack) {
                for (ServiceModule serviceModule : currentStack.getServiceModules().values()) {
                    ServiceInfo service = serviceModule.getModuleInfo();
                    for (ComponentInfo component : service.getComponents()) {
                        String name;
                        ComponentInfo targetComponent;
                        BulkCommandDefinition bcd = component.getBulkCommandDefinition();
                        if (null == bcd || null == bcd.getMasterComponent() || null != (targetComponent = service.getComponentByName(name = bcd.getMasterComponent()))) continue;
                        String serviceName = service.getName();
                        LOG.error(String.format("%s bulk command section for service %s in stack %s references a component %s which doesn't exist.", component.getName(), serviceName, currentStackId, name));
                    }
                }
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public void addError(String error) {
        this.errorSet.add(error);
    }

    @Override
    public Collection<String> getErrors() {
        return this.errorSet;
    }

    @Override
    public void addErrors(Collection<String> errors) {
        this.errorSet.addAll(errors);
    }
}

