/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.AmbariManagementHelper;
import id.onyx.obdp.server.metadata.ActionMetadata;
import id.onyx.obdp.server.orm.dao.ExtensionDAO;
import id.onyx.obdp.server.orm.dao.ExtensionLinkDAO;
import id.onyx.obdp.server.orm.dao.MetainfoDAO;
import id.onyx.obdp.server.orm.dao.StackDAO;
import id.onyx.obdp.server.orm.entities.ExtensionEntity;
import id.onyx.obdp.server.orm.entities.ExtensionLinkEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.stack.CommonServiceDirectory;
import id.onyx.obdp.server.stack.ExtensionDirectory;
import id.onyx.obdp.server.stack.ExtensionModule;
import id.onyx.obdp.server.stack.ModuleState;
import id.onyx.obdp.server.stack.ServiceModule;
import id.onyx.obdp.server.stack.StackContext;
import id.onyx.obdp.server.stack.StackDirectory;
import id.onyx.obdp.server.stack.StackModule;
import id.onyx.obdp.server.state.ExtensionInfo;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.stack.OsFamily;
import id.onyx.obdp.server.state.stack.ServiceMetainfoXml;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class StackManager {
    public static final String PROPERTY_SCHEMA_PATH = "configuration-schema.xsd";
    public static final String PATH_DELIMITER = "/";
    public static final String COMMON_SERVICES = "common-services";
    public static final String EXTENSIONS = "extensions";
    public static final String METAINFO_FILE_NAME = "metainfo.xml";
    private StackContext stackContext;
    private static final Logger LOG = LoggerFactory.getLogger(StackManager.class);
    protected NavigableMap<String, StackInfo> stackMap = new TreeMap<String, StackInfo>();
    protected Map<String, ServiceModule> commonServiceModules;
    protected Map<String, StackModule> stackModules;
    protected Map<String, ExtensionModule> extensionModules;
    private Map<String, ExtensionInfo> extensionMap = new HashMap<String, ExtensionInfo>();
    private AmbariManagementHelper helper;

    @AssistedInject
    public StackManager(@Assisted(value="stackRoot") File stackRoot, @Assisted(value="commonServicesRoot") @Nullable File commonServicesRoot, @Assisted(value="extensionRoot") @Nullable File extensionRoot, @Assisted OsFamily osFamily, @Assisted boolean validate, MetainfoDAO metaInfoDAO, ActionMetadata actionMetadata, StackDAO stackDao, ExtensionDAO extensionDao, ExtensionLinkDAO linkDao, AmbariManagementHelper helper) throws OBDPException {
        LOG.info("Initializing the stack manager...");
        if (validate) {
            this.validateStackDirectory(stackRoot);
            this.validateCommonServicesDirectory(commonServicesRoot);
            this.validateExtensionDirectory(extensionRoot);
        }
        this.stackMap = new TreeMap<String, StackInfo>();
        this.stackContext = new StackContext(metaInfoDAO, actionMetadata, osFamily);
        this.extensionMap = new HashMap<String, ExtensionInfo>();
        this.helper = helper;
        this.parseDirectories(stackRoot, commonServicesRoot, extensionRoot);
        for (StackModule module : this.stackModules.values()) {
            StackInfo stack = module.getModuleInfo();
            List<ExtensionLinkEntity> entities = linkDao.findByStack(stack.getName(), stack.getVersion());
            for (ExtensionLinkEntity entity : entities) {
                String version;
                String name = entity.getExtension().getExtensionName();
                String key = name + PATH_DELIMITER + (version = entity.getExtension().getExtensionVersion());
                ExtensionModule extensionModule = this.extensionModules.get(key);
                if (extensionModule == null) continue;
                LOG.info("Adding extension to stack/version: " + stack.getName() + PATH_DELIMITER + stack.getVersion() + " extension/version: " + name + PATH_DELIMITER + version);
                module.getExtensionModules().put(key, extensionModule);
            }
        }
        this.fullyResolveCommonServices(this.stackModules, this.commonServiceModules, this.extensionModules);
        this.fullyResolveExtensions(this.stackModules, this.commonServiceModules, this.extensionModules);
        this.fullyResolveStacks(this.stackModules, this.commonServiceModules, this.extensionModules);
        this.populateDB(stackDao, extensionDao);
    }

    protected void parseDirectories(File stackRoot, File commonServicesRoot, File extensionRoot) throws OBDPException {
        this.commonServiceModules = this.parseCommonServicesDirectory(commonServicesRoot);
        this.stackModules = this.parseStackDirectory(stackRoot);
        LOG.info("About to parse extension directories");
        this.extensionModules = this.parseExtensionDirectory(extensionRoot);
    }

    private void populateDB(StackDAO stackDao, ExtensionDAO extensionDao) throws OBDPException {
        Collection<StackInfo> stacks = this.getStacks();
        for (StackInfo stack : stacks) {
            String stackVersion;
            String stackName = stack.getName();
            if (stackDao.find(stackName, stackVersion = stack.getVersion()) != null) continue;
            LOG.info("Adding stack {}-{} to the database", (Object)stackName, (Object)stackVersion);
            StackEntity stackEntity = new StackEntity();
            stackEntity.setStackName(stackName);
            stackEntity.setStackVersion(stackVersion);
            stackDao.create(stackEntity);
        }
        Collection<ExtensionInfo> extensions = this.getExtensions();
        for (ExtensionInfo extension : extensions) {
            String extensionVersion;
            String extensionName = extension.getName();
            if (extensionDao.find(extensionName, extensionVersion = extension.getVersion()) != null) continue;
            LOG.info("Adding extension {}-{} to the database", (Object)extensionName, (Object)extensionVersion);
            ExtensionEntity extensionEntity = new ExtensionEntity();
            extensionEntity.setExtensionName(extensionName);
            extensionEntity.setExtensionVersion(extensionVersion);
            extensionDao.create(extensionEntity);
        }
        this.createLinks();
    }

    private void createLinks() {
        LOG.info("Creating links");
        Collection<ExtensionInfo> extensions = this.getExtensions();
        HashSet<String> names = new HashSet<String>();
        for (ExtensionInfo extension : extensions) {
            names.add(extension.getName());
        }
        for (String name : names) {
            this.createLinksForExtension(name);
        }
    }

    private void createLinksForExtension(String name) {
        Collection<ExtensionInfo> collection = this.getExtensions(name);
        ArrayList<ExtensionInfo> extensions = new ArrayList<ExtensionInfo>(collection.size());
        extensions.addAll(collection);
        try {
            this.helper.createExtensionLinks(this, extensions);
        }
        catch (OBDPException e) {
            String msg = String.format("Failed to create link for extension: %s with exception: %s", name, e.getMessage());
            LOG.error(msg);
        }
    }

    public StackInfo getStack(String name, String version) {
        return (StackInfo)this.stackMap.get(name + PATH_DELIMITER + version);
    }

    public Collection<StackInfo> getStacks(String name) {
        HashSet<StackInfo> stacks = new HashSet<StackInfo>();
        for (StackInfo stack : this.stackMap.values()) {
            if (!stack.getName().equals(name)) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public Map<String, List<StackInfo>> getStacksByName() {
        HashMap<String, List<StackInfo>> stacks = new HashMap<String, List<StackInfo>>();
        for (StackInfo stack : this.stackMap.values()) {
            ArrayList<StackInfo> list = (ArrayList<StackInfo>)stacks.get(stack.getName());
            if (list == null) {
                list = new ArrayList<StackInfo>();
                stacks.put(stack.getName(), list);
            }
            list.add(stack);
        }
        return stacks;
    }

    public Collection<StackInfo> getStacks() {
        return this.stackMap.values();
    }

    public ExtensionInfo getExtension(String name, String version) {
        return this.extensionMap.get(name + PATH_DELIMITER + version);
    }

    public Collection<ExtensionInfo> getExtensions(String name) {
        HashSet<ExtensionInfo> extensions = new HashSet<ExtensionInfo>();
        for (ExtensionInfo extension : this.extensionMap.values()) {
            if (!extension.getName().equals(name)) continue;
            extensions.add(extension);
        }
        return extensions;
    }

    public Collection<ExtensionInfo> getExtensions() {
        return this.extensionMap.values();
    }

    public boolean haveAllRepoUrlsBeenResolved() {
        return this.stackContext.haveAllRepoTasksCompleted();
    }

    private void fullyResolveStacks(Map<String, StackModule> stackModules, Map<String, ServiceModule> commonServiceModules, Map<String, ExtensionModule> extensions) throws OBDPException {
        for (StackModule stack : stackModules.values()) {
            if (stack.getModuleState() != ModuleState.INIT) continue;
            stack.resolve(null, stackModules, commonServiceModules, extensions);
        }
        for (ServiceModule commonService : commonServiceModules.values()) {
            commonService.finalizeModule();
        }
        for (ExtensionModule extension : extensions.values()) {
            extension.finalizeModule();
        }
        for (StackModule stack : stackModules.values()) {
            stack.finalizeModule();
        }
        this.stackContext.executeRepoTasks();
    }

    private void fullyResolveCommonServices(Map<String, StackModule> stackModules, Map<String, ServiceModule> commonServiceModules, Map<String, ExtensionModule> extensions) throws OBDPException {
        for (ServiceModule commonService : commonServiceModules.values()) {
            if (commonService.getModuleState() != ModuleState.INIT) continue;
            commonService.resolveCommonService(stackModules, commonServiceModules, extensions);
        }
    }

    private void fullyResolveExtensions(Map<String, StackModule> stackModules, Map<String, ServiceModule> commonServiceModules, Map<String, ExtensionModule> extensionModules) throws OBDPException {
        for (ExtensionModule extensionModule : extensionModules.values()) {
            if (extensionModule.getModuleState() != ModuleState.INIT) continue;
            extensionModule.resolve(null, stackModules, commonServiceModules, extensionModules);
        }
    }

    private void validateCommonServicesDirectory(File commonServicesRoot) throws OBDPException {
        if (commonServicesRoot != null) {
            LOG.info("Validating common services directory {} ...", (Object)commonServicesRoot);
            String commonServicesRootAbsolutePath = commonServicesRoot.getAbsolutePath();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading common services information, commonServicesRoot = {}", (Object)commonServicesRootAbsolutePath);
            }
            if (!commonServicesRoot.isDirectory() && !commonServicesRoot.exists()) {
                throw new OBDPException(Configuration.COMMON_SERVICES_DIR_PATH + " should be a directory with common services, commonServicesRoot = " + commonServicesRootAbsolutePath);
            }
        }
    }

    private void validateStackDirectory(File stackRoot) throws OBDPException {
        LOG.info("Validating stack directory {} ...", (Object)stackRoot);
        String stackRootAbsPath = stackRoot.getAbsolutePath();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading stack information, stackRoot = {}", (Object)stackRootAbsPath);
        }
        if (!stackRoot.isDirectory() && !stackRoot.exists()) {
            throw new OBDPException(Configuration.METADATA_DIR_PATH + " should be a directory with stack, stackRoot = " + stackRootAbsPath);
        }
        Validator validator = StackManager.getPropertySchemaValidator();
        StackManager.validateAllPropertyXmlsInFolderRecursively(stackRoot, validator);
    }

    public static Validator getPropertySchemaValidator() throws OBDPException {
        Schema schema;
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        ClassLoader classLoader = StackManager.class.getClassLoader();
        try {
            schema = factory.newSchema(classLoader.getResource(PROPERTY_SCHEMA_PATH));
        }
        catch (SAXException e) {
            throw new OBDPException(String.format("Failed to parse property schema file %s", PROPERTY_SCHEMA_PATH), (Throwable)e);
        }
        return schema.newValidator();
    }

    public static void validateAllPropertyXmlsInFolderRecursively(File stackRoot, Validator validator) throws OBDPException {
        Collection files = FileUtils.listFiles((File)stackRoot, (String[])new String[]{"xml"}, (boolean)true);
        for (File file : files) {
            try {
                if (!file.getParentFile().getName().contains("configuration")) continue;
                validator.validate(new StreamSource(file));
            }
            catch (Exception e) {
                String msg = String.format("File %s didn't pass the validation. Error message is : %s", file.getAbsolutePath(), e.getMessage());
                LOG.error(msg);
                throw new OBDPException(msg);
            }
        }
    }

    private void validateExtensionDirectory(File extensionRoot) throws OBDPException {
        LOG.info("Validating extension directory {} ...", (Object)extensionRoot);
        if (extensionRoot == null) {
            return;
        }
        String extensionRootAbsPath = extensionRoot.getAbsolutePath();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading extension information, extensionRoot = {}", (Object)extensionRootAbsPath);
        }
        if (extensionRoot.exists() && !extensionRoot.isDirectory()) {
            throw new OBDPException(Configuration.METADATA_DIR_PATH + " should be a directory, extensionRoot = " + extensionRootAbsPath);
        }
    }

    private Map<String, ServiceModule> parseCommonServicesDirectory(File commonServicesRoot) throws OBDPException {
        HashMap<String, ServiceModule> commonServiceModules = new HashMap<String, ServiceModule>();
        if (commonServicesRoot != null) {
            File[] commonServiceFiles;
            for (File commonService : commonServiceFiles = commonServicesRoot.listFiles(StackDirectory.FILENAME_FILTER)) {
                if (commonService.isFile()) continue;
                for (File serviceFolder : commonService.listFiles(StackDirectory.FILENAME_FILTER)) {
                    CommonServiceDirectory serviceDirectory = new CommonServiceDirectory(serviceFolder.getPath());
                    ServiceMetainfoXml metaInfoXml = serviceDirectory.getMetaInfoFile();
                    if (metaInfoXml == null) continue;
                    if (metaInfoXml.isValid()) {
                        for (ServiceInfo serviceInfo : metaInfoXml.getServices()) {
                            ServiceModule serviceModule = new ServiceModule(this.stackContext, serviceInfo, serviceDirectory, true);
                            String commonServiceKey = serviceInfo.getName() + PATH_DELIMITER + serviceInfo.getVersion();
                            commonServiceModules.put(commonServiceKey, serviceModule);
                        }
                        continue;
                    }
                    ServiceModule serviceModule = new ServiceModule(this.stackContext, new ServiceInfo(), serviceDirectory, true);
                    serviceModule.setValid(false);
                    serviceModule.addErrors(metaInfoXml.getErrors());
                    commonServiceModules.put(metaInfoXml.getSchemaVersion(), serviceModule);
                    metaInfoXml.setSchemaVersion(null);
                }
            }
        }
        return commonServiceModules;
    }

    private Map<String, StackModule> parseStackDirectory(File stackRoot) throws OBDPException {
        File[] stackFiles;
        HashMap<String, StackModule> stackModules = new HashMap<String, StackModule>();
        for (File stack : stackFiles = stackRoot.listFiles(StackDirectory.FILENAME_FILTER)) {
            if (stack.isFile()) continue;
            for (File stackFolder : stack.listFiles(StackDirectory.FILENAME_FILTER)) {
                if (stackFolder.isFile()) continue;
                String stackName = stackFolder.getParentFile().getName();
                String stackVersion = stackFolder.getName();
                StackModule stackModule = new StackModule(new StackDirectory(stackFolder.getPath()), this.stackContext);
                String stackKey = stackName + PATH_DELIMITER + stackVersion;
                stackModules.put(stackKey, stackModule);
                this.stackMap.put(stackKey, stackModule.getModuleInfo());
            }
        }
        if (this.stackMap.isEmpty()) {
            throw new OBDPException("Unable to find stack definitions under stackRoot = " + stackRoot.getAbsolutePath());
        }
        return stackModules;
    }

    public void linkStackToExtension(StackInfo stack, ExtensionInfo extension) throws OBDPException {
        stack.addExtension(extension);
    }

    public void unlinkStackAndExtension(StackInfo stack, ExtensionInfo extension) throws OBDPException {
        stack.removeExtension(extension);
    }

    private Map<String, ExtensionModule> parseExtensionDirectory(File extensionRoot) throws OBDPException {
        File[] extensionFiles;
        HashMap<String, ExtensionModule> extensionModules = new HashMap<String, ExtensionModule>();
        if (extensionRoot == null || !extensionRoot.exists()) {
            return extensionModules;
        }
        for (File extensionNameFolder : extensionFiles = extensionRoot.listFiles(StackDirectory.FILENAME_FILTER)) {
            if (extensionNameFolder.isFile()) continue;
            for (File extensionVersionFolder : extensionNameFolder.listFiles(StackDirectory.FILENAME_FILTER)) {
                if (extensionVersionFolder.isFile()) continue;
                String extensionName = extensionNameFolder.getName();
                String extensionVersion = extensionVersionFolder.getName();
                ExtensionModule extensionModule = new ExtensionModule(new ExtensionDirectory(extensionVersionFolder.getPath()), this.stackContext);
                String extensionKey = extensionName + PATH_DELIMITER + extensionVersion;
                extensionModules.put(extensionKey, extensionModule);
                this.extensionMap.put(extensionKey, extensionModule.getModuleInfo());
            }
        }
        if (this.stackMap.isEmpty()) {
            throw new OBDPException("Unable to find extension definitions under extensionRoot = " + extensionRoot.getAbsolutePath());
        }
        return extensionModules;
    }

    public void removeStack(StackEntity stackEntity) {
        String stackKey = stackEntity.getStackName() + PATH_DELIMITER + stackEntity.getStackVersion();
        this.stackMap.remove(stackKey);
    }
}

