/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.stack.ModuleFileUnmarshaller;
import id.onyx.obdp.server.stack.RepoUtil;
import id.onyx.obdp.server.stack.RepositoryFolderAndXml;
import id.onyx.obdp.server.stack.ServiceDirectory;
import id.onyx.obdp.server.stack.StackDefinitionDirectory;
import id.onyx.obdp.server.stack.StackServiceDirectory;
import id.onyx.obdp.server.stack.upgrade.ConfigUpgradePack;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.state.stack.RepositoryXml;
import id.onyx.obdp.server.state.stack.StackMetainfoXml;
import id.onyx.obdp.server.state.stack.StackRoleCommandOrder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class StackDirectory
extends StackDefinitionDirectory {
    public static final String SERVICE_CONFIG_FOLDER_NAME = "configuration";
    public static final String SERVICE_PROPERTIES_FOLDER_NAME = "properties";
    public static final String SERVICE_THEMES_FOLDER_NAME = "themes";
    public static final String SERVICE_QUICKLINKS_CONFIGURATIONS_FOLDER_NAME = "quicklinks";
    public static final String SERVICE_CONFIG_FILE_NAME_POSTFIX = ".xml";
    public static final String RCO_FILE_NAME = "role_command_order.json";
    public static final String SERVICE_METRIC_FILE_NAME = "metrics.json";
    public static final String SERVICE_ALERT_FILE_NAME = "alerts.json";
    public static final String SERVICE_ADVISOR_FILE_NAME = "service_advisor.py";
    public static final String LIB_FOLDER_NAME = "lib";
    public static final String KERBEROS_DESCRIPTOR_PRECONFIGURE_FILE_NAME = "kerberos_preconfigure.json";
    public static final String SERVICE_THEME_FILE_NAME = "theme.json";
    private String upgradesDir;
    private String rcoFilePath;
    private String libraryDir;
    private String kerberosDescriptorPreconfigureFilePath;
    private RepositoryXml repoFile;
    private StackRoleCommandOrder roleCommandOrder;
    private String repoDir;
    private Collection<ServiceDirectory> serviceDirectories;
    private Map<String, UpgradePack> upgradePacks;
    private ConfigUpgradePack configUpgradePack;
    private StackMetainfoXml metaInfoXml;
    private URLClassLoader libraryClassLoader;
    ModuleFileUnmarshaller unmarshaller = new ModuleFileUnmarshaller();
    public static final FilenameFilter FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String s) {
            return !s.equals(".svn") && !s.equals(".git");
        }
    };
    private static final String REPOSITORY_FOLDER_NAME = "repos";
    private static final String STACK_METAINFO_FILE_NAME = "metainfo.xml";
    private static final String UPGRADE_PACK_FOLDER_NAME = "upgrades";
    private static final Logger LOG = LoggerFactory.getLogger(StackDirectory.class);

    public StackDirectory(String directory) throws OBDPException {
        super(directory);
        this.parsePath();
    }

    public String getStackDirName() {
        return this.getDirectory().getParentFile().getName();
    }

    public String getUpgradesDir() {
        return this.upgradesDir;
    }

    public String getRcoFilePath() {
        return this.rcoFilePath;
    }

    public String getLibraryPath() {
        return this.libraryDir;
    }

    public String getKerberosDescriptorPreconfigureFilePath() {
        return this.kerberosDescriptorPreconfigureFilePath;
    }

    public String getRepoDir() {
        return this.repoDir;
    }

    public RepositoryXml getRepoFile() {
        return this.repoFile;
    }

    public StackMetainfoXml getMetaInfoFile() {
        return this.metaInfoXml;
    }

    public Collection<ServiceDirectory> getServiceDirectories() {
        return this.serviceDirectories;
    }

    public Map<String, UpgradePack> getUpgradePacks() {
        return this.upgradePacks;
    }

    public ConfigUpgradePack getConfigUpgradePack() {
        return this.configUpgradePack;
    }

    public StackRoleCommandOrder getRoleCommandOrder() {
        return this.roleCommandOrder;
    }

    @Nullable
    public URLClassLoader getLibraryClassLoader() {
        return this.libraryClassLoader;
    }

    private void parsePath() throws OBDPException {
        List<String> subDirs = Arrays.asList(this.directory.list());
        if (subDirs.contains(RCO_FILE_NAME)) {
            this.rcoFilePath = this.getAbsolutePath() + File.separator + RCO_FILE_NAME;
        }
        if (subDirs.contains(LIB_FOLDER_NAME)) {
            this.libraryDir = this.getAbsolutePath() + File.separator + LIB_FOLDER_NAME;
        }
        if (subDirs.contains(KERBEROS_DESCRIPTOR_PRECONFIGURE_FILE_NAME)) {
            this.kerberosDescriptorPreconfigureFilePath = this.getAbsolutePath() + File.separator + KERBEROS_DESCRIPTOR_PRECONFIGURE_FILE_NAME;
        }
        this.parseUpgradePacks(subDirs);
        this.parseServiceDirectories(subDirs);
        this.parseRepoFile(subDirs);
        this.parseMetaInfoFile();
        this.parseRoleCommandOrder();
        this.parseLibraryClassLoader();
    }

    private void parseRepoFile(Collection<String> subDirs) {
        RepositoryFolderAndXml repoDirAndXml = RepoUtil.parseRepoFile(this.directory, subDirs, this.unmarshaller);
        this.repoDir = (String)repoDirAndXml.repoDir.orNull();
        this.repoFile = (RepositoryXml)repoDirAndXml.repoXml.orNull();
        if (this.repoFile == null || !this.repoFile.isValid()) {
            LOG.warn("No repository information defined for , stackName=" + this.getStackDirName() + ", stackVersion=" + this.getPath() + ", repoFolder=" + this.getPath() + File.separator + REPOSITORY_FOLDER_NAME);
        }
    }

    private void parseMetaInfoFile() throws OBDPException {
        File stackMetaInfoFile = new File(this.getAbsolutePath() + File.separator + STACK_METAINFO_FILE_NAME);
        if (stackMetaInfoFile.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reading stack version metainfo from file {}", (Object)stackMetaInfoFile.getAbsolutePath());
            }
            try {
                this.metaInfoXml = this.unmarshaller.unmarshal(StackMetainfoXml.class, stackMetaInfoFile);
            }
            catch (Exception e) {
                this.metaInfoXml = new StackMetainfoXml();
                this.metaInfoXml.setValid(false);
                String msg = "Unable to parse stack metainfo.xml file at location: " + stackMetaInfoFile.getAbsolutePath();
                this.metaInfoXml.addError(msg);
                LOG.warn(msg);
            }
        }
    }

    private void parseServiceDirectories(Collection<String> subDirs) throws OBDPException {
        String servicesDir;
        File baseServiceDir;
        File[] serviceFolders;
        HashSet<ServiceDirectory> dirs = new HashSet<ServiceDirectory>();
        if (subDirs.contains("services") && (serviceFolders = (baseServiceDir = new File(servicesDir = this.getAbsolutePath() + File.separator + "services")).listFiles(FILENAME_FILTER)) != null) {
            for (File d : serviceFolders) {
                if (!d.isDirectory()) continue;
                try {
                    dirs.add(new StackServiceDirectory(d.getAbsolutePath()));
                }
                catch (OBDPException e) {
                    LOG.warn(String.format("Unable to parse stack definition service at '%s'.  Ignoring service. : %s", d.getAbsolutePath(), e.toString()));
                }
            }
        }
        if (dirs.isEmpty()) {
            LOG.info("The stack defined at '" + this.getAbsolutePath() + "' contains no services");
        }
        this.serviceDirectories = dirs;
    }

    private void parseUpgradePacks(Collection<String> subDirs) throws OBDPException {
        File f;
        HashMap<String, UpgradePack> upgradeMap = new HashMap<String, UpgradePack>();
        ConfigUpgradePack configUpgradePack = null;
        if (subDirs.contains(UPGRADE_PACK_FOLDER_NAME) && (f = new File(this.getAbsolutePath() + File.separator + UPGRADE_PACK_FOLDER_NAME)).isDirectory()) {
            this.upgradesDir = f.getAbsolutePath();
            for (File upgradeFile : f.listFiles(XML_FILENAME_FILTER)) {
                if (upgradeFile.getName().toLowerCase().startsWith("config-upgrade.xml")) {
                    if (configUpgradePack == null) {
                        if (upgradeFile.length() == 0L) continue;
                        configUpgradePack = this.parseConfigUpgradePack(upgradeFile);
                        continue;
                    }
                    throw new OBDPException(String.format("There are multiple files with name like %s" + upgradeFile.getAbsolutePath(), new Object[0]));
                }
                String upgradePackName = FilenameUtils.removeExtension((String)upgradeFile.getName());
                if (upgradeFile.length() == 0L) continue;
                UpgradePack pack = this.parseUpgradePack(upgradePackName, upgradeFile);
                pack.setName(upgradePackName);
                upgradeMap.put(upgradePackName, pack);
            }
        }
        if (this.upgradesDir == null) {
            LOG.info("Stack '{}' doesn't contain an upgrade directory ", (Object)this.getPath());
        }
        if (!upgradeMap.isEmpty()) {
            this.upgradePacks = upgradeMap;
        }
        if (configUpgradePack != null) {
            this.configUpgradePack = configUpgradePack;
        } else {
            ConfigUpgradePack emptyConfigUpgradePack = new ConfigUpgradePack();
            emptyConfigUpgradePack.services = new ArrayList<ConfigUpgradePack.AffectedService>();
            this.configUpgradePack = emptyConfigUpgradePack;
            LOG.info("Stack '{}' doesn't contain config upgrade pack file", (Object)this.getPath());
        }
    }

    private UpgradePack parseUpgradePack(String packName, File upgradeFile) throws OBDPException {
        UpgradePack pack = null;
        try {
            pack = this.unmarshaller.unmarshal(UpgradePack.class, upgradeFile);
            pack.setName(packName);
        }
        catch (Exception e) {
            if (upgradeFile == null) {
                throw new OBDPException("Null upgrade pack");
            }
            throw new OBDPException("Unable to parse stack upgrade file at location: " + upgradeFile.getAbsolutePath(), (Throwable)e);
        }
        return pack;
    }

    private ConfigUpgradePack parseConfigUpgradePack(File upgradeFile) throws OBDPException {
        ConfigUpgradePack pack = null;
        try {
            pack = this.unmarshaller.unmarshal(ConfigUpgradePack.class, upgradeFile);
        }
        catch (Exception e) {
            if (upgradeFile == null) {
                throw new OBDPException("Null config upgrade pack");
            }
            throw new OBDPException("Unable to parse stack upgrade file at location: " + upgradeFile.getAbsolutePath(), (Throwable)e);
        }
        return pack;
    }

    private void parseRoleCommandOrder() {
        HashMap result = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            TypeReference<Map<String, Object>> rcoElementTypeReference = new TypeReference<Map<String, Object>>(){};
            if (this.rcoFilePath != null) {
                File file = new File(this.rcoFilePath);
                result = (HashMap)mapper.readValue(file, (TypeReference)rcoElementTypeReference);
                LOG.info("Role command order info was loaded from file: {}", (Object)file.getAbsolutePath());
            } else {
                LOG.info("Stack '{}' doesn't contain role command order file", (Object)this.getPath());
                result = new HashMap();
            }
            this.roleCommandOrder = new StackRoleCommandOrder(result);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Role Command Order for {}", (Object)this.rcoFilePath);
                this.roleCommandOrder.printRoleCommandOrder(LOG);
            }
        }
        catch (IOException e) {
            LOG.error(String.format("Can not read role command order info %s", this.rcoFilePath), (Throwable)e);
        }
    }

    private void parseLibraryClassLoader() {
        if (null == this.libraryDir) {
            return;
        }
        Path libraryPath = Paths.get(this.libraryDir, new String[0]);
        if (Files.notExists(libraryPath, new LinkOption[0]) || !Files.isDirectory(libraryPath, new LinkOption[0])) {
            return;
        }
        try {
            List jarUris = Files.list(libraryPath).filter(file -> file.toString().endsWith(".jar")).map(Path::toUri).collect(Collectors.toList());
            ArrayList<URL> jarUrls = new ArrayList<URL>(jarUris.size());
            for (URI jarUri : jarUris) {
                try {
                    jarUrls.add(jarUri.toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    LOG.error("Unable to load the stack library {}", (Object)jarUri, (Object)malformedURLException);
                }
            }
            URL[] jarUrlArray = new URL[jarUris.size()];
            this.libraryClassLoader = new URLClassLoader(jarUrls.toArray(jarUrlArray), ClassUtils.getDefaultClassLoader());
        }
        catch (IOException ioException) {
            LOG.error("Unable to load libraries from {}", (Object)libraryPath, (Object)ioException);
        }
    }
}

