/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import id.onyx.obdp.server.stack.ConfigurationDirectory;
import java.io.File;
import java.io.FilenameFilter;

public abstract class StackDefinitionDirectory {
    protected static final FilenameFilter XML_FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File folder, String fileName) {
            return fileName.toLowerCase().endsWith(".xml");
        }
    };
    public static final String CONFIG_UPGRADE_XML_FILENAME_PREFIX = "config-upgrade.xml";
    protected File directory;

    public StackDefinitionDirectory(String directory) {
        this.directory = new File(directory);
    }

    public ConfigurationDirectory getConfigurationDirectory(String directoryName, String propertiesDirectoryName) {
        ConfigurationDirectory configDirectory = null;
        File configDirFile = new File(this.directory.getAbsolutePath() + File.separator + directoryName);
        File propertiesDirFile = new File(this.directory.getAbsolutePath() + File.separator + propertiesDirectoryName);
        if (configDirFile.exists() && configDirFile.isDirectory()) {
            configDirectory = propertiesDirFile.exists() && propertiesDirFile.isDirectory() ? new ConfigurationDirectory(configDirFile.getAbsolutePath(), propertiesDirFile.getAbsolutePath()) : new ConfigurationDirectory(configDirFile.getAbsolutePath(), null);
        }
        return configDirectory;
    }

    public String getPath() {
        return this.directory.getPath();
    }

    public String getAbsolutePath() {
        return this.directory.getAbsolutePath();
    }

    public String getName() {
        return this.directory.getName();
    }

    protected File getDirectory() {
        return this.directory;
    }
}

