/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import id.onyx.obdp.server.metadata.ActionMetadata;
import id.onyx.obdp.server.orm.dao.MetainfoDAO;
import id.onyx.obdp.server.stack.StackModule;
import id.onyx.obdp.server.state.stack.OsFamily;
import id.onyx.obdp.server.state.stack.RepoUrlInfoCallable;
import id.onyx.obdp.server.state.stack.RepoVdfCallable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackContext {
    private MetainfoDAO metaInfoDAO;
    private ActionMetadata actionMetaData;
    private LatestRepoQueryExecutor repoUpdateExecutor;
    private static final Logger LOG = LoggerFactory.getLogger(StackContext.class);
    private static final int THREAD_COUNT = 10;

    public StackContext(MetainfoDAO metaInfoDAO, ActionMetadata actionMetaData, OsFamily osFamily) {
        this.metaInfoDAO = metaInfoDAO;
        this.actionMetaData = actionMetaData;
        this.repoUpdateExecutor = new LatestRepoQueryExecutor(osFamily);
    }

    public void registerServiceCheck(String serviceName) {
        this.actionMetaData.addServiceCheckAction(serviceName);
    }

    public void registerRepoUpdateTask(URI uri, StackModule stack) {
        this.repoUpdateExecutor.addTask(uri, stack);
    }

    public void executeRepoTasks() {
        this.repoUpdateExecutor.execute();
    }

    public boolean haveAllRepoTasksCompleted() {
        return this.repoUpdateExecutor.hasCompleted();
    }

    public static class LatestRepoQueryExecutor {
        private Map<URI, RepoUrlInfoCallable> tasks = new HashMap<URI, RepoUrlInfoCallable>();
        Collection<Future<?>> futures = new ArrayList();
        private ExecutorService executor = Executors.newFixedThreadPool(10, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Stack Version Loading Thread");
            }
        });
        private OsFamily m_family;

        private LatestRepoQueryExecutor(OsFamily family) {
            this.m_family = family;
        }

        public void addTask(URI uri, StackModule stackModule) {
            RepoUrlInfoCallable callable = null;
            if (this.tasks.containsKey(uri)) {
                callable = this.tasks.get(uri);
            } else {
                callable = new RepoUrlInfoCallable(uri);
                this.tasks.put(uri, callable);
            }
            callable.addStack(stackModule);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            List results;
            long currentTime = System.nanoTime();
            try {
                results = this.executor.invokeAll(this.tasks.values(), 2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                LOG.warn("Could not load urlinfo as the executor was interrupted", (Throwable)e);
                return;
            }
            finally {
                LOG.info("Loaded urlinfo in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - currentTime) + "ms");
            }
            ArrayList<Map> urlInfoResults = new ArrayList<Map>();
            for (Future future : results) {
                try {
                    urlInfoResults.add((Map)future.get());
                }
                catch (Exception e) {
                    LOG.error("Could not load repo results", e.getCause());
                }
            }
            currentTime = System.nanoTime();
            for (Map urlInfoResult : urlInfoResults) {
                for (Map.Entry entry : urlInfoResult.entrySet()) {
                    StackModule stackModule = (StackModule)entry.getKey();
                    RepoUrlInfoCallable.RepoUrlInfoResult result = (RepoUrlInfoCallable.RepoUrlInfoResult)entry.getValue();
                    if (null == result) continue;
                    if (MapUtils.isNotEmpty(result.getManifest())) {
                        for (Map.Entry<String, Map<String, URI>> manifestEntry : result.getManifest().entrySet()) {
                            this.futures.add(this.executor.submit(new RepoVdfCallable(stackModule, manifestEntry.getKey(), manifestEntry.getValue(), this.m_family)));
                        }
                    }
                    if (!MapUtils.isNotEmpty(result.getLatestVdf())) continue;
                    this.futures.add(this.executor.submit(new RepoVdfCallable(stackModule, result.getLatestVdf(), this.m_family)));
                }
            }
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                LOG.warn("Loading all VDF was interrupted", e.getCause());
            }
            finally {
                LOG.info("Loaded all VDF in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - currentTime) + "ms");
            }
        }

        public boolean hasCompleted() {
            for (Future<?> f : this.futures) {
                if (f.isDone()) continue;
                return false;
            }
            return true;
        }
    }
}

