/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.stack.BaseModule;
import id.onyx.obdp.server.stack.ComponentModule;
import id.onyx.obdp.server.stack.ConfigurationDirectory;
import id.onyx.obdp.server.stack.ConfigurationInfo;
import id.onyx.obdp.server.stack.ConfigurationModule;
import id.onyx.obdp.server.stack.ExtensionModule;
import id.onyx.obdp.server.stack.ModuleState;
import id.onyx.obdp.server.stack.QuickLinksConfigurationModule;
import id.onyx.obdp.server.stack.ServiceDirectory;
import id.onyx.obdp.server.stack.StackContext;
import id.onyx.obdp.server.stack.StackModule;
import id.onyx.obdp.server.stack.ThemeModule;
import id.onyx.obdp.server.stack.Validable;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.CustomCommandDefinition;
import id.onyx.obdp.server.state.QuickLinksConfigurationInfo;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.ServicePropertyInfo;
import id.onyx.obdp.server.state.ThemeInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceModule
extends BaseModule<ServiceModule, ServiceInfo>
implements Validable {
    private ServiceInfo serviceInfo;
    private StackContext stackContext;
    private Map<String, ConfigurationModule> configurationModules = new HashMap<String, ConfigurationModule>();
    private Map<String, ComponentModule> componentModules = new HashMap<String, ComponentModule>();
    private Map<String, ThemeModule> themeModules = new HashMap<String, ThemeModule>();
    private Map<String, QuickLinksConfigurationModule> quickLinksConfigurationModules = new HashMap<String, QuickLinksConfigurationModule>();
    private ServiceDirectory serviceDirectory;
    private boolean isCommonService;
    protected boolean valid = true;
    private static final Logger LOG = LoggerFactory.getLogger(ServiceModule.class);
    private boolean hasConfigs = true;
    private Set<String> errorSet = new HashSet<String>();

    public ServiceModule(StackContext stackContext, ServiceInfo serviceInfo, ServiceDirectory serviceDirectory) {
        this(stackContext, serviceInfo, serviceDirectory, false);
    }

    public ServiceModule(StackContext stackContext, ServiceInfo serviceInfo, ServiceDirectory serviceDirectory, boolean isCommonService) {
        this.serviceInfo = serviceInfo;
        this.stackContext = stackContext;
        this.serviceDirectory = serviceDirectory;
        this.isCommonService = isCommonService;
        serviceInfo.setMetricsFile(serviceDirectory.getMetricsFile(serviceInfo.getName()));
        serviceInfo.setAlertsFile(serviceDirectory.getAlertsFile());
        serviceInfo.setKerberosDescriptorFile(serviceDirectory.getKerberosDescriptorFile());
        serviceInfo.setWidgetsDescriptorFile(serviceDirectory.getWidgetsDescriptorFile(serviceInfo.getName()));
        serviceInfo.setRoleCommandOrder(serviceDirectory.getRoleCommandOrder());
        serviceInfo.setSchemaVersion("2.0");
        serviceInfo.setServicePackageFolder(serviceDirectory.getPackageDir());
        serviceInfo.setServiceUpgradesFolder(serviceDirectory.getUpgradesDir());
        serviceInfo.setChecksFolder(serviceDirectory.getChecksDir());
        serviceInfo.setServerActionsFolder(serviceDirectory.getServerActionsDir());
        serviceInfo.setAdvisorFile(serviceDirectory.getAdvisorFile());
        serviceInfo.setAdvisorName(serviceDirectory.getAdvisorName(serviceInfo.getName()));
        this.populateComponentModules();
        this.populateConfigurationModules();
        this.populateThemeModules();
        this.populateQuickLinksConfigurationModules();
        this.validateServiceInfo();
    }

    @Override
    public ServiceInfo getModuleInfo() {
        return this.serviceInfo;
    }

    @Override
    public void resolve(ServiceModule parentModule, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        this.resolveInternal(parentModule, allStacks, commonServices, extensions, false);
    }

    public void resolveExplicit(ServiceModule parentModule, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        this.resolveInternal(parentModule, allStacks, commonServices, extensions, true);
    }

    public void resolveInternal(ServiceModule parentModule, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions, boolean resolveExplicit) throws OBDPException {
        if (!this.serviceInfo.isValid() || !parentModule.isValid()) {
            return;
        }
        LOG.debug("Resolve service");
        if (!StringUtils.isBlank((String)this.serviceInfo.getParent()) && !resolveExplicit) {
            return;
        }
        ServiceInfo parent = parentModule.getModuleInfo();
        if (this.serviceInfo.getComment() == null) {
            this.serviceInfo.setComment(parent.getComment());
        }
        LOG.info(String.format("Display name service/parent: %s/%s", this.serviceInfo.getDisplayName(), parent.getDisplayName()));
        if (this.serviceInfo.getDisplayName() == null) {
            this.serviceInfo.setDisplayName(parent.getDisplayName());
        }
        if (this.serviceInfo.getServiceType() == null) {
            this.serviceInfo.setServiceType(parent.getServiceType());
        }
        if (this.serviceInfo.getServiceAdvisorType() == null) {
            ServiceInfo.ServiceAdvisorType serviceAdvisorType = parent.getServiceAdvisorType();
            this.serviceInfo.setServiceAdvisorType(serviceAdvisorType == null ? ServiceInfo.ServiceAdvisorType.PYTHON : serviceAdvisorType);
        }
        if (this.serviceInfo.getVersion() == null) {
            this.serviceInfo.setVersion(parent.getVersion());
        }
        if (this.serviceInfo.getRequiredServices() == null || this.serviceInfo.getRequiredServices().size() == 0) {
            this.serviceInfo.setRequiredServices(parent.getRequiredServices() != null ? parent.getRequiredServices() : Collections.emptyList());
        }
        if (this.serviceInfo.isRestartRequiredAfterChange() == null) {
            this.serviceInfo.setRestartRequiredAfterChange(parent.isRestartRequiredAfterChange());
        }
        if (this.serviceInfo.isRestartRequiredAfterRackChange() == null) {
            this.serviceInfo.setRestartRequiredAfterRackChange(parent.isRestartRequiredAfterRackChange());
        }
        if (this.serviceInfo.isMonitoringService() == null) {
            this.serviceInfo.setMonitoringService(parent.isMonitoringService());
        }
        if (this.serviceInfo.getOsSpecifics().isEmpty()) {
            this.serviceInfo.setOsSpecifics(parent.getOsSpecifics());
        }
        if (this.serviceInfo.getCommandScript() == null) {
            this.serviceInfo.setCommandScript(parent.getCommandScript());
        }
        if (this.serviceInfo.getServicePackageFolder() == null) {
            this.serviceInfo.setServicePackageFolder(parent.getServicePackageFolder());
        }
        if (this.serviceInfo.getServiceUpgradesFolder() == null) {
            this.serviceInfo.setServiceUpgradesFolder(parent.getServiceUpgradesFolder());
        }
        if (this.serviceInfo.getMetricsFile() == null) {
            this.serviceInfo.setMetricsFile(parent.getMetricsFile());
        }
        if (this.serviceInfo.getAlertsFile() == null) {
            this.serviceInfo.setAlertsFile(parent.getAlertsFile());
        }
        if (this.serviceInfo.getKerberosDescriptorFile() == null) {
            this.serviceInfo.setKerberosDescriptorFile(parent.getKerberosDescriptorFile());
        }
        if (this.serviceInfo.getThemesMap().isEmpty()) {
            this.serviceInfo.setThemesMap(parent.getThemesMap());
        }
        if (this.serviceInfo.getWidgetsDescriptorFile() == null) {
            this.serviceInfo.setWidgetsDescriptorFile(parent.getWidgetsDescriptorFile());
        }
        if (this.serviceInfo.getAdvisorFile() == null) {
            this.serviceInfo.setAdvisorFile(parent.getAdvisorFile());
        }
        if (this.serviceInfo.getAdvisorName() == null) {
            this.serviceInfo.setAdvisorName(parent.getAdvisorName());
        }
        if (this.serviceInfo.getRoleCommandOrder() == null) {
            this.serviceInfo.setRoleCommandOrder(parent.getRoleCommandOrder());
        }
        if (this.serviceInfo.getChecksFolder() == null) {
            this.serviceInfo.setChecksFolder(parent.getChecksFolder());
        }
        if (this.serviceInfo.getServerActionsFolder() == null) {
            this.serviceInfo.setServerActionsFolder(parent.getServerActionsFolder());
        }
        if (this.serviceInfo.getCredentialStoreInfo() == null) {
            this.serviceInfo.setCredentialStoreInfo(parent.getCredentialStoreInfo());
        }
        if (this.serviceInfo.getSingleSignOnInfo() == null) {
            this.serviceInfo.setSingleSignOnInfo(parent.getSingleSignOnInfo());
        }
        if (this.serviceInfo.isSelectionEmpty()) {
            this.serviceInfo.setSelection(parent.getSelection());
        }
        if (this.serviceInfo.isMaintainerEmpty()) {
            this.serviceInfo.setMaintainer(parent.getMaintainer());
        }
        if (null == this.serviceInfo.getSupportDeleteViaUIField()) {
            this.serviceInfo.setSupportDeleteViaUI(parent.isSupportDeleteViaUI());
        }
        this.mergeCustomCommands(parent.getCustomCommands(), this.serviceInfo.getCustomCommands());
        this.mergeConfigDependencies(parent);
        this.mergeComponents(parentModule, allStacks, commonServices, extensions);
        this.mergeConfigurations(parentModule, allStacks, commonServices, extensions);
        this.mergeThemes(parentModule, allStacks, commonServices, extensions);
        this.mergeQuickLinksConfigurations(parentModule, allStacks, commonServices, extensions);
        this.mergeExcludedConfigTypes(parent);
        this.mergeServiceProperties(parent.getServicePropertyList());
    }

    private void mergeServiceProperties(List<ServicePropertyInfo> other) {
        if (!other.isEmpty()) {
            List<ServicePropertyInfo> servicePropertyList = this.serviceInfo.getServicePropertyList();
            ArrayList servicePropertiesToAdd = Lists.newArrayList();
            TreeSet servicePropertyNames = Sets.newTreeSet((Iterable)Iterables.transform(servicePropertyList, (Function)new Function<ServicePropertyInfo, String>(){

                @Nullable
                public String apply(ServicePropertyInfo serviceProperty) {
                    return serviceProperty.getName();
                }
            }));
            for (ServicePropertyInfo otherServiceProperty : other) {
                if (servicePropertyNames.contains(otherServiceProperty.getName())) continue;
                servicePropertiesToAdd.add(otherServiceProperty);
            }
            ImmutableList mergedServicePropertyList = ImmutableList.builder().addAll(servicePropertyList).addAll((Iterable)servicePropertiesToAdd).build();
            this.serviceInfo.setServicePropertyList((List<ServicePropertyInfo>)mergedServicePropertyList);
            this.validateServiceInfo();
        }
    }

    public void resolveCommonService(Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        if (!this.isCommonService) {
            throw new OBDPException("Not a common service");
        }
        this.moduleState = ModuleState.VISITED;
        String parentString = this.serviceInfo.getParent();
        if (parentString != null) {
            String[] parentToks = parentString.split("/");
            if (parentToks.length != 3) {
                throw new OBDPException("The common service '" + this.serviceInfo.getName() + this.serviceInfo.getVersion() + "' extends an invalid parent: '" + parentString + "'");
            }
            if (parentToks[0].equalsIgnoreCase("common-services")) {
                String baseServiceKey = parentToks[1] + "/" + parentToks[2];
                ServiceModule baseService = commonServices.get(baseServiceKey);
                ModuleState baseModuleState = baseService.getModuleState();
                if (baseModuleState == ModuleState.INIT) {
                    baseService.resolveCommonService(allStacks, commonServices, extensions);
                } else if (baseModuleState == ModuleState.VISITED) {
                    throw new OBDPException("Cycle detected while parsing common service");
                }
                this.resolveExplicit(baseService, allStacks, commonServices, extensions);
            } else {
                throw new OBDPException("Common service cannot inherit from a non common service");
            }
        }
        this.moduleState = ModuleState.RESOLVED;
    }

    @Override
    public boolean isDeleted() {
        return this.serviceInfo.isDeleted();
    }

    @Override
    public String getId() {
        return this.serviceInfo.getName();
    }

    @Override
    public void finalizeModule() {
        this.finalizeChildModules(this.configurationModules.values());
        this.finalizeChildModules(this.componentModules.values());
        this.finalizeConfiguration();
        if (this.serviceInfo.getCommandScript() != null && !this.isDeleted()) {
            this.stackContext.registerServiceCheck(this.getId());
        }
    }

    private void populateComponentModules() {
        for (ComponentInfo component : this.serviceInfo.getComponents()) {
            this.componentModules.put(component.getName(), new ComponentModule(component));
        }
    }

    private void populateConfigurationModules() {
        ConfigurationDirectory configDirectory = this.serviceDirectory.getConfigurationDirectory(this.serviceInfo.getConfigDir(), "properties");
        if (configDirectory != null) {
            for (ConfigurationModule config : configDirectory.getConfigurationModules()) {
                ConfigurationInfo info = config.getModuleInfo();
                if (this.isValid()) {
                    this.setValid(config.isValid() && info.isValid());
                    if (!this.isValid()) {
                        this.addErrors(config.getErrors());
                        this.addErrors(info.getErrors());
                    }
                }
                this.serviceInfo.getProperties().addAll(info.getProperties());
                this.serviceInfo.setTypeAttributes(config.getConfigType(), info.getAttributes());
                this.configurationModules.put(config.getConfigType(), config);
            }
            for (String excludedType : this.serviceInfo.getExcludedConfigTypes()) {
                if (this.configurationModules.containsKey(excludedType)) continue;
                ConfigurationInfo configInfo = new ConfigurationInfo(Collections.emptyList(), Collections.emptyMap());
                ConfigurationModule config = new ConfigurationModule(excludedType, configInfo);
                config.setDeleted(true);
                this.configurationModules.put(excludedType, config);
            }
        }
    }

    private void populateThemeModules() {
        if (this.serviceInfo.getThemesDir() == null) {
            this.serviceInfo.setThemesDir("themes");
        }
        String themesDir = this.serviceDirectory.getAbsolutePath() + File.separator + this.serviceInfo.getThemesDir();
        if (this.serviceInfo.getThemes() != null) {
            ArrayList<ThemeInfo> themes = new ArrayList<ThemeInfo>(this.serviceInfo.getThemes().size());
            for (ThemeInfo themeInfo : this.serviceInfo.getThemes()) {
                File themeFile = new File(themesDir + File.separator + themeInfo.getFileName());
                ThemeModule module = new ThemeModule(themeFile, themeInfo);
                if (module.isValid()) {
                    this.themeModules.put(module.getId(), module);
                    themes.add(themeInfo);
                    continue;
                }
                LOG.error("Invalid theme {} for service {}", (Object)themeInfo.getFileName(), (Object)this.serviceInfo.getName());
            }
            this.serviceInfo.setThemes(themes);
        }
    }

    private void mergeThemes(ServiceModule parent, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        Collection<ThemeModule> mergedModules = this.mergeChildModules(allStacks, commonServices, extensions, this.themeModules, parent.themeModules);
        for (ThemeModule mergedModule : mergedModules) {
            this.themeModules.put(mergedModule.getId(), mergedModule);
            ThemeInfo moduleInfo = mergedModule.getModuleInfo();
            if (!moduleInfo.isDeleted().booleanValue()) {
                this.serviceInfo.getThemesMap().put(moduleInfo.getFileName(), moduleInfo);
                continue;
            }
            this.serviceInfo.getThemesMap().remove(moduleInfo.getFileName());
        }
    }

    private void populateQuickLinksConfigurationModules() {
        if (this.serviceInfo.getQuickLinksConfigurationsDir() == null) {
            this.serviceInfo.setQuickLinksConfigurationsDir("quicklinks");
        }
        String quickLinksConfigurationsDir = this.serviceDirectory.getAbsolutePath() + File.separator + this.serviceInfo.getQuickLinksConfigurationsDir();
        if (this.serviceInfo.getQuickLinksConfigurations() != null) {
            for (QuickLinksConfigurationInfo quickLinksConfigurationInfo : this.serviceInfo.getQuickLinksConfigurations()) {
                File file = new File(quickLinksConfigurationsDir + File.separator + quickLinksConfigurationInfo.getFileName());
                QuickLinksConfigurationModule module = new QuickLinksConfigurationModule(file, quickLinksConfigurationInfo);
                this.quickLinksConfigurationModules.put(module.getId(), module);
            }
        }
    }

    private void mergeQuickLinksConfigurations(ServiceModule parent, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        Collection<QuickLinksConfigurationModule> mergedModules = this.mergeChildModules(allStacks, commonServices, extensions, this.quickLinksConfigurationModules, parent.quickLinksConfigurationModules);
        for (QuickLinksConfigurationModule mergedModule : mergedModules) {
            this.quickLinksConfigurationModules.put(mergedModule.getId(), mergedModule);
            QuickLinksConfigurationInfo moduleInfo = mergedModule.getModuleInfo();
            if (!moduleInfo.isDeleted().booleanValue()) {
                this.serviceInfo.getQuickLinksConfigurationsMap().put(moduleInfo.getFileName(), moduleInfo);
                continue;
            }
            this.serviceInfo.getQuickLinksConfigurationsMap().remove(moduleInfo.getFileName());
        }
    }

    private void mergeExcludedConfigTypes(ServiceInfo parent) {
        if (this.serviceInfo.getExcludedConfigTypes() == null) {
            this.serviceInfo.setExcludedConfigTypes(parent.getExcludedConfigTypes());
        } else if (parent.getExcludedConfigTypes() != null) {
            Set<String> resultExcludedConfigTypes = this.serviceInfo.getExcludedConfigTypes();
            for (String excludedType : parent.getExcludedConfigTypes()) {
                if (resultExcludedConfigTypes.contains(excludedType)) continue;
                resultExcludedConfigTypes.add(excludedType);
            }
            this.serviceInfo.setExcludedConfigTypes(resultExcludedConfigTypes);
        }
    }

    private void mergeConfigDependencies(ServiceInfo parent) {
        List<Object> parentConfigDependencies;
        List<String> configDependencies = this.serviceInfo.getConfigDependencies();
        List<Object> list = parentConfigDependencies = parent.getConfigDependencies() != null ? parent.getConfigDependencies() : Collections.emptyList();
        if (configDependencies == null) {
            this.serviceInfo.setConfigDependencies(parentConfigDependencies);
        } else {
            for (String string : parentConfigDependencies) {
                if (configDependencies.contains(string)) continue;
                configDependencies.add(string);
            }
        }
    }

    private void mergeConfigurations(ServiceModule parent, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        this.serviceInfo.getProperties().clear();
        this.serviceInfo.setAllConfigAttributes(new HashMap<String, Map<String, Map<String, String>>>());
        Collection<ConfigurationModule> mergedModules = this.mergeChildModules(allStacks, commonServices, extensions, this.configurationModules, parent.configurationModules);
        for (ConfigurationModule module : mergedModules) {
            this.configurationModules.put(module.getId(), module);
            if (module.isDeleted()) continue;
            this.serviceInfo.getProperties().addAll(module.getModuleInfo().getProperties());
            this.serviceInfo.setTypeAttributes(module.getConfigType(), module.getModuleInfo().getAttributes());
        }
    }

    private void mergeComponents(ServiceModule parent, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        this.serviceInfo.getComponents().clear();
        Collection<ComponentModule> mergedModules = this.mergeChildModules(allStacks, commonServices, extensions, this.componentModules, parent.componentModules);
        this.componentModules.clear();
        for (ComponentModule module : mergedModules) {
            if (module.isDeleted()) continue;
            this.componentModules.put(module.getId(), module);
            this.serviceInfo.getComponents().add(module.getModuleInfo());
        }
    }

    private void mergeCustomCommands(Collection<CustomCommandDefinition> parentCmds, Collection<CustomCommandDefinition> childCmds) {
        HashSet<String> existingNames = new HashSet<String>();
        for (CustomCommandDefinition childCmd : childCmds) {
            existingNames.add(childCmd.getName());
        }
        for (CustomCommandDefinition parentCmd : parentCmds) {
            if (existingNames.contains(parentCmd.getName())) continue;
            childCmds.add(parentCmd);
        }
    }

    private void finalizeConfiguration() {
        LOG.debug("Finalize config, number of configuration modules {}", (Object)this.configurationModules.size());
        this.hasConfigs = !this.configurationModules.isEmpty();
        LOG.debug("Finalize config, hasConfigs {}", (Object)this.hasConfigs);
        for (ConfigurationModule config : this.configurationModules.values()) {
            ConfigurationInfo configInfo = config.getModuleInfo();
            configInfo.ensureDefaultAttributes();
            this.serviceInfo.setTypeAttributes(config.getConfigType(), configInfo.getAttributes());
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public void addError(String error) {
        this.errorSet.add(error);
    }

    @Override
    public Collection<String> getErrors() {
        return this.errorSet;
    }

    public ServiceDirectory getServiceDirectory() {
        return this.serviceDirectory;
    }

    @Override
    public void addErrors(Collection<String> errors) {
        this.errorSet.addAll(errors);
    }

    private void validateServiceInfo() {
        if (!this.serviceInfo.isValid()) {
            this.setValid(false);
            this.addErrors(this.serviceInfo.getErrors());
        }
    }

    public boolean hasConfigs() {
        return this.hasConfigs;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

