/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.stack.ModuleFileUnmarshaller;
import id.onyx.obdp.server.stack.StackDefinitionDirectory;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.stack.ServiceMetainfoXml;
import id.onyx.obdp.server.state.stack.StackRoleCommandOrder;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceDirectory
extends StackDefinitionDirectory {
    private Map<String, File> metricsFileMap = new HashMap<String, File>();
    private File advisorFile;
    private File alertsFile;
    private File themeFile;
    private File kerberosDescriptorFile;
    private File rcoFile;
    private StackRoleCommandOrder roleCommandOrder;
    private Map<String, File> widgetsDescriptorFileMap = new HashMap<String, File>();
    protected String packageDir;
    protected File upgradesDir;
    protected File checksDir;
    protected File serverActionsDir;
    private ServiceMetainfoXml metaInfoXml;
    public static final String SERVICES_FOLDER_NAME = "services";
    protected static final String PACKAGE_FOLDER_NAME = "package";
    protected static final String UPGRADES_FOLDER_NAME = "upgrades";
    protected static final String CHECKS_FOLDER_NAME = "checks";
    protected static final String SERVER_ACTIONS_FOLDER_NAME = "server_actions";
    private static final String SERVICE_METAINFO_FILE_NAME = "metainfo.xml";
    ModuleFileUnmarshaller unmarshaller = new ModuleFileUnmarshaller();
    private static final Logger LOG = LoggerFactory.getLogger(ServiceDirectory.class);

    public ServiceDirectory(String servicePath) throws OBDPException {
        super(servicePath);
        this.parsePath();
    }

    public String getPackageDir() {
        return this.packageDir;
    }

    public File getUpgradesDir() {
        return this.upgradesDir;
    }

    public File getChecksDir() {
        return this.checksDir;
    }

    public File getServerActionsDir() {
        return this.serverActionsDir;
    }

    public File getMetricsFile(String serviceName) {
        return this.metricsFileMap.get(serviceName);
    }

    public File getAdvisorFile() {
        return this.advisorFile;
    }

    public abstract String getAdvisorName(String var1);

    public File getAlertsFile() {
        return this.alertsFile;
    }

    public File getThemeFile() {
        return this.themeFile;
    }

    public File getKerberosDescriptorFile() {
        return this.kerberosDescriptorFile;
    }

    public File getWidgetsDescriptorFile(String serviceName) {
        return this.widgetsDescriptorFileMap.get(serviceName);
    }

    public ServiceMetainfoXml getMetaInfoFile() {
        return this.metaInfoXml;
    }

    public StackRoleCommandOrder getRoleCommandOrder() {
        return this.roleCommandOrder;
    }

    protected void parsePath() throws OBDPException {
        File advFile;
        this.calculateDirectories(this.getStack(), this.getService());
        this.parseMetaInfoFile();
        File af = new File(this.directory, "alerts.json");
        this.alertsFile = af.exists() ? af : null;
        File kdf = new File(this.directory, "kerberos.json");
        this.kerberosDescriptorFile = kdf.exists() ? kdf : null;
        File rco = new File(this.directory, "role_command_order.json");
        if (rco.exists()) {
            this.rcoFile = rco;
            this.parseRoleCommandOrder();
        }
        if (this.metaInfoXml.getServices() != null) {
            for (ServiceInfo serviceInfo : this.metaInfoXml.getServices()) {
                File mf = new File(this.directory, serviceInfo.getMetricsFileName());
                this.metricsFileMap.put(serviceInfo.getName(), mf.exists() ? mf : null);
                File wdf = new File(this.directory, serviceInfo.getWidgetsFileName());
                this.widgetsDescriptorFileMap.put(serviceInfo.getName(), wdf.exists() ? wdf : null);
            }
        }
        this.advisorFile = (advFile = new File(this.directory, "service_advisor.py")).exists() ? advFile : null;
        File themeFile = new File(this.directory, "theme.json");
        this.themeFile = themeFile.exists() ? themeFile : null;
    }

    public abstract String getService();

    public abstract String getStack();

    protected void calculateDirectories(String stack, String service) {
        this.calculatePackageDirectory(stack, service);
        this.calculateUpgradesDirectory(stack, service);
        this.calculateChecksDirectory(stack, service);
        this.calculateServerActionsDirectory(stack, service);
    }

    protected File resolveDirectory(String directoryName, String stack, String service) {
        File directory = new File(this.getAbsolutePath() + File.separator + directoryName);
        if (directory.isDirectory()) {
            String[] files = directory.list();
            int fileCount = files.length;
            if (fileCount > 0) {
                LOG.debug("Service {} folder for service {} in {} has been resolved to {}", new Object[]{directoryName, service, stack, directory});
                return directory;
            }
            LOG.debug("Service folder {} is empty.", (Object)directory);
        } else {
            LOG.debug("Service folder {}does not exist.", (Object)directory);
        }
        return null;
    }

    protected String resolveRelativeDirectoryPathString(File resourcesDir, String directoryName, String stack, String service) {
        File dir = this.resolveDirectory(directoryName, stack, service);
        if (dir != null) {
            return dir.getPath().substring(resourcesDir.getPath().length() + 1);
        }
        return null;
    }

    protected abstract File getResourcesDirectory();

    protected void calculatePackageDirectory(String stack, String service) {
        this.packageDir = this.resolveRelativeDirectoryPathString(this.getResourcesDirectory(), PACKAGE_FOLDER_NAME, stack, service);
    }

    protected void calculateUpgradesDirectory(String stack, String service) {
        this.upgradesDir = this.resolveDirectory(UPGRADES_FOLDER_NAME, stack, service);
    }

    protected void calculateChecksDirectory(String stack, String service) {
        this.checksDir = this.resolveDirectory(CHECKS_FOLDER_NAME, stack, service);
    }

    protected void calculateServerActionsDirectory(String stack, String service) {
        this.serverActionsDir = this.resolveDirectory(SERVER_ACTIONS_FOLDER_NAME, stack, service);
    }

    protected void parseMetaInfoFile() throws OBDPException {
        File f = new File(this.getAbsolutePath() + File.separator + SERVICE_METAINFO_FILE_NAME);
        if (!f.exists()) {
            throw new OBDPException(String.format("Stack Definition Service at '%s' doesn't contain a metainfo.xml file", f.getAbsolutePath()));
        }
        try {
            this.metaInfoXml = this.unmarshaller.unmarshal(ServiceMetainfoXml.class, f);
        }
        catch (Exception e) {
            this.metaInfoXml = new ServiceMetainfoXml();
            this.metaInfoXml.setValid(false);
            String msg = String.format("Unable to parse service metainfo.xml file '%s' ", f.getAbsolutePath());
            this.metaInfoXml.addError(msg);
            LOG.warn(msg, (Throwable)e);
            this.metaInfoXml.setSchemaVersion(this.getAbsolutePath().replace(f.getParentFile().getParentFile().getParent() + File.separator, ""));
        }
    }

    private void parseRoleCommandOrder() {
        if (this.rcoFile == null) {
            return;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            TypeReference<Map<String, Object>> rcoElementTypeReference = new TypeReference<Map<String, Object>>(){};
            HashMap result = (HashMap)mapper.readValue(this.rcoFile, (TypeReference)rcoElementTypeReference);
            LOG.info("Role command order info was loaded from file: {}", (Object)this.rcoFile.getAbsolutePath());
            this.roleCommandOrder = new StackRoleCommandOrder(result);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Role Command Order for {}", (Object)this.rcoFile.getAbsolutePath());
                this.roleCommandOrder.printRoleCommandOrder(LOG);
            }
        }
        catch (IOException e) {
            LOG.error(String.format("Can not read role command order info %s", this.rcoFile.getAbsolutePath()), (Throwable)e);
        }
    }
}

