/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.controller.RepositoryResponse;
import id.onyx.obdp.server.orm.entities.RepoDefinitionEntity;
import id.onyx.obdp.server.orm.entities.RepoOsEntity;
import id.onyx.obdp.server.stack.ModuleFileUnmarshaller;
import id.onyx.obdp.server.stack.RepositoryFolderAndXml;
import id.onyx.obdp.server.state.RepositoryInfo;
import id.onyx.obdp.server.state.stack.RepositoryXml;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepoUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RepoUtil.class);
    static final String REPOSITORY_FOLDER_NAME = "repos";
    static final String REPOSITORY_FILE_NAME = "repoinfo.xml";
    private static final Function<RepoDefinitionEntity, String> REPO_ENTITY_TO_NAME = new Function<RepoDefinitionEntity, String>(){

        public String apply(RepoDefinitionEntity input) {
            return input.getRepoName();
        }
    };

    public static RepositoryFolderAndXml parseRepoFile(File directory, Collection<String> subDirs, ModuleFileUnmarshaller unmarshaller) {
        File repositoryFile = null;
        String repoDir = null;
        RepositoryXml repoFile = null;
        if (subDirs.contains(REPOSITORY_FOLDER_NAME)) {
            repoDir = directory.getAbsolutePath() + File.separator + REPOSITORY_FOLDER_NAME;
            repositoryFile = new File(directory.getPath() + File.separator + REPOSITORY_FOLDER_NAME + File.separator + REPOSITORY_FILE_NAME);
            if (repositoryFile.exists()) {
                try {
                    repoFile = unmarshaller.unmarshal(RepositoryXml.class, repositoryFile);
                }
                catch (Exception e) {
                    repoFile = new RepositoryXml();
                    repoFile.setValid(false);
                    String msg = "Unable to parse repo file at location: " + repositoryFile.getAbsolutePath();
                    repoFile.addError(msg);
                    LOG.warn(msg);
                }
            }
        }
        return new RepositoryFolderAndXml((Optional<String>)Optional.fromNullable(repoDir), (Optional<RepositoryXml>)Optional.fromNullable(repoFile));
    }

    public static boolean addServiceReposToOperatingSystemEntities(List<RepoOsEntity> operatingSystems, ListMultimap<String, RepositoryInfo> stackReposByOs) {
        HashSet<String> addedRepos = new HashSet<String>();
        for (RepoOsEntity os : operatingSystems) {
            List serviceReposForOs = stackReposByOs.get((Object)os.getFamily());
            ImmutableSet repoNames = ImmutableSet.copyOf((Collection)Lists.transform(os.getRepoDefinitionEntities(), REPO_ENTITY_TO_NAME));
            for (RepositoryInfo repoInfo : serviceReposForOs) {
                if (repoNames.contains((Object)repoInfo.getRepoName())) continue;
                os.addRepoDefinition(RepoUtil.toRepositoryEntity(repoInfo));
                addedRepos.add(String.format("%s (%s)", repoInfo.getRepoId(), os.getFamily()));
            }
        }
        LOG.info("Added {} service repos: {}", (Object)addedRepos.size(), (Object)Iterables.toString(addedRepos));
        return CollectionUtils.isNotEmpty(addedRepos);
    }

    public static List<RepositoryInfo> getServiceRepos(List<RepositoryInfo> vdfRepos, ListMultimap<String, RepositoryInfo> stackReposByOs) {
        HashSet<String> serviceRepoIds = new HashSet<String>();
        ArrayList<RepositoryInfo> serviceRepos = new ArrayList<RepositoryInfo>();
        ImmutableListMultimap vdfReposByOs = Multimaps.index(vdfRepos, RepositoryInfo.GET_OSTYPE_FUNCTION);
        for (String os : vdfReposByOs.keySet()) {
            HashSet vdfRepoNames = Sets.newHashSet((Iterable)Lists.transform((List)vdfReposByOs.get((Object)os), RepositoryInfo.GET_REPO_NAME_FUNCTION));
            for (RepositoryInfo repo : stackReposByOs.get((Object)os)) {
                if (vdfRepoNames.contains(repo.getRepoName())) continue;
                serviceRepos.add(repo);
                serviceRepoIds.add(repo.getRepoId());
            }
        }
        LOG.debug("Found {} service repos: {}", (Object)serviceRepoIds.size(), (Object)Iterables.toString(serviceRepoIds));
        return serviceRepos;
    }

    public static List<RepositoryResponse> asResponses(List<RepositoryInfo> repositoryInfos, @Nullable String versionDefinitionId, @Nullable String stackName, @Nullable String stackVersion) {
        ArrayList<RepositoryResponse> responses = new ArrayList<RepositoryResponse>(repositoryInfos.size());
        for (RepositoryInfo repoInfo : repositoryInfos) {
            RepositoryResponse response = repoInfo.convertToResponse();
            response.setVersionDefinitionId(versionDefinitionId);
            response.setStackName(stackName);
            response.setStackVersion(stackVersion);
            responses.add(response);
        }
        return responses;
    }

    private static RepoDefinitionEntity toRepositoryEntity(RepositoryInfo repoInfo) {
        RepoDefinitionEntity re = new RepoDefinitionEntity();
        re.setBaseUrl(repoInfo.getBaseUrl());
        re.setRepoName(repoInfo.getRepoName());
        re.setRepoID(repoInfo.getRepoId());
        re.setDistribution(repoInfo.getDistribution());
        re.setComponents(repoInfo.getComponents());
        re.setTags(repoInfo.getTags());
        re.setApplicableServices(repoInfo.getApplicableServices());
        return re;
    }
}

