/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import com.fasterxml.jackson.databind.ObjectMapper;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.stack.BaseModule;
import id.onyx.obdp.server.stack.ExtensionModule;
import id.onyx.obdp.server.stack.ServiceModule;
import id.onyx.obdp.server.stack.StackModule;
import id.onyx.obdp.server.stack.Validable;
import id.onyx.obdp.server.state.QuickLinksConfigurationInfo;
import id.onyx.obdp.server.state.quicklinks.QuickLinks;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickLinksConfigurationModule
extends BaseModule<QuickLinksConfigurationModule, QuickLinksConfigurationInfo>
implements Validable {
    private static final Logger LOG = LoggerFactory.getLogger(QuickLinksConfigurationModule.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    public static final String QUICKLINKS_CONFIGURATION_KEY = "QuickLinksConfiguration";
    private QuickLinksConfigurationInfo moduleInfo;
    private boolean valid = true;
    private Set<String> errors = new HashSet<String>();

    public QuickLinksConfigurationModule(File quickLinksConfigurationFile) {
        this(quickLinksConfigurationFile, new QuickLinksConfigurationInfo());
    }

    public QuickLinksConfigurationModule(File quickLinksConfigurationFile, QuickLinksConfigurationInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
        if (!moduleInfo.isDeleted().booleanValue() && quickLinksConfigurationFile != null) {
            LOG.debug("Looking for quicklinks in {}", (Object)quickLinksConfigurationFile.getAbsolutePath());
            FileReader reader = null;
            try {
                reader = new FileReader(quickLinksConfigurationFile);
            }
            catch (FileNotFoundException e) {
                LOG.error("Quick links file not found");
            }
            try {
                QuickLinks quickLinksConfig = (QuickLinks)mapper.readValue((Reader)reader, QuickLinks.class);
                HashMap<String, QuickLinks> map = new HashMap<String, QuickLinks>();
                map.put(QUICKLINKS_CONFIGURATION_KEY, quickLinksConfig);
                moduleInfo.setQuickLinksConfigurationMap(map);
                LOG.debug("Loaded quicklinks configuration: {}", (Object)moduleInfo);
            }
            catch (IOException e) {
                String errorMessage = String.format("Unable to parse quicklinks configuration file %s", quickLinksConfigurationFile.getAbsolutePath());
                LOG.error(errorMessage, (Throwable)e);
                this.setValid(false);
                this.addError(errorMessage);
            }
        }
    }

    public QuickLinksConfigurationModule(QuickLinksConfigurationInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }

    @Override
    public void resolve(QuickLinksConfigurationModule parent, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> allExtensions) throws OBDPException {
        QuickLinksConfigurationInfo parentModuleInfo = parent.getModuleInfo();
        if (parent.getModuleInfo() != null && !this.moduleInfo.isDeleted().booleanValue()) {
            if (this.moduleInfo.getQuickLinksConfigurationMap() == null || this.moduleInfo.getQuickLinksConfigurationMap().isEmpty()) {
                this.moduleInfo.setQuickLinksConfigurationMap(parentModuleInfo.getQuickLinksConfigurationMap());
            } else if (parentModuleInfo.getQuickLinksConfigurationMap() != null && !parentModuleInfo.getQuickLinksConfigurationMap().isEmpty()) {
                QuickLinks child = this.moduleInfo.getQuickLinksConfigurationMap().get(QUICKLINKS_CONFIGURATION_KEY);
                QuickLinks parentConfig = parentModuleInfo.getQuickLinksConfigurationMap().get(QUICKLINKS_CONFIGURATION_KEY);
                child.mergeWithParent(parentConfig);
            }
        }
    }

    @Override
    public QuickLinksConfigurationInfo getModuleInfo() {
        return this.moduleInfo;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public String getId() {
        return this.moduleInfo.getFileName();
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public void addError(String error) {
        this.errors.add(error);
    }

    @Override
    public void addErrors(Collection<String> errors) {
        this.errors.addAll(errors);
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }
}

