/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.utils.HTTPUtils;
import id.onyx.obdp.server.utils.HostAndPort;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class NameService {
    public final String nameServiceId;
    private final List<NameNode> nameNodes;

    public static List<NameService> fromConfig(ConfigHelper config, Cluster cluster) {
        return NameService.nameServiceIds(config, cluster).stream().map(nameServiceId -> NameService.nameService(nameServiceId, config, cluster)).collect(Collectors.toList());
    }

    private static List<String> nameServiceIds(ConfigHelper config, Cluster cluster) {
        return NameService.separateByComma(config, cluster, "dfs.internal.nameservices");
    }

    private static NameService nameService(String nameServiceId, ConfigHelper config, Cluster cluster) {
        List<NameNode> namenodes = NameService.nnUniqueIds(nameServiceId, config, cluster).stream().map(nnUniquId -> NameNode.fromConfig(nameServiceId, nnUniquId, config, cluster)).collect(Collectors.toList());
        return new NameService(nameServiceId, namenodes);
    }

    private static List<String> nnUniqueIds(String nameServiceId, ConfigHelper config, Cluster cluster) {
        return NameService.separateByComma(config, cluster, "dfs.ha.namenodes." + nameServiceId);
    }

    private static List<String> separateByComma(ConfigHelper config, Cluster cluster, String propertyName) {
        String propertyValue = config.getValueFromDesiredConfigurations(cluster, "hdfs-site", propertyName);
        return StringUtils.isBlank((String)propertyValue) ? Collections.emptyList() : Arrays.asList(propertyValue.split(","));
    }

    private NameService(String nameServiceId, List<NameNode> nameNodes) {
        this.nameServiceId = nameServiceId;
        this.nameNodes = nameNodes;
    }

    public List<NameNode> getNameNodes() {
        return this.nameNodes;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("nameServiceId", (Object)this.nameServiceId).append("nameNodes", this.getNameNodes()).toString();
    }

    public static class NameNode {
        private final String uniqueId;
        private final String address;
        private final boolean encrypted;
        private final String propertyName;

        public static NameNode fromConfig(String nameServiceId, String nnUniqueId, ConfigHelper config, Cluster cluster) {
            String namenodeFragment = "dfs.namenode." + (NameNode.isEncrypted(config, cluster) ? "https-address" : "http-address") + ".{0}.{1}";
            String propertyName = MessageFormat.format(namenodeFragment, nameServiceId, nnUniqueId);
            return new NameNode(nnUniqueId, config.getValueFromDesiredConfigurations(cluster, "hdfs-site", propertyName), NameNode.isEncrypted(config, cluster), propertyName);
        }

        NameNode(String uniqueId, String address, boolean encrypted, String propertyName) {
            this.uniqueId = uniqueId;
            this.address = address;
            this.encrypted = encrypted;
            this.propertyName = propertyName;
        }

        public String getHost() {
            return this.getAddress().host.toLowerCase();
        }

        public int getPort() {
            return this.getAddress().port;
        }

        private HostAndPort getAddress() {
            HostAndPort hp = HTTPUtils.getHostAndPortFromProperty(this.address);
            if (hp == null) {
                throw new IllegalArgumentException("Could not parse host and port from " + this.address);
            }
            return hp;
        }

        private static boolean isEncrypted(ConfigHelper config, Cluster cluster) {
            String policy = config.getValueFromDesiredConfigurations(cluster, "hdfs-site", "dfs.http.policy");
            return policy != null && policy.equalsIgnoreCase("HTTPS_ONLY");
        }

        public boolean isEncrypted() {
            return this.encrypted;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("uniqueId", (Object)this.uniqueId).append("address", (Object)this.address).append("encrypted", this.encrypted).append("propertyName", (Object)this.propertyName).toString();
        }
    }
}

