/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import id.onyx.obdp.server.stack.upgrade.ConfigUpgradePack;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.state.stack.ConfigurationXml;
import id.onyx.obdp.server.state.stack.ExtensionMetainfoXml;
import id.onyx.obdp.server.state.stack.RepositoryXml;
import id.onyx.obdp.server.state.stack.ServiceMetainfoXml;
import id.onyx.obdp.server.state.stack.StackMetainfoXml;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ModuleFileUnmarshaller {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleFileUnmarshaller.class);
    private static final Map<Class<?>, JAXBContext> jaxbContexts = new HashMap();
    private static final Map<String, Schema> jaxbSchemas = new HashMap<String, Schema>();

    public <T> T unmarshal(Class<T> clz, File file) throws JAXBException, IOException, XMLStreamException, SAXException {
        return this.unmarshal(clz, file, false);
    }

    public <T> T unmarshal(Class<T> clz, File file, boolean logXsd) throws JAXBException, IOException, XMLStreamException, SAXException {
        Object factory;
        Unmarshaller u = jaxbContexts.get(clz).createUnmarshaller();
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        FileReader reader = new FileReader(file);
        XMLStreamReader xmlReader = xmlFactory.createXMLStreamReader(reader);
        xmlReader.nextTag();
        String xsdName = xmlReader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation");
        InputStream xsdStream = null;
        if (null != xsdName) {
            if (logXsd) {
                LOG.info("Processing " + file.getAbsolutePath() + " with " + xsdName);
            }
            if (jaxbSchemas.containsKey(xsdName)) {
                u.setSchema(jaxbSchemas.get(xsdName));
            } else {
                xsdStream = clz.getClassLoader().getResourceAsStream(xsdName);
                if (null != xsdStream) {
                    factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    Schema schema = ((SchemaFactory)factory).newSchema(new StreamSource(xsdStream));
                    u.setSchema(schema);
                    jaxbSchemas.put(xsdName, schema);
                } else if (logXsd) {
                    LOG.info("Schema '" + xsdName + "' for " + file.getAbsolutePath() + " was not found, ignoring");
                }
            }
        } else if (logXsd) {
            LOG.info("NOT processing " + file.getAbsolutePath() + "; there is no XSD");
        }
        try {
            factory = clz.cast(u.unmarshal(file));
        }
        catch (Exception unmarshalException) {
            try {
                Throwable cause = ExceptionUtils.getRootCause((Throwable)unmarshalException);
                LOG.error("Cannot parse {}", (Object)file.getAbsolutePath());
                if (null != cause) {
                    LOG.error(cause.getMessage(), cause);
                }
                throw unmarshalException;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(xsdStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)xsdStream);
        return (T)factory;
    }

    static {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{StackMetainfoXml.class, RepositoryXml.class, ConfigurationXml.class, UpgradePack.class, ConfigUpgradePack.class});
            jaxbContexts.put(StackMetainfoXml.class, ctx);
            jaxbContexts.put(RepositoryXml.class, ctx);
            jaxbContexts.put(ConfigurationXml.class, ctx);
            jaxbContexts.put(UpgradePack.class, ctx);
            jaxbContexts.put(ConfigUpgradePack.class, ctx);
            jaxbContexts.put(ServiceMetainfoXml.class, JAXBContext.newInstance((Class[])new Class[]{ServiceMetainfoXml.class}));
            jaxbContexts.put(ExtensionMetainfoXml.class, JAXBContext.newInstance((Class[])new Class[]{ExtensionMetainfoXml.class}));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

