/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.ServiceComponentHost;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HostsType {
    private final List<HighAvailabilityHosts> highAvailabilityHosts;
    private LinkedHashSet<String> hosts;
    public List<ServiceComponentHost> unhealthy = new ArrayList<ServiceComponentHost>();

    public boolean hasMasters() {
        return !this.getMasters().isEmpty();
    }

    public List<HighAvailabilityHosts> getHighAvailabilityHosts() {
        return this.highAvailabilityHosts;
    }

    public void arrangeHostSecondariesFirst() {
        this.hosts = this.getHighAvailabilityHosts().stream().flatMap(each -> Stream.concat(each.getSecondaries().stream(), Stream.of(each.getMaster()))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public boolean hasMastersAndSecondaries() {
        return !this.getMasters().isEmpty() && !this.getSecondaries().isEmpty();
    }

    public static HostsType from(String master, String secondary, LinkedHashSet<String> hosts) {
        return master == null ? HostsType.normal(hosts) : new HostsType(Collections.singletonList(new HighAvailabilityHosts(master, secondary != null ? Collections.singletonList(secondary) : Collections.emptyList())), hosts);
    }

    public static HostsType highAvailability(String master, String secondary, LinkedHashSet<String> hosts) {
        return new HostsType(Collections.singletonList(new HighAvailabilityHosts(master, Collections.singletonList(secondary))), hosts);
    }

    public static HostsType guessHighAvailability(LinkedHashSet<String> hosts) {
        if (hosts.isEmpty()) {
            throw new IllegalArgumentException("Cannot guess HA, empty hosts.");
        }
        String master = (String)hosts.iterator().next();
        List<String> secondaries = hosts.stream().skip(1L).collect(Collectors.toList());
        return new HostsType(Collections.singletonList(new HighAvailabilityHosts(master, secondaries)), hosts);
    }

    public static HostsType federated(List<HighAvailabilityHosts> highAvailabilityHosts, LinkedHashSet<String> hosts) {
        return new HostsType(highAvailabilityHosts, hosts);
    }

    public static HostsType normal(LinkedHashSet<String> hosts) {
        return new HostsType(Collections.emptyList(), hosts);
    }

    public static HostsType normal(String ... hosts) {
        return new HostsType(Collections.emptyList(), new LinkedHashSet<String>(Arrays.asList(hosts)));
    }

    public static HostsType single(String host) {
        return HostsType.normal(host);
    }

    public static HostsType healthy(Cluster cluster) {
        LinkedHashSet<String> hostNames = new LinkedHashSet<String>();
        for (Host host : cluster.getHosts()) {
            MaintenanceState maintenanceState = host.getMaintenanceState(cluster.getClusterId());
            if (maintenanceState != MaintenanceState.OFF) continue;
            hostNames.add(host.getHostName());
        }
        return HostsType.normal(hostNames);
    }

    private HostsType(List<HighAvailabilityHosts> highAvailabilityHosts, LinkedHashSet<String> hosts) {
        this.highAvailabilityHosts = highAvailabilityHosts;
        this.hosts = hosts;
    }

    public LinkedHashSet<String> getMasters() {
        return this.highAvailabilityHosts.stream().map(each -> each.getMaster()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public LinkedHashSet<String> getSecondaries() {
        return this.highAvailabilityHosts.stream().flatMap(each -> each.getSecondaries().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(LinkedHashSet<String> hosts) {
        this.hosts = hosts;
    }

    public static class HighAvailabilityHosts {
        private final String master;
        private final List<String> secondaries;

        public HighAvailabilityHosts(String master, List<String> secondaries) {
            if (master == null) {
                throw new IllegalArgumentException("Master host is missing");
            }
            this.master = master;
            this.secondaries = secondaries;
        }

        public String getMaster() {
            return this.master;
        }

        public List<String> getSecondaries() {
            return this.secondaries;
        }
    }
}

