/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.stack.BaseModule;
import id.onyx.obdp.server.stack.ConfigurationModule;
import id.onyx.obdp.server.stack.ExtensionDirectory;
import id.onyx.obdp.server.stack.ModuleState;
import id.onyx.obdp.server.stack.ServiceDirectory;
import id.onyx.obdp.server.stack.ServiceModule;
import id.onyx.obdp.server.stack.StackContext;
import id.onyx.obdp.server.stack.StackModule;
import id.onyx.obdp.server.stack.Validable;
import id.onyx.obdp.server.state.ExtensionInfo;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.stack.ExtensionMetainfoXml;
import id.onyx.obdp.server.state.stack.ServiceMetainfoXml;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionModule
extends BaseModule<ExtensionModule, ExtensionInfo>
implements Validable {
    private StackContext stackContext;
    private Map<String, ConfigurationModule> configurationModules = new HashMap<String, ConfigurationModule>();
    private Map<String, ServiceModule> serviceModules = new HashMap<String, ServiceModule>();
    private ExtensionInfo extensionInfo;
    private ExtensionDirectory extensionDirectory;
    private String id;
    protected boolean valid = true;
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionModule.class);
    private Set<String> errorSet = new HashSet<String>();

    public ExtensionModule(ExtensionDirectory extensionDirectory, StackContext stackContext) {
        this.extensionDirectory = extensionDirectory;
        this.stackContext = stackContext;
        this.extensionInfo = new ExtensionInfo();
        this.populateExtensionInfo();
    }

    public Map<String, ServiceModule> getServiceModules() {
        return this.serviceModules;
    }

    @Override
    public void resolve(ExtensionModule parentModule, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        this.moduleState = ModuleState.VISITED;
        this.checkExtensionName(allStacks);
        String parentVersion = this.extensionInfo.getParentExtensionVersion();
        this.mergeServicesWithExplicitParent(allStacks, commonServices, extensions);
        if (parentVersion != null) {
            this.mergeExtensionWithParent(parentVersion, allStacks, commonServices, extensions);
        }
        this.moduleState = ModuleState.RESOLVED;
    }

    @Override
    public ExtensionInfo getModuleInfo() {
        return this.extensionInfo;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void finalizeModule() {
        this.finalizeChildModules(this.serviceModules.values());
        this.finalizeChildModules(this.configurationModules.values());
    }

    public ExtensionDirectory getExtensionDirectory() {
        return this.extensionDirectory;
    }

    private void mergeExtensionWithParent(String parentVersion, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        String parentExtensionKey = this.extensionInfo.getName() + "/" + parentVersion;
        ExtensionModule parentExtension = extensions.get(parentExtensionKey);
        if (parentExtension == null) {
            throw new OBDPException("Extension '" + this.extensionInfo.getName() + ":" + this.extensionInfo.getVersion() + "' specifies a parent that doesn't exist");
        }
        this.resolveExtension(parentExtension, allStacks, commonServices, extensions);
        this.mergeServicesWithParent(parentExtension, allStacks, commonServices, extensions);
    }

    private void mergeServicesWithParent(ExtensionModule parentExtension, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        this.extensionInfo.getServices().clear();
        LOG.info("***Merging extension services with parent: " + parentExtension.getId());
        Collection<ServiceModule> mergedModules = this.mergeChildModules(allStacks, commonServices, extensions, this.serviceModules, parentExtension.serviceModules);
        for (ServiceModule module : mergedModules) {
            if (module.isDeleted()) continue;
            this.serviceModules.put(module.getId(), module);
            this.extensionInfo.getServices().add(module.getModuleInfo());
        }
    }

    private void mergeServicesWithExplicitParent(Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        for (ServiceModule service : this.serviceModules.values()) {
            ServiceInfo serviceInfo = service.getModuleInfo();
            String parent = serviceInfo.getParent();
            if (parent == null) continue;
            this.mergeServiceWithExplicitParent(service, parent, allStacks, commonServices, extensions);
        }
    }

    private void mergeServiceWithExplicitParent(ServiceModule service, String parent, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        if (!this.isCommonServiceParent(parent)) {
            throw new OBDPException("The service '" + service.getModuleInfo().getName() + "' in extension '" + this.extensionInfo.getName() + ":" + this.extensionInfo.getVersion() + "' extends an invalid parent: '" + parent + "'");
        }
        LOG.info("merging with common service: " + service.getModuleInfo().getName());
        this.mergeServiceWithCommonServiceParent(service, parent, allStacks, commonServices, extensions);
        LOG.info("display name: " + service.getModuleInfo().getDisplayName());
    }

    private void checkExtensionName(Map<String, StackModule> allStacks) throws OBDPException {
        String name = this.extensionInfo.getName();
        for (StackModule stack : allStacks.values()) {
            String stackName = stack.getModuleInfo().getName();
            if (!name.equals(stackName)) continue;
            throw new OBDPException("The extension '" + name + "' has a name which matches a stack name");
        }
    }

    private boolean isCommonServiceParent(String parent) {
        return parent != null && !parent.isEmpty() && parent.split("/")[0].equalsIgnoreCase("common-services");
    }

    private void mergeServiceWithCommonServiceParent(ServiceModule service, String parent, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        ServiceInfo serviceInfo = service.getModuleInfo();
        String[] parentToks = parent.split("/");
        if (parentToks.length != 3 || !parentToks[0].equalsIgnoreCase("common-services")) {
            throw new OBDPException("The service '" + serviceInfo.getName() + "' in extension '" + this.extensionInfo.getName() + ":" + this.extensionInfo.getVersion() + "' extends an invalid parent: '" + parent + "'");
        }
        String baseServiceKey = parentToks[1] + "/" + parentToks[2];
        ServiceModule baseService = commonServices.get(baseServiceKey);
        if (baseService == null) {
            this.setValid(false);
            this.extensionInfo.setValid(false);
            String error = "The service '" + serviceInfo.getName() + "' in extension '" + this.extensionInfo.getName() + ":" + this.extensionInfo.getVersion() + "' extends a non-existent service: '" + parent + "'";
            this.addError(error);
            this.extensionInfo.addError(error);
        } else if (baseService.isValid()) {
            service.resolveExplicit(baseService, allStacks, commonServices, extensions);
        } else {
            this.setValid(false);
            this.extensionInfo.setValid(false);
            this.addErrors(baseService.getErrors());
            this.extensionInfo.addErrors(baseService.getErrors());
        }
    }

    private void populateExtensionInfo() {
        this.extensionInfo.setName(this.extensionDirectory.getExtensionDirName());
        this.extensionInfo.setVersion(this.extensionDirectory.getName());
        this.id = String.format("%s:%s", this.extensionInfo.getName(), this.extensionInfo.getVersion());
        LOG.debug("Adding new extension to known extensions, extensionName = {}, extensionVersion = {}", (Object)this.extensionInfo.getName(), (Object)this.extensionInfo.getVersion());
        ExtensionMetainfoXml emx = this.extensionDirectory.getMetaInfoFile();
        if (emx != null) {
            if (!emx.isValid()) {
                this.extensionInfo.setValid(false);
                this.extensionInfo.addErrors(emx.getErrors());
            }
            this.extensionInfo.setParentExtensionVersion(emx.getExtends());
            this.extensionInfo.setStacks(emx.getStacks());
            this.extensionInfo.setExtensions(emx.getExtensions());
            this.extensionInfo.setActive(emx.getVersion().isActive());
            this.extensionInfo.setAutoLink(emx.isAutoLink());
        }
        try {
            this.populateServices();
            if (!this.extensionInfo.isValid()) {
                this.setValid(false);
                this.addErrors(this.extensionInfo.getErrors());
            }
        }
        catch (Exception e) {
            String error = "Exception caught while populating services for extension: " + this.extensionInfo.getName() + "-" + this.extensionInfo.getVersion();
            this.setValid(false);
            this.extensionInfo.setValid(false);
            this.addError(error);
            this.extensionInfo.addError(error);
            LOG.error(error);
        }
    }

    private void populateServices() throws OBDPException {
        for (ServiceDirectory serviceDir : this.extensionDirectory.getServiceDirectories()) {
            this.populateService(serviceDir);
        }
    }

    private void populateService(ServiceDirectory serviceDirectory) {
        ArrayList<ServiceModule> serviceModules = new ArrayList<ServiceModule>();
        ServiceMetainfoXml metaInfoXml = serviceDirectory.getMetaInfoFile();
        if (!metaInfoXml.isValid()) {
            this.extensionInfo.setValid(metaInfoXml.isValid());
            this.setValid(metaInfoXml.isValid());
            this.extensionInfo.addErrors(metaInfoXml.getErrors());
            this.addErrors(metaInfoXml.getErrors());
            return;
        }
        List<ServiceInfo> serviceInfos = metaInfoXml.getServices();
        for (ServiceInfo serviceInfo : serviceInfos) {
            ServiceModule serviceModule = new ServiceModule(this.stackContext, serviceInfo, serviceDirectory);
            serviceModules.add(serviceModule);
            if (serviceModule.isValid()) continue;
            this.extensionInfo.setValid(false);
            this.setValid(false);
            this.extensionInfo.addErrors(serviceModule.getErrors());
            this.addErrors(serviceModule.getErrors());
        }
        this.addServices(serviceModules);
    }

    private void resolveExtension(ExtensionModule parentExtension, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        if (parentExtension.getModuleState() == ModuleState.INIT) {
            parentExtension.resolve(null, allStacks, commonServices, extensions);
        } else if (parentExtension.getModuleState() == ModuleState.VISITED) {
            throw new OBDPException("Cycle detected while parsing extension definition");
        }
        if (!parentExtension.isValid() || parentExtension.getModuleInfo() != null && !parentExtension.getModuleInfo().isValid()) {
            this.setValid(parentExtension.isValid());
            this.extensionInfo.setValid(parentExtension.extensionInfo.isValid());
            this.addErrors(parentExtension.getErrors());
            this.extensionInfo.addErrors(parentExtension.getErrors());
        }
    }

    private void addService(ServiceModule service) {
        ServiceInfo serviceInfo = service.getModuleInfo();
        ServiceModule previousValue = this.serviceModules.put(service.getId(), service);
        if (previousValue == null) {
            this.extensionInfo.getServices().add(serviceInfo);
        }
    }

    private void addServices(Collection<ServiceModule> services) {
        for (ServiceModule service : services) {
            this.addService(service);
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public Collection<String> getErrors() {
        return this.errorSet;
    }

    @Override
    public void addError(String error) {
        this.errorSet.add(error);
    }

    @Override
    public void addErrors(Collection<String> errors) {
        this.errorSet.addAll(errors);
    }
}

