/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ServiceNotFoundException;
import id.onyx.obdp.server.stack.StackManager;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ExtensionInfo;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.stack.ExtensionMetainfoXml;
import id.onyx.obdp.server.utils.VersionUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionHelper.class);

    public static void validateDeleteLink(Clusters clusters, StackInfo stack, ExtensionInfo extension) throws OBDPException {
        ExtensionHelper.validateNotRequiredExtension(stack, extension);
        ExtensionHelper.validateServicesNotInstalled(clusters, stack, extension);
    }

    private static void validateServicesNotInstalled(Clusters clusters, StackInfo stack, ExtensionInfo extension) throws OBDPException {
        for (Cluster cluster : clusters.getClusters().values()) {
            for (ServiceInfo service : extension.getServices()) {
                try {
                    if (service == null || cluster.getService(service.getName()) == null) continue;
                    String message = "Extension service is still installed, stackName=" + stack.getName() + ", stackVersion=" + stack.getVersion() + ", service=" + service.getName() + ", extensionName=" + extension.getName() + ", extensionVersion=" + extension.getVersion();
                    throw new OBDPException(message);
                }
                catch (ServiceNotFoundException serviceNotFoundException) {
                }
            }
        }
    }

    public static void validateCreateLink(StackManager stackManager, StackInfo stack, ExtensionInfo extension) throws OBDPException {
        ExtensionHelper.validateSupportedStackVersion(stack, extension);
        ExtensionHelper.validateServiceDuplication(stackManager, stack, extension);
        ExtensionHelper.validateRequiredExtensions(stack, extension);
    }

    public static void validateUpdateLink(StackManager stackManager, StackInfo stack, ExtensionInfo oldExtension, ExtensionInfo newExtension) throws OBDPException {
        ExtensionHelper.validateSupportedStackVersion(stack, newExtension);
        ExtensionHelper.validateServiceDuplication(stackManager, stack, oldExtension, newExtension);
        ExtensionHelper.validateRequiredExtensions(stack, newExtension);
    }

    private static void validateSupportedStackVersion(StackInfo stack, ExtensionInfo extension) throws OBDPException {
        for (ExtensionMetainfoXml.Stack validStack : extension.getStacks()) {
            if (!validStack.getName().equals(stack.getName())) continue;
            String minStackVersion = validStack.getVersion();
            if (VersionUtils.compareVersions((String)stack.getVersion(), (String)minStackVersion) < 0) continue;
            return;
        }
        String message = "Stack is not supported by extension, stackName=" + stack.getName() + ", stackVersion=" + stack.getVersion() + ", extensionName=" + extension.getName() + ", extensionVersion=" + extension.getVersion();
        throw new OBDPException(message);
    }

    private static void validateServiceDuplication(StackManager stackManager, StackInfo stack, ExtensionInfo extension) throws OBDPException {
        ExtensionHelper.validateServiceDuplication(stackManager, stack, extension, extension.getServices());
    }

    private static void validateServiceDuplication(StackManager stackManager, StackInfo stack, ExtensionInfo oldExtension, ExtensionInfo newExtension) throws OBDPException {
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>(newExtension.getServices().size());
        for (ServiceInfo service : newExtension.getServices()) {
            boolean found = false;
            for (ServiceInfo current : oldExtension.getServices()) {
                if (!service.getName().equals(current.getName())) continue;
                found = true;
            }
            if (found) continue;
            services.add(service);
        }
        ExtensionHelper.validateServiceDuplication(stackManager, stack, newExtension, services);
    }

    private static void validateServiceDuplication(StackManager stackManager, StackInfo stack, ExtensionInfo extension, Collection<ServiceInfo> services) throws OBDPException {
        LOG.debug("Looking for duplicate services");
        for (ServiceInfo service : services) {
            if (service == null) continue;
            LOG.debug("Looking for duplicate service " + service.getName());
            ServiceInfo stackService = null;
            try {
                stackService = stack.getService(service.getName());
                if (stackService != null) {
                    LOG.debug("Found service " + service.getName());
                    if (ExtensionHelper.isInheritedExtensionService(stackManager, stack, service.getName(), extension.getName())) {
                        stackService = null;
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error validating service duplication", (Throwable)e);
            }
            if (stackService == null) continue;
            String message = "Existing service is included in extension, stackName=" + stack.getName() + ", stackVersion=" + stack.getVersion() + ", service=" + service.getName() + ", extensionName=" + extension.getName() + ", extensionVersion=" + extension.getVersion();
            throw new OBDPException(message);
        }
    }

    private static boolean isInheritedExtensionService(StackManager stackManager, StackInfo stack, String serviceName, String extensionName) {
        if (ExtensionHelper.isExtensionService(stack, serviceName, extensionName)) {
            LOG.debug("Service is at requested stack/version level " + serviceName);
            return false;
        }
        return ExtensionHelper.isExtensionService(stackManager, stack.getName(), stack.getParentStackVersion(), serviceName, extensionName);
    }

    private static boolean isExtensionService(StackManager stackManager, String stackName, String stackVersion, String serviceName, String extensionName) {
        LOG.debug("Checking at stack/version " + stackName + "/" + stackVersion);
        StackInfo stack = stackManager.getStack(stackName, stackVersion);
        if (stack == null) {
            LOG.warn("Stack/version not found " + stackName + "/" + stackVersion);
            return false;
        }
        if (ExtensionHelper.isExtensionService(stack, serviceName, extensionName)) {
            LOG.debug("Stack/version " + stackName + "/" + stackVersion + " contains service " + serviceName);
            return true;
        }
        return ExtensionHelper.isExtensionService(stackManager, stackName, stack.getParentStackVersion(), serviceName, extensionName);
    }

    private static boolean isExtensionService(StackInfo stack, String serviceName, String extensionName) {
        ExtensionInfo extension = stack.getExtension(extensionName);
        if (extension == null) {
            LOG.debug("Extension not found " + extensionName);
            return false;
        }
        return extension.getService(serviceName) != null;
    }

    private static void validateRequiredExtensions(StackInfo stack, ExtensionInfo extension) throws OBDPException {
        for (ExtensionMetainfoXml.Extension requiredExtension : extension.getExtensions()) {
            if (requiredExtension == null) continue;
            String message = "Stack has not linked required extension, stackName=" + stack.getName() + ", stackVersion=" + stack.getVersion() + ", extensionName=" + extension.getName() + ", extensionVersion=" + extension.getVersion() + ", requiredExtensionName=" + requiredExtension.getName() + ", requiredExtensionVersion=" + requiredExtension.getVersion();
            try {
                ExtensionInfo stackExtension = stack.getExtension(requiredExtension.getName());
                if (stackExtension == null) continue;
                String version = requiredExtension.getVersion();
                if (version.endsWith("*")) {
                    version = version.substring(0, version.length() - 1);
                    if (stackExtension.getVersion().startsWith(version)) continue;
                    throw new OBDPException(message);
                }
                if (stackExtension.getVersion().equals(version)) continue;
                throw new OBDPException(message);
            }
            catch (Exception e) {
                throw new OBDPException(message, (Throwable)e);
            }
        }
    }

    private static void validateNotRequiredExtension(StackInfo stack, ExtensionInfo extension) throws OBDPException {
        for (ExtensionInfo stackExtension : stack.getExtensions()) {
            if (stackExtension == null) continue;
            for (ExtensionMetainfoXml.Extension requiredExtension : stackExtension.getExtensions()) {
                if (requiredExtension == null || !requiredExtension.getName().equals(extension.getName())) continue;
                String message = "Stack extension is required by extension, stackName=" + stack.getName() + ", stackVersion=" + stack.getVersion() + ", extensionName=" + extension.getName() + ", extensionVersion=" + extension.getVersion() + ", dependentExtensionName=" + stackExtension.getName() + ", dependentExtensionVersion=" + stackExtension.getVersion();
                throw new OBDPException(message);
            }
        }
    }
}

