/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.stack.ModuleFileUnmarshaller;
import id.onyx.obdp.server.stack.ServiceDirectory;
import id.onyx.obdp.server.stack.StackDefinitionDirectory;
import id.onyx.obdp.server.stack.StackDirectory;
import id.onyx.obdp.server.stack.StackServiceDirectory;
import id.onyx.obdp.server.state.stack.ExtensionMetainfoXml;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionDirectory
extends StackDefinitionDirectory {
    private Collection<ServiceDirectory> serviceDirectories;
    private ExtensionMetainfoXml metaInfoXml;
    ModuleFileUnmarshaller unmarshaller = new ModuleFileUnmarshaller();
    public static final String EXTENSIONS_FOLDER_NAME = "extensions";
    private static final String EXTENSION_METAINFO_FILE_NAME = "metainfo.xml";
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionDirectory.class);

    public ExtensionDirectory(String directory) throws OBDPException {
        super(directory);
        this.parsePath();
    }

    public String getExtensionDirName() {
        return this.getDirectory().getParentFile().getName();
    }

    public ExtensionMetainfoXml getMetaInfoFile() {
        return this.metaInfoXml;
    }

    public Collection<ServiceDirectory> getServiceDirectories() {
        return this.serviceDirectories;
    }

    private void parsePath() throws OBDPException {
        List<String> subDirs = Arrays.asList(this.directory.list());
        this.parseServiceDirectories(subDirs);
        this.parseMetaInfoFile();
    }

    private void parseMetaInfoFile() throws OBDPException {
        File extensionMetaInfoFile = new File(this.getAbsolutePath() + File.separator + EXTENSION_METAINFO_FILE_NAME);
        if (extensionMetaInfoFile.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reading extension version metainfo from file {}", (Object)extensionMetaInfoFile.getAbsolutePath());
            }
            try {
                this.metaInfoXml = this.unmarshaller.unmarshal(ExtensionMetainfoXml.class, extensionMetaInfoFile);
            }
            catch (Exception e) {
                this.metaInfoXml = new ExtensionMetainfoXml();
                this.metaInfoXml.setValid(false);
                this.metaInfoXml.addError("Unable to parse extension metainfo.xml file at location: " + extensionMetaInfoFile.getAbsolutePath());
            }
        }
    }

    private void parseServiceDirectories(Collection<String> subDirs) throws OBDPException {
        String servicesDir;
        File baseServiceDir;
        File[] serviceFolders;
        HashSet<ServiceDirectory> dirs = new HashSet<ServiceDirectory>();
        if (subDirs.contains("services") && (serviceFolders = (baseServiceDir = new File(servicesDir = this.getAbsolutePath() + File.separator + "services")).listFiles(StackDirectory.FILENAME_FILTER)) != null) {
            for (File d : serviceFolders) {
                if (!d.isDirectory()) continue;
                try {
                    dirs.add(new StackServiceDirectory(d.getAbsolutePath()));
                }
                catch (OBDPException e) {
                    LOG.warn(String.format("Unable to parse extension definition service at '%s'.  Ignoring service. : %s", d.getAbsolutePath(), e.toString()));
                }
            }
        }
        if (dirs.isEmpty()) {
            LOG.info("The extension defined at '" + this.getAbsolutePath() + "' contains no services");
        }
        this.serviceDirectories = dirs;
    }
}

