/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.stack.BaseModule;
import id.onyx.obdp.server.stack.ConfigurationInfo;
import id.onyx.obdp.server.stack.ExtensionModule;
import id.onyx.obdp.server.stack.ServiceModule;
import id.onyx.obdp.server.stack.StackModule;
import id.onyx.obdp.server.stack.Validable;
import id.onyx.obdp.server.state.PropertyInfo;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ConfigurationModule
extends BaseModule<ConfigurationModule, ConfigurationInfo>
implements Validable {
    private String configType;
    ConfigurationInfo info;
    private boolean isDeleted;
    protected boolean valid = true;
    private Set<String> errorSet = new HashSet<String>();

    @Override
    public void addError(String error) {
        this.errorSet.add(error);
    }

    @Override
    public Collection<String> getErrors() {
        return this.errorSet;
    }

    public ConfigurationModule(String configType, ConfigurationInfo info) {
        this.configType = configType;
        this.info = info;
        if (info != null && !info.isValid()) {
            this.setValid(info.isValid());
            this.addErrors(info.getErrors());
        }
    }

    @Override
    public void resolve(ConfigurationModule parent, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) throws OBDPException {
        if (parent != null) {
            if (!(parent.info == null || parent.isValid() && parent.info.isValid())) {
                this.setValid(false);
                this.info.setValid(false);
                this.addErrors(parent.getErrors());
                this.addErrors(parent.info.getErrors());
                this.info.addErrors(parent.getErrors());
                this.info.addErrors(parent.info.getErrors());
            }
            this.mergeProperties(parent);
            if (this.isExtensionEnabled()) {
                this.mergeAttributes(parent);
            }
        }
    }

    @Override
    public ConfigurationInfo getModuleInfo() {
        return this.info;
    }

    @Override
    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Override
    public String getId() {
        return this.getConfigType();
    }

    public String getConfigType() {
        return this.configType;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    private void mergeProperties(ConfigurationModule parent) {
        HashSet<CallSite> existingProps = new HashSet<CallSite>();
        Iterator<PropertyInfo> iter = this.info.getProperties().iterator();
        while (iter.hasNext()) {
            PropertyInfo prop = iter.next();
            existingProps.add((CallSite)((Object)(prop.getFilename() + "/" + prop.getName())));
            if (!prop.isDeleted()) continue;
            iter.remove();
        }
        if (this.isExtensionEnabled()) {
            for (PropertyInfo prop : parent.info.getProperties()) {
                if (existingProps.contains(prop.getFilename() + "/" + prop.getName())) continue;
                this.info.getProperties().add(prop);
            }
        }
    }

    private void mergeAttributes(ConfigurationModule parent) {
        for (Map.Entry<String, Map<String, String>> parentCategoryEntry : parent.info.getAttributes().entrySet()) {
            String category = parentCategoryEntry.getKey();
            Map<String, String> categoryAttributeMap = this.info.getAttributes().get(category);
            if (categoryAttributeMap == null) {
                categoryAttributeMap = new HashMap<String, String>();
                this.info.getAttributes().put(category, categoryAttributeMap);
            }
            for (Map.Entry<String, String> parentAttributeEntry : parentCategoryEntry.getValue().entrySet()) {
                String attributeName = parentAttributeEntry.getKey();
                if (categoryAttributeMap.containsKey(attributeName)) continue;
                categoryAttributeMap.put(attributeName, parentAttributeEntry.getValue());
            }
        }
    }

    private boolean isExtensionEnabled() {
        Map<String, String> supportsMap = this.getModuleInfo().getAttributes().get("supports");
        if (supportsMap == null) {
            return true;
        }
        String val = supportsMap.get(ConfigurationInfo.Supports.DO_NOT_EXTEND.getPropertyName());
        return val == null || val.equals("false");
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public void addErrors(Collection<String> errors) {
        this.errorSet.addAll(errors);
    }
}

