/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import id.onyx.obdp.server.stack.Validable;
import id.onyx.obdp.server.state.PropertyInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationInfo
implements Validable {
    private Collection<PropertyInfo> properties;
    private Map<String, Map<String, String>> attributes;
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationInfo.class);
    protected boolean valid = true;
    private Set<String> errorSet = new HashSet<String>();

    public ConfigurationInfo(Collection<PropertyInfo> properties, Map<String, String> attributes) {
        this.properties = properties;
        this.setAttributes(attributes);
    }

    public Collection<PropertyInfo> getProperties() {
        return this.properties;
    }

    public Map<String, Map<String, String>> getAttributes() {
        return this.attributes;
    }

    public void ensureDefaultAttributes() {
        Map<String, String> supportsAttributes = this.attributes.get("supports");
        for (Supports supportsProperty : Supports.values()) {
            String propertyName = supportsProperty.getPropertyName();
            if (supportsAttributes.containsKey(propertyName)) continue;
            supportsAttributes.put(propertyName, supportsProperty.getDefaultValue());
        }
    }

    private void setAttributes(Map<String, String> specifiedAttributes) {
        HashMap<String, Map<String, String>> attributes = new HashMap<String, Map<String, String>>();
        HashMap<String, String> supportsAttributes = new HashMap<String, String>();
        attributes.put("supports", supportsAttributes);
        for (Map.Entry<String, String> entry : specifiedAttributes.entrySet()) {
            String attributeName = entry.getKey();
            Supports s = Supports.attributeNameValueOf(attributeName);
            if (s != null) {
                supportsAttributes.put(s.getPropertyName(), Boolean.valueOf(entry.getValue()).toString());
                continue;
            }
            LOG.warn("Unknown configuration type attribute is specified: {}={}", (Object)attributeName, (Object)entry.getValue());
        }
        this.attributes = attributes;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public void addError(String error) {
        this.errorSet.add(error);
    }

    @Override
    public Collection<String> getErrors() {
        return this.errorSet;
    }

    @Override
    public void addErrors(Collection<String> errors) {
        this.errorSet.addAll(errors);
    }

    public static enum Supports {
        FINAL("supports_final"),
        ADDING_FORBIDDEN("supports_adding_forbidden"),
        DO_NOT_EXTEND("supports_do_not_extend");

        public static final String KEYWORD = "supports";
        private String defaultValue;
        private String xmlAttributeName;

        private Supports(String xmlAttributeName) {
            this(xmlAttributeName, Boolean.FALSE.toString());
        }

        private Supports(String xmlAttributeName, String defaultValue) {
            this.defaultValue = defaultValue;
            this.xmlAttributeName = xmlAttributeName;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getXmlAttributeName() {
            return this.xmlAttributeName;
        }

        public String getPropertyName() {
            return this.name().toLowerCase();
        }

        public static Supports attributeNameValueOf(String attributeName) {
            for (Supports s : Supports.values()) {
                if (!s.getXmlAttributeName().equals(attributeName)) continue;
                return s;
            }
            return null;
        }
    }
}

