/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import id.onyx.obdp.server.stack.ConfigurationInfo;
import id.onyx.obdp.server.stack.ConfigurationModule;
import id.onyx.obdp.server.stack.ModuleFileUnmarshaller;
import id.onyx.obdp.server.stack.StackDefinitionDirectory;
import id.onyx.obdp.server.stack.StackDirectory;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.stack.ConfigurationXml;
import id.onyx.obdp.server.utils.JsonUtils;
import id.onyx.obdp.server.utils.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

public class ConfigurationDirectory
extends StackDefinitionDirectory {
    private static ModuleFileUnmarshaller unmarshaller = new ModuleFileUnmarshaller();
    private Map<String, ConfigurationModule> configurationModules = new HashMap<String, ConfigurationModule>();
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationDirectory.class);
    protected File propertiesDirFile;

    public ConfigurationDirectory(String directoryName, String propertiesDirectoryName) {
        super(directoryName);
        if (!StringUtils.isBlank((String)propertiesDirectoryName)) {
            this.propertiesDirFile = new File(propertiesDirectoryName);
        }
        this.parsePath();
    }

    public Collection<ConfigurationModule> getConfigurationModules() {
        return this.configurationModules.values();
    }

    private void parsePath() {
        File[] configFiles = this.directory.listFiles(StackDirectory.FILENAME_FILTER);
        if (configFiles != null) {
            for (File configFile : configFiles) {
                if (!configFile.getName().endsWith(".xml")) continue;
                String configType = ConfigHelper.fileNameToConfigType(configFile.getName());
                ConfigurationXml config = null;
                try {
                    config = unmarshaller.unmarshal(ConfigurationXml.class, configFile);
                    ConfigurationInfo configInfo = new ConfigurationInfo(this.parseProperties(config, configFile.getName()), this.parseAttributes(config));
                    ConfigurationModule module = new ConfigurationModule(configType, configInfo);
                    this.configurationModules.put(configType, module);
                }
                catch (Exception e) {
                    String error = null;
                    error = e instanceof JAXBException || e instanceof UnmarshalException || e instanceof SAXParseException ? "Could not parse XML " + configFile + ": " + e : "Could not load configuration for " + configFile;
                    config = new ConfigurationXml();
                    config.setValid(false);
                    config.addError(error);
                    ConfigurationInfo configInfo = new ConfigurationInfo(this.parseProperties(config, configFile.getName()), this.parseAttributes(config));
                    configInfo.setValid(false);
                    configInfo.addError(error);
                    ConfigurationModule module = new ConfigurationModule(configType, configInfo);
                    this.configurationModules.put(configType, module);
                }
            }
        }
    }

    private Collection<PropertyInfo> parseProperties(ConfigurationXml configuration, String fileName) {
        ArrayList<PropertyInfo> props = new ArrayList<PropertyInfo>();
        for (PropertyInfo pi : configuration.getProperties()) {
            pi.setFilename(fileName);
            if (pi.getPropertyTypes().contains((Object)PropertyInfo.PropertyType.VALUE_FROM_PROPERTY_FILE)) {
                if (this.propertiesDirFile != null && this.propertiesDirFile.exists() && this.propertiesDirFile.isDirectory()) {
                    String propertyFileName = pi.getPropertyValueAttributes().getPropertyFileName();
                    String propertyFileType = pi.getPropertyValueAttributes().getPropertyFileType();
                    String propertyFilePath = this.propertiesDirFile.getAbsolutePath() + File.separator + propertyFileName;
                    File propertyFile = new File(propertyFilePath);
                    if (propertyFile.exists() && propertyFile.isFile()) {
                        try {
                            String propertyValue = FileUtils.readFileToString((File)propertyFile, (Charset)Charset.defaultCharset());
                            boolean valid = true;
                            switch (propertyFileType.toLowerCase()) {
                                case "xml": {
                                    if (XmlUtils.isValidXml(propertyValue)) break;
                                    valid = false;
                                    LOG.error("Failed to load value from property file. Property file {} is not a valid XML file", (Object)propertyFilePath);
                                    break;
                                }
                                case "json": {
                                    if (JsonUtils.isValidJson(propertyValue)) break;
                                    valid = false;
                                    LOG.error("Failed to load value from property file. Property file {} is not a valid JSON file", (Object)propertyFilePath);
                                    break;
                                }
                            }
                            if (valid) {
                                pi.setValue(propertyValue);
                            }
                        }
                        catch (IOException e) {
                            LOG.error("Failed to load value from property file {}. Error Message {}", (Object)propertyFilePath, (Object)e.getMessage());
                        }
                    } else {
                        LOG.error("Failed to load value from property file. Properties file {} does not exist", (Object)propertyFilePath);
                    }
                } else if (this.propertiesDirFile == null) {
                    LOG.error("Failed to load value from property file. Properties directory is null");
                } else {
                    LOG.error("Failed to load value from property file. Properties directory {} does not exist", (Object)this.propertiesDirFile.getAbsolutePath());
                }
            }
            props.add(pi);
        }
        return props;
    }

    private Map<String, String> parseAttributes(ConfigurationXml configuration) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Map.Entry<QName, String> attribute : configuration.getAttributes().entrySet()) {
            attributes.put(attribute.getKey().getLocalPart(), attribute.getValue());
        }
        return attributes;
    }
}

