/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import id.onyx.obdp.server.stack.BaseModule;
import id.onyx.obdp.server.stack.ExtensionModule;
import id.onyx.obdp.server.stack.ServiceModule;
import id.onyx.obdp.server.stack.StackModule;
import id.onyx.obdp.server.stack.Validable;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.CustomCommandDefinition;
import id.onyx.obdp.server.state.DependencyInfo;
import id.onyx.obdp.server.state.LogDefinition;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ComponentModule
extends BaseModule<ComponentModule, ComponentInfo>
implements Validable {
    private ComponentInfo componentInfo;
    protected boolean valid = true;
    private Set<String> errorSet = new HashSet<String>();

    public ComponentModule(ComponentInfo componentInfo) {
        this.componentInfo = componentInfo;
    }

    @Override
    public void resolve(ComponentModule parent, Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions) {
        if (parent != null) {
            ComponentInfo parentInfo = parent.getModuleInfo();
            if (!parent.isValid()) {
                this.setValid(false);
                this.addErrors(parent.getErrors());
            }
            if (this.componentInfo.getCommandScript() == null) {
                this.componentInfo.setCommandScript(parentInfo.getCommandScript());
            }
            if (this.componentInfo.getDisplayName() == null) {
                this.componentInfo.setDisplayName(parentInfo.getDisplayName());
            }
            if (this.componentInfo.getConfigDependencies() == null) {
                this.componentInfo.setConfigDependencies(parentInfo.getConfigDependencies());
            }
            if (this.componentInfo.getClientConfigFiles() == null) {
                this.componentInfo.setClientConfigFiles(parentInfo.getClientConfigFiles());
            }
            if (this.componentInfo.getClientsToUpdateConfigs() == null) {
                this.componentInfo.setClientsToUpdateConfigs(parentInfo.getClientsToUpdateConfigs());
            }
            if (this.componentInfo.getCategory() == null) {
                this.componentInfo.setCategory(parentInfo.getCategory());
            }
            if (this.componentInfo.getCardinality() == null) {
                this.componentInfo.setCardinality(parentInfo.getCardinality());
            }
            if (null == this.componentInfo.getVersionAdvertisedField()) {
                this.componentInfo.setVersionAdvertised(parentInfo.isVersionAdvertised());
            } else {
                this.componentInfo.setVersionAdvertised(this.componentInfo.getVersionAdvertisedField());
            }
            if (this.componentInfo.getDecommissionAllowed() == null) {
                this.componentInfo.setDecommissionAllowed(parentInfo.getDecommissionAllowed());
            }
            if (this.componentInfo.getUnlimitedKeyJCERequired() == null) {
                this.componentInfo.setUnlimitedKeyJCERequired(parentInfo.getUnlimitedKeyJCERequired());
            }
            if (this.componentInfo.getAutoDeploy() == null) {
                this.componentInfo.setAutoDeploy(parentInfo.getAutoDeploy());
            }
            this.componentInfo.setRecoveryEnabled(parentInfo.isRecoveryEnabled());
            if (this.componentInfo.getBulkCommandDefinition() == null) {
                this.componentInfo.setBulkCommands(parentInfo.getBulkCommandDefinition());
            }
            if (this.componentInfo.getReassignAllowed() == null) {
                this.componentInfo.setReassignAllowed(parentInfo.getReassignAllowed());
            }
            if (this.componentInfo.getTimelineAppid() == null) {
                this.componentInfo.setTimelineAppid(parentInfo.getTimelineAppid());
            }
            this.mergeComponentDependencies(parentInfo.getDependencies(), this.componentInfo.getDependencies());
            this.mergeCustomCommands(parentInfo.getCustomCommands(), this.componentInfo.getCustomCommands());
            this.mergeLogs(parentInfo.getLogs(), this.componentInfo.getLogs());
        } else {
            this.componentInfo.setCardinality("0+");
        }
    }

    @Override
    public ComponentInfo getModuleInfo() {
        return this.componentInfo;
    }

    @Override
    public boolean isDeleted() {
        return this.componentInfo.isDeleted();
    }

    @Override
    public String getId() {
        return this.componentInfo.getName();
    }

    private void mergeComponentDependencies(List<DependencyInfo> parentDependencies, List<DependencyInfo> childDependencies) {
        HashSet<String> existingNames = new HashSet<String>();
        for (DependencyInfo childDependency : childDependencies) {
            existingNames.add(childDependency.getName());
        }
        if (parentDependencies != null) {
            for (DependencyInfo parentDependency : parentDependencies) {
                if (existingNames.contains(parentDependency.getName())) continue;
                childDependencies.add(parentDependency);
            }
        }
    }

    private void mergeCustomCommands(List<CustomCommandDefinition> parentCommands, List<CustomCommandDefinition> childCommands) {
        HashSet<String> existingNames = new HashSet<String>();
        for (CustomCommandDefinition childCmd : childCommands) {
            existingNames.add(childCmd.getName());
        }
        if (parentCommands != null) {
            for (CustomCommandDefinition parentCmd : parentCommands) {
                if (existingNames.contains(parentCmd.getName())) continue;
                childCommands.add(parentCmd);
            }
        }
    }

    private void mergeLogs(List<LogDefinition> parentLogs, List<LogDefinition> childLogs) {
        HashSet<String> existingLogIds = new HashSet<String>();
        for (LogDefinition childLog : childLogs) {
            existingLogIds.add(childLog.getLogId());
        }
        if (parentLogs != null) {
            for (LogDefinition parentLog : parentLogs) {
                if (existingLogIds.contains(parentLog.getLogId())) continue;
                childLogs.add(parentLog);
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public void addError(String error) {
        this.errorSet.add(error);
    }

    @Override
    public Collection<String> getErrors() {
        return this.errorSet;
    }

    @Override
    public void addErrors(Collection<String> errors) {
        this.errorSet.addAll(errors);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

