/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.stack.ServiceDirectory;
import java.io.File;

public class CommonServiceDirectory
extends ServiceDirectory {
    public CommonServiceDirectory(String servicePath) throws OBDPException {
        super(servicePath);
    }

    @Override
    public String getAdvisorName(String serviceName) {
        if (this.getAdvisorFile() == null || serviceName == null) {
            return null;
        }
        File serviceVersionDir = new File(this.getAbsolutePath());
        String serviceVersion = serviceVersionDir.getName().replaceAll("\\.", "");
        String advisorName = serviceName + serviceVersion + "ServiceAdvisor";
        return advisorName;
    }

    @Override
    public String getService() {
        File serviceVersionDir = new File(this.getAbsolutePath());
        File serviceDir = serviceVersionDir.getParentFile();
        String service = String.format("%s-%s", serviceDir.getName(), serviceVersionDir.getName());
        return service;
    }

    @Override
    protected File getResourcesDirectory() {
        File serviceVersionDir = new File(this.getAbsolutePath());
        return serviceVersionDir.getParentFile().getParentFile().getParentFile();
    }

    @Override
    public String getStack() {
        return "common-services";
    }
}

