/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.stack;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.stack.ExtensionModule;
import id.onyx.obdp.server.stack.ModuleState;
import id.onyx.obdp.server.stack.ServiceModule;
import id.onyx.obdp.server.stack.StackDefinitionModule;
import id.onyx.obdp.server.stack.StackModule;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public abstract class BaseModule<T, I>
implements StackDefinitionModule<T, I> {
    protected ModuleState moduleState = ModuleState.INIT;

    @Override
    public ModuleState getModuleState() {
        return this.moduleState;
    }

    protected <T extends StackDefinitionModule<T, ?>> Collection<T> mergeChildModules(Map<String, StackModule> allStacks, Map<String, ServiceModule> commonServices, Map<String, ExtensionModule> extensions, Map<String, T> modules, Map<String, T> parentModules) throws OBDPException {
        String id;
        HashSet<String> addedModules = new HashSet<String>();
        HashSet<StackDefinitionModule> mergedModules = new HashSet<StackDefinitionModule>();
        for (StackDefinitionModule module : modules.values()) {
            id = module.getId();
            addedModules.add(id);
            if (!module.isDeleted() && parentModules.containsKey(id)) {
                module.resolve((StackDefinitionModule)parentModules.get(id), allStacks, commonServices, extensions);
            }
            mergedModules.add(module);
        }
        for (StackDefinitionModule parentModule : parentModules.values()) {
            id = parentModule.getId();
            if (addedModules.contains(id)) continue;
            mergedModules.add(parentModule);
        }
        return mergedModules;
    }

    protected void finalizeChildModules(Collection<? extends StackDefinitionModule> modules) {
        Iterator<? extends StackDefinitionModule> iter = modules.iterator();
        while (iter.hasNext()) {
            StackDefinitionModule module = iter.next();
            module.finalizeModule();
            if (!module.isDeleted()) continue;
            iter.remove();
        }
    }

    @Override
    public void finalizeModule() {
    }
}

