/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.users;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.hooks.users.UserHookParams;
import id.onyx.obdp.server.serveraction.AbstractServerAction;
import id.onyx.obdp.server.serveraction.users.CollectionPersisterServiceFactory;
import id.onyx.obdp.server.serveraction.users.CsvFilePersisterService;
import id.onyx.obdp.server.serveraction.users.ShellCommandUtilityWrapper;
import id.onyx.obdp.server.utils.ShellCommandUtil;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PostUserCreationHookServerAction
extends AbstractServerAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostUserCreationHookServerAction.class);
    private static final int MAX_SYMBOLS_PER_LOG_MESSAGE = 7900;
    @Inject
    private ShellCommandUtilityWrapper shellCommandUtilityWrapper;
    @Inject
    private ObjectMapper objectMapper;
    @Inject
    private CollectionPersisterServiceFactory collectionPersisterServiceFactory;

    @Inject
    public PostUserCreationHookServerAction() {
    }

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        LOGGER.debug("Executing custom script server action; Context: {}", requestSharedDataContext);
        ShellCommandUtil.Result result = null;
        CommandReport cmdReport = null;
        try {
            Map<String, String> commandParams = this.getCommandParameters();
            this.validateCommandParams(commandParams);
            CsvFilePersisterService csvPersisterService = this.collectionPersisterServiceFactory.createCsvFilePersisterService(commandParams.get(UserHookParams.CMD_INPUT_FILE.param()));
            csvPersisterService.persistMap(this.getPayload(commandParams));
            String[] cmd = this.assembleCommand(commandParams);
            result = this.shellCommandUtilityWrapper.runCommand(cmd);
            this.logCommandResult(Arrays.asList(cmd).toString(), result);
            cmdReport = this.createCommandReport(result.getExitCode(), result.isSuccessful() ? HostRoleStatus.COMPLETED : HostRoleStatus.FAILED, "{}", result.getStdout(), result.getStderr());
            LOGGER.debug("Command report: {}", (Object)cmdReport);
        }
        catch (InterruptedException e) {
            LOGGER.error("The server action thread has been interrupted", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Server action is about to quit due to an exception.", (Throwable)e);
            throw new OBDPException("Server action execution failed to complete!", (Throwable)e);
        }
        return cmdReport;
    }

    private void logCommandResult(String command, ShellCommandUtil.Result result) {
        String stringToLog;
        LOGGER.info("Execution of command [ {} ] - {}", (Object)command, (Object)(result.isSuccessful() ? "succeeded" : "failed"));
        String string = stringToLog = result.isSuccessful() ? result.getStdout() : result.getStderr();
        if (stringToLog == null) {
            stringToLog = "";
        }
        List logLines = Splitter.fixedLength((int)7900).splitToList((CharSequence)stringToLog);
        LOGGER.info("BEGIN - {} for command {}", (Object)(result.isSuccessful() ? "stdout" : "stderr"), (Object)command);
        for (String line : logLines) {
            LOGGER.info("command output *** : {}", (Object)line);
        }
        LOGGER.info("END - {} for command {}", (Object)(result.isSuccessful() ? "stdout" : "stderr"), (Object)command);
    }

    private String[] assembleCommand(Map<String, String> params) {
        Object[] cmdArray = new String[]{params.get(UserHookParams.SCRIPT.param()), params.get(UserHookParams.CMD_INPUT_FILE.param()), params.get(UserHookParams.CLUSTER_SECURITY_TYPE.param()), params.get(UserHookParams.CMD_HDFS_PRINCIPAL.param()), params.get(UserHookParams.CMD_HDFS_KEYTAB.param()), params.get(UserHookParams.CMD_HDFS_USER.param())};
        LOGGER.debug("Server action command to be executed: {}", cmdArray);
        return cmdArray;
    }

    private void validateCommandParams(Map<String, String> commandParams) {
        LOGGER.info("Validating command parameters ...");
        if (!commandParams.containsKey(UserHookParams.PAYLOAD.param())) {
            LOGGER.error("Missing command parameter: {}; Failing the server action.", (Object)UserHookParams.PAYLOAD.param());
            throw new IllegalArgumentException("Missing command parameter: [" + UserHookParams.PAYLOAD.param() + "]");
        }
        if (!commandParams.containsKey(UserHookParams.SCRIPT.param())) {
            LOGGER.error("Missing command parameter: {}; Failing the server action.", (Object)UserHookParams.SCRIPT.param());
            throw new IllegalArgumentException("Missing command parameter: [" + UserHookParams.SCRIPT.param() + "]");
        }
        if (!commandParams.containsKey(UserHookParams.CMD_INPUT_FILE.param())) {
            LOGGER.error("Missing command parameter: {}; Failing the server action.", (Object)UserHookParams.CMD_INPUT_FILE.param());
            throw new IllegalArgumentException("Missing command parameter: [" + UserHookParams.CMD_INPUT_FILE.param() + "]");
        }
        if (!commandParams.containsKey(UserHookParams.CLUSTER_SECURITY_TYPE.param())) {
            LOGGER.error("Missing command parameter: {}; Failing the server action.", (Object)UserHookParams.CLUSTER_SECURITY_TYPE.param());
            throw new IllegalArgumentException("Missing command parameter: [" + UserHookParams.CLUSTER_SECURITY_TYPE.param() + "]");
        }
        if (!commandParams.containsKey(UserHookParams.CMD_HDFS_USER.param())) {
            LOGGER.error("Missing command parameter: {}; Failing the server action.", (Object)UserHookParams.CMD_HDFS_USER.param());
            throw new IllegalArgumentException("Missing command parameter: [" + UserHookParams.CMD_HDFS_USER.param() + "]");
        }
        LOGGER.info("Command parameter validation passed.");
    }

    private Map<String, List<String>> getPayload(Map<String, String> commandParams) throws IOException {
        Map payload = (Map)this.objectMapper.readValue(commandParams.get(UserHookParams.PAYLOAD.param()), Map.class);
        return payload;
    }
}

