/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.users;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.serveraction.users.CollectionPersisterService;
import jakarta.inject.Inject;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvFilePersisterService
implements CollectionPersisterService<String, List<String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvFilePersisterService.class);
    private String NEW_LINE_SEPARATOR = "\n";
    private String csvFile;
    private CSVPrinter csvPrinter;
    private FileWriter fileWriter;

    @AssistedInject
    public CsvFilePersisterService(@Assisted String csvFile) {
        this.csvFile = csvFile;
    }

    public Set<PosixFilePermission> getCsvPermissions() {
        HashSet<PosixFilePermission> permissionsSet = new HashSet<PosixFilePermission>();
        permissionsSet.add(PosixFilePermission.OWNER_READ);
        permissionsSet.add(PosixFilePermission.OWNER_WRITE);
        permissionsSet.add(PosixFilePermission.GROUP_READ);
        permissionsSet.add(PosixFilePermission.OTHERS_READ);
        return permissionsSet;
    }

    @Inject
    public void init() throws IOException {
        Path csv = Files.createFile(Paths.get(this.csvFile, new String[0]), new FileAttribute[0]);
        Files.setPosixFilePermissions(Paths.get(this.csvFile, new String[0]), this.getCsvPermissions());
        this.fileWriter = new FileWriter(csv.toFile());
        this.csvPrinter = new CSVPrinter((Appendable)this.fileWriter, CSVFormat.DEFAULT.withRecordSeparator(this.NEW_LINE_SEPARATOR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean persist(Collection<List<String>> collectionData) {
        try {
            LOGGER.info("Persisting collection to csv file");
            this.csvPrinter.printRecords(collectionData);
            LOGGER.info("Collection successfully persisted to csv file.");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("Failed to persist the collection to csv file", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.fileWriter.flush();
                this.fileWriter.close();
                this.csvPrinter.close();
            }
            catch (IOException e) {
                LOGGER.error("Error while flushing/closing fileWriter/csvPrinter", (Throwable)e);
            }
        }
    }

    @Override
    public boolean persistMap(Map<String, List<String>> mapData) {
        LOGGER.info("Persisting map data to csv file");
        ArrayList<List<String>> collectionData = new ArrayList<List<String>>();
        for (String key : mapData.keySet()) {
            ArrayList<String> record = new ArrayList<String>();
            record.add(key);
            record.addAll((Collection)mapData.get(key));
            collectionData.add(record);
        }
        return this.persist((Collection<List<String>>)collectionData);
    }
}

