/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.upgrades;

import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.serveraction.upgrades.AbstractUpgradeServerAction;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.Host;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class YarnNodeManagerCapacityCalculation
extends AbstractUpgradeServerAction {
    private static final String YARN_SITE_CONFIG_TYPE = "yarn-site";
    private static final String YARN_ENV_CONFIG_TYPE = "yarn-env";
    private static final String YARN_HBASE_ENV_CONFIG_TYPE = "yarn-hbase-env";
    private static final String CAPACITY_SCHEDULER_CONFIG_TYPE = "capacity-scheduler";
    private static final String YARN_SYSTEM_SERVICE_USER_NAME = "yarn_ats_user";
    private static final String YARN_SYSTEM_SERVICE_QUEUE_NAME = "yarn-system";
    private static final String CAPACITY_SCHEDULER_ROOT_QUEUES = "yarn.scheduler.capacity.root.queues";
    private static final String YARN_SYSTEM_SERVICE_QUEUE_PREFIX = "yarn.scheduler.capacity.root.yarn-system";
    private static final float CLUSTER_CAPACITY_LIMIT_FOR_HBASE_SYSTEM_SERVICE = 51200.0f;
    private static final float NODE_CAPACITY_LIMIT_FOR_HBASE_SYSTEM_SERVICE = 10240.0f;
    private static final String YARN_NM_PMEM_MB_PROPERTY_NAME = "yarn.nodemanager.resource.memory-mb";
    private static final String YARN_HBASE_SYSTEM_SERVICE_QUEUE_PROPERTY_NAME = "yarn_hbase_system_service_queue_name";

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        String clusterName = this.getExecutionCommand().getClusterName();
        Cluster cluster = this.getClusters().getCluster(clusterName);
        Config yarnSiteConfig = cluster.getDesiredConfigByType(YARN_SITE_CONFIG_TYPE);
        if (yarnSiteConfig == null) {
            return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", String.format("Source type %s not found", YARN_SITE_CONFIG_TYPE), "");
        }
        int noOfNMHosts = cluster.getService("YARN").getServiceComponent("NODEMANAGER").getServiceComponentsHosts().size();
        String nmMemoryInString = yarnSiteConfig.getProperties().get(YARN_NM_PMEM_MB_PROPERTY_NAME);
        int nmMemory = Integer.parseInt(nmMemoryInString);
        int clusterCapacity = noOfNMHosts * nmMemory;
        String message = "";
        if ((float)nmMemory > 10240.0f && (float)clusterCapacity > 51200.0f) {
            Config yarnEnvConfig = cluster.getDesiredConfigByType(YARN_ENV_CONFIG_TYPE);
            if (yarnEnvConfig == null) {
                return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", String.format("Source type %s not found", YARN_ENV_CONFIG_TYPE), "");
            }
            String yarnAtsUser = yarnEnvConfig.getProperties().get(YARN_SYSTEM_SERVICE_USER_NAME);
            Config hbaseEnvConfig = cluster.getDesiredConfigByType(YARN_HBASE_ENV_CONFIG_TYPE);
            if (hbaseEnvConfig == null) {
                return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", String.format("Source type %s not found", YARN_HBASE_ENV_CONFIG_TYPE), "");
            }
            Map<String, String> hbaseEnvConfigProperties = hbaseEnvConfig.getProperties();
            String oldSystemServiceQueue = hbaseEnvConfigProperties.get(YARN_HBASE_SYSTEM_SERVICE_QUEUE_PROPERTY_NAME);
            Config csConfig = cluster.getDesiredConfigByType(CAPACITY_SCHEDULER_CONFIG_TYPE);
            if (csConfig == null) {
                return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", String.format("Source type %s not found", CAPACITY_SCHEDULER_CONFIG_TYPE), "");
            }
            Map<String, String> csProperties = csConfig.getProperties();
            String old_root_queues = csProperties.get(CAPACITY_SCHEDULER_ROOT_QUEUES);
            HashSet queues = Sets.newHashSet((Object[])old_root_queues.split(","));
            boolean isYarnSystemQueueExist = false;
            isYarnSystemQueueExist = queues.stream().map(queue -> queue.trim()).filter(queueName -> YARN_SYSTEM_SERVICE_QUEUE_NAME.equals(queueName)).findFirst().isPresent();
            String new_root_queues = old_root_queues + ",yarn-system";
            if (!isYarnSystemQueueExist) {
                csProperties.put(CAPACITY_SCHEDULER_ROOT_QUEUES, new_root_queues);
                csProperties.put("yarn.scheduler.capacity.root.yarn-system.capacity", "0");
                csProperties.put("yarn.scheduler.capacity.root.yarn-system.maximum-capacity", "100");
                csProperties.put("yarn.scheduler.capacity.root.yarn-system.user-limit-factor", "1");
                csProperties.put("yarn.scheduler.capacity.root.yarn-system.minimum-user-limit-percent", "100");
                csProperties.put("yarn.scheduler.capacity.root.yarn-system.state", "RUNNING");
                csProperties.put("yarn.scheduler.capacity.root.yarn-system.ordering-policy", "fifo");
                csProperties.put("yarn.scheduler.capacity.root.yarn-system.acl_submit_applications", yarnAtsUser);
                csProperties.put("yarn.scheduler.capacity.root.yarn-system.acl_administer_queue", yarnAtsUser);
                csProperties.put("yarn.scheduler.capacity.root.yarn-system.maximum-am-resource-percent", "0.5");
                csProperties.put("yarn.scheduler.capacity.root.yarn-system.disable_preemption", "true");
                csProperties.put("yarn.scheduler.capacity.root.yarn-system.intra-queue-preemption.disable_preemption", "true");
                csProperties.put("yarn.scheduler.capacity.root.yarn-system.priority", "32768");
                csProperties.put("yarn.scheduler.capacity.root.yarn-system.maximum-application-lifetime", "-1");
                csProperties.put("yarn.scheduler.capacity.root.yarn-system.default-application-lifetime", "-1");
                csConfig.setProperties(csProperties);
                csConfig.save();
                hbaseEnvConfigProperties.put(YARN_HBASE_SYSTEM_SERVICE_QUEUE_PROPERTY_NAME, YARN_SYSTEM_SERVICE_QUEUE_NAME);
                hbaseEnvConfig.setProperties(hbaseEnvConfigProperties);
                hbaseEnvConfig.save();
                message = String.format("%s was set from %s to %s. %s was set from %s to %s", CAPACITY_SCHEDULER_ROOT_QUEUES, old_root_queues, new_root_queues, YARN_HBASE_SYSTEM_SERVICE_QUEUE_PROPERTY_NAME, oldSystemServiceQueue, YARN_SYSTEM_SERVICE_QUEUE_NAME);
            }
        }
        this.agentConfigsHolder.updateData(cluster.getClusterId(), cluster.getHosts().stream().map(Host::getHostId).collect(Collectors.toList()));
        return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", message, "");
    }
}

