/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.upgrades;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.orm.dao.ArtifactDAO;
import id.onyx.obdp.server.orm.entities.ArtifactEntity;
import id.onyx.obdp.server.serveraction.upgrades.AbstractUpgradeServerAction;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptorFactory;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptorUpdateHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeUserKerberosDescriptor
extends AbstractUpgradeServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeUserKerberosDescriptor.class);
    private static final String KERBEROS_DESCRIPTOR_NAME = "kerberos_descriptor";
    private static final String KERBEROS_DESCRIPTOR_BACKUP_NAME = "kerberos_descriptor_backup";
    @Inject
    private ArtifactDAO artifactDAO;
    @Inject
    private OBDPMetaInfo obdpMetaInfo;
    @Inject
    private KerberosDescriptorFactory kerberosDescriptorFactory;

    protected UpgradeUserKerberosDescriptor() {
    }

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        KerberosDescriptor userDescriptor;
        HostRoleCommand hostRoleCommand = this.getHostRoleCommand();
        String clusterName = hostRoleCommand.getExecutionCommandWrapper().getExecutionCommand().getClusterName();
        Cluster cluster = this.getClusters().getCluster(clusterName);
        ArrayList<String> messages = new ArrayList<String>();
        ArrayList<String> errorMessages = new ArrayList<String>();
        UpgradeContext upgradeContext = this.getUpgradeContext(cluster);
        this.logMessage(messages, "Obtaining the user-defined Kerberos descriptor");
        TreeMap<String, String> foreignKeys = new TreeMap<String, String>();
        foreignKeys.put("cluster", String.valueOf(cluster.getClusterId()));
        ArtifactEntity entity = this.artifactDAO.findByNameAndForeignKeys(KERBEROS_DESCRIPTOR_NAME, foreignKeys);
        KerberosDescriptor kerberosDescriptor = userDescriptor = entity == null ? null : this.kerberosDescriptorFactory.createInstance(entity.getArtifactData());
        if (userDescriptor != null) {
            StackId originalStackId = cluster.getCurrentStackVersion();
            StackId targetStackId = upgradeContext.getRepositoryVersion().getStackId();
            if (upgradeContext.getDirection() == Direction.DOWNGRADE) {
                this.restoreDescriptor(foreignKeys, messages, errorMessages);
            } else {
                this.backupDescriptor(foreignKeys, messages, errorMessages);
                KerberosDescriptor newDescriptor = null;
                KerberosDescriptor previousDescriptor = null;
                if (targetStackId == null) {
                    this.logErrorMessage(messages, errorMessages, "The new stack version information was not found.");
                } else {
                    this.logMessage(messages, String.format("Obtaining new stack Kerberos descriptor for %s.", targetStackId.toString()));
                    newDescriptor = this.obdpMetaInfo.getKerberosDescriptor(targetStackId.getStackName(), targetStackId.getStackVersion(), false);
                    if (newDescriptor == null) {
                        this.logErrorMessage(messages, errorMessages, String.format("The Kerberos descriptor for the new stack version, %s, was not found.", targetStackId.toString()));
                    }
                }
                if (originalStackId == null) {
                    this.logErrorMessage(messages, errorMessages, "The previous stack version information was not found.");
                } else {
                    this.logMessage(messages, String.format("Obtaining previous stack Kerberos descriptor for %s.", originalStackId.toString()));
                    previousDescriptor = this.obdpMetaInfo.getKerberosDescriptor(originalStackId.getStackName(), originalStackId.getStackVersion(), false);
                    if (newDescriptor == null) {
                        this.logErrorMessage(messages, errorMessages, String.format("The Kerberos descriptor for the previous stack version, %s, was not found.", originalStackId.toString()));
                    }
                }
                if (errorMessages.isEmpty()) {
                    this.logMessage(messages, "Updating the user-specified Kerberos descriptor.");
                    KerberosDescriptor updatedDescriptor = KerberosDescriptorUpdateHelper.updateUserKerberosDescriptor(previousDescriptor, newDescriptor, userDescriptor);
                    this.logMessage(messages, "Storing updated user-specified Kerberos descriptor.");
                    entity.setArtifactData(updatedDescriptor.toMap());
                    this.artifactDAO.merge(entity);
                    this.logMessage(messages, "Successfully updated the user-specified Kerberos descriptor.");
                }
            }
        } else {
            this.logMessage(messages, "A user-specified Kerberos descriptor was not found. No updates are necessary.");
        }
        if (!errorMessages.isEmpty()) {
            this.logErrorMessage(messages, errorMessages, "No updates have been performed due to previous issues.");
        }
        return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", StringUtils.join(messages, (String)"\n"), StringUtils.join(errorMessages, (String)"\n"));
    }

    private void logMessage(List<String> messages, String message) {
        LOG.info(message);
        messages.add(message);
    }

    private void logErrorMessage(List<String> messages, List<String> errorMessages, String message) {
        LOG.error(message);
        messages.add(message);
        errorMessages.add(message);
    }

    private void backupDescriptor(TreeMap<String, String> foreignKeys, List<String> messages, List<String> errorMessages) {
        ArtifactEntity entity;
        ArtifactEntity backupEntity = this.artifactDAO.findByNameAndForeignKeys(KERBEROS_DESCRIPTOR_BACKUP_NAME, foreignKeys);
        if (backupEntity != null) {
            this.artifactDAO.remove(backupEntity);
        }
        if ((entity = this.artifactDAO.findByNameAndForeignKeys(KERBEROS_DESCRIPTOR_NAME, foreignKeys)) != null) {
            backupEntity = new ArtifactEntity();
            backupEntity.setArtifactName(KERBEROS_DESCRIPTOR_BACKUP_NAME);
            backupEntity.setForeignKeys(entity.getForeignKeys());
            backupEntity.setArtifactData(entity.getArtifactData());
            this.artifactDAO.create(backupEntity);
            this.logMessage(messages, "Created backup of kerberos descriptor");
        } else {
            this.logErrorMessage(messages, errorMessages, "No backup of kerberos descriptor created due to missing original kerberos descriptor");
        }
    }

    private void restoreDescriptor(TreeMap<String, String> foreignKeys, List<String> messages, List<String> errorMessages) {
        ArtifactEntity backupEntity = this.artifactDAO.findByNameAndForeignKeys(KERBEROS_DESCRIPTOR_BACKUP_NAME, foreignKeys);
        if (backupEntity != null) {
            ArtifactEntity entity = this.artifactDAO.findByNameAndForeignKeys(KERBEROS_DESCRIPTOR_NAME, foreignKeys);
            if (entity != null) {
                this.artifactDAO.remove(entity);
            }
            entity = new ArtifactEntity();
            entity.setArtifactName(KERBEROS_DESCRIPTOR_NAME);
            entity.setForeignKeys(backupEntity.getForeignKeys());
            entity.setArtifactData(backupEntity.getArtifactData());
            this.artifactDAO.create(entity);
            this.logMessage(messages, "Restored kerberos descriptor from backup");
        } else {
            this.logErrorMessage(messages, errorMessages, "No backup of kerberos descriptor found");
        }
    }
}

