/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.upgrades;

import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.dao.HostVersionDAO;
import id.onyx.obdp.server.orm.entities.HostVersionEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.serveraction.upgrades.AbstractUpgradeServerAction;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.RepositoryVersionState;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.spi.RepositoryType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDesiredRepositoryAction
extends AbstractUpgradeServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateDesiredRepositoryAction.class);
    @Inject
    private Configuration m_configuration;
    @Inject
    private HostVersionDAO m_hostVersionDAO;

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        String userName;
        String clusterName = this.getExecutionCommand().getClusterName();
        Cluster cluster = this.getClusters().getCluster(clusterName);
        UpgradeContext upgradeContext = this.getUpgradeContext(cluster);
        Map<String, String> roleParams = this.getExecutionCommand().getRoleParams();
        if (roleParams != null && roleParams.containsKey("ACTION_USER_NAME")) {
            userName = roleParams.get("ACTION_USER_NAME");
        } else {
            userName = this.m_configuration.getAnonymousAuditName();
            LOG.warn(String.format("Did not receive role parameter %s, will save configs using anonymous username %s", "ACTION_USER_NAME", userName));
        }
        CommandReport commandReport = this.updateDesiredRepositoryVersion(cluster, upgradeContext, userName);
        this.m_upgradeHelper.publishDesiredRepositoriesUpdates(upgradeContext);
        return commandReport;
    }

    @Transactional
    CommandReport updateDesiredRepositoryVersion(Cluster cluster, UpgradeContext upgradeContext, String userName) throws OBDPException, InterruptedException {
        StringBuilder out = new StringBuilder();
        StringBuilder err = new StringBuilder();
        try {
            Object targetStackId;
            String message;
            if (upgradeContext.getDirection() == Direction.UPGRADE) {
                RepositoryVersionEntity targetRepositoryVersion = upgradeContext.getRepositoryVersion();
                if (upgradeContext.getOrchestrationType() == RepositoryType.STANDARD) {
                    message = MessageFormat.format("Updating the desired repository version to {0} for all cluster services.", targetRepositoryVersion.getVersion());
                } else {
                    Set<String> servicesInUpgrade = upgradeContext.getSupportedServices();
                    message = MessageFormat.format("Updating the desired repository version to {0} for the following services: {1}", targetRepositoryVersion.getVersion(), StringUtils.join(servicesInUpgrade, (char)','));
                }
                out.append(message).append(System.lineSeparator());
                targetStackId = targetRepositoryVersion.getStackId();
                cluster.setDesiredStackVersion((StackId)targetStackId);
            }
            if (upgradeContext.getDirection() == Direction.DOWNGRADE) {
                message = "Updating the desired repository back their original values for the following services:";
                out.append(message).append(System.lineSeparator());
                Map<String, RepositoryVersionEntity> targetVersionsByService = upgradeContext.getTargetVersions();
                for (String serviceName : targetVersionsByService.keySet()) {
                    RepositoryVersionEntity repositoryVersion = targetVersionsByService.get(serviceName);
                    message = String.format("  %s to %s", serviceName, repositoryVersion.getVersion());
                    out.append(message).append(System.lineSeparator());
                }
            }
            this.m_upgradeHelper.updateDesiredRepositoriesAndConfigs(upgradeContext);
            if (upgradeContext.getDirection() == Direction.DOWNGRADE) {
                RepositoryVersionEntity downgradeFromRepositoryVersion = upgradeContext.getRepositoryVersion();
                out.append(String.format("Setting host versions back to %s for repository version %s", new Object[]{RepositoryVersionState.INSTALLED, downgradeFromRepositoryVersion.getVersion()}));
                List<HostVersionEntity> hostVersionsToReset = this.m_hostVersionDAO.findHostVersionByClusterAndRepository(cluster.getClusterId(), downgradeFromRepositoryVersion);
                for (HostVersionEntity hostVersion : hostVersionsToReset) {
                    if (hostVersion.getState() == RepositoryVersionState.NOT_REQUIRED) continue;
                    hostVersion.setState(RepositoryVersionState.INSTALLED);
                }
                targetStackId = cluster.getCurrentStackVersion();
                cluster.setDesiredStackVersion((StackId)targetStackId);
            }
            return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", out.toString(), err.toString());
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            err.append(sw);
            return this.createCommandReport(-1, HostRoleStatus.FAILED, "{}", out.toString(), err.toString());
        }
    }
}

