/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.upgrades;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.dao.KerberosKeytabPrincipalDAO;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.KerberosKeytabPrincipalEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.serveraction.kerberos.PreconfigureServiceType;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosKeytab;
import id.onyx.obdp.server.serveraction.upgrades.AbstractUpgradeServerAction;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptorContainer;
import id.onyx.obdp.server.state.kerberos.KerberosComponentDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosConfigurationDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosIdentityDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptor;
import id.onyx.obdp.server.state.kerberos.VariableReplacementHelper;
import id.onyx.obdp.server.utils.StageUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;

public class PreconfigureKerberosAction
extends AbstractUpgradeServerAction {
    static final String UPGRADE_DIRECTION_KEY = "upgrade_direction";
    @Inject
    private OBDPManagementController ambariManagementController;
    @Inject
    private KerberosHelper kerberosHelper;
    @Inject
    private ConfigHelper configHelper;
    @Inject
    private VariableReplacementHelper variableReplacementHelper;
    @Inject
    private HostDAO hostDAO;
    @Inject
    private KerberosKeytabPrincipalDAO kerberosKeytabPrincipalDAO;

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        Map<String, String> commandParameters = this.getCommandParameters();
        if (null == commandParameters || commandParameters.isEmpty()) {
            return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", "", "Unable to change configuration values without command parameters");
        }
        if (!this.isDowngrade()) {
            String clusterName = commandParameters.get("clusterName");
            Cluster cluster = this.getClusters().getCluster(clusterName);
            if (cluster.getSecurityType() == SecurityType.KERBEROS) {
                StackId stackId;
                try {
                    stackId = this.getTargetStackId(cluster);
                }
                catch (OBDPException e) {
                    return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", "", e.getLocalizedMessage());
                }
                if (stackId == null) {
                    return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", "", "The target stack Id was not specified.");
                }
                KerberosDescriptor kerberosDescriptor = this.kerberosHelper.getKerberosDescriptor(KerberosHelper.KerberosDescriptorType.COMPOSITE, cluster, stackId, true, null);
                Map<String, Map<String, String>> configurations = this.kerberosHelper.calculateConfigurations(cluster, null, kerberosDescriptor, true, false, null);
                PreconfigureServiceType preconfigureServiceType = this.getPreconfigureServiceType(configurations);
                if (preconfigureServiceType != PreconfigureServiceType.NONE) {
                    Map<String, KerberosServiceDescriptor> serviceDescriptors;
                    Map<String, Map<String, String>> kerberosConfigurations = new HashMap<String, Map<String, String>>();
                    HashMap<String, Set<String>> propertiesToRemove = new HashMap<String, Set<String>>();
                    HashMap<String, Set<String>> propertiesToIgnore = new HashMap<String, Set<String>>();
                    if (preconfigureServiceType == PreconfigureServiceType.ALL && (serviceDescriptors = kerberosDescriptor.getServices()) != null) {
                        for (KerberosServiceDescriptor serviceDescriptor : serviceDescriptors.values()) {
                            serviceDescriptor.setPreconfigure(true);
                        }
                    }
                    this.processServiceComponentHosts(cluster, kerberosDescriptor, configurations, kerberosConfigurations, propertiesToIgnore, this.getDefaultRealm(configurations));
                    kerberosConfigurations = this.kerberosHelper.processPreconfiguredServiceConfigurations(kerberosConfigurations, configurations, cluster, kerberosDescriptor);
                    Map<String, Set<String>> installedServices = this.calculateInstalledServices(cluster);
                    this.kerberosHelper.applyStackAdvisorUpdates(cluster, installedServices.keySet(), configurations, kerberosConfigurations, propertiesToIgnore, propertiesToRemove, true);
                    this.kerberosHelper.setAuthToLocalRules(cluster, kerberosDescriptor, this.getDefaultRealm(configurations), installedServices, configurations, kerberosConfigurations, true);
                    this.processConfigurationChanges(cluster, stackId, kerberosDescriptor, kerberosConfigurations, propertiesToRemove, configurations);
                } else {
                    this.actionLog.writeStdOut("Skipping: This facility is only available when kerberos-env/preconfigure_services is not \"NONE\"");
                }
            } else {
                this.actionLog.writeStdOut("Skipping: This facility is only available when Kerberos is enabled");
            }
        } else {
            this.actionLog.writeStdOut("Skipping: This facility is only available during an upgrade");
        }
        return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
    }

    private Map<String, Set<String>> calculateInstalledServices(Cluster cluster) {
        HashMap<String, Set<String>> installedServices = new HashMap<String, Set<String>>();
        Map<String, Service> services = cluster.getServices();
        for (Service service : services.values()) {
            installedServices.put(service.getName(), service.getServiceComponents().keySet());
        }
        return installedServices;
    }

    private String getValueFromConfiguration(Map<String, Map<String, String>> configurations, String configType, String propertyName) {
        Map<String, String> kerberosEnv;
        String value = null;
        if (configurations != null && (kerberosEnv = configurations.get(configType)) != null) {
            value = kerberosEnv.get(propertyName);
        }
        return value;
    }

    private String getDefaultRealm(Map<String, Map<String, String>> configurations) {
        return this.getValueFromConfiguration(configurations, "kerberos-env", "realm");
    }

    private PreconfigureServiceType getPreconfigureServiceType(Map<String, Map<String, String>> configurations) {
        String preconfigureServices = this.getValueFromConfiguration(configurations, "kerberos-env", "preconfigure_services");
        PreconfigureServiceType preconfigureServiceType = null;
        if (!StringUtils.isEmpty((String)preconfigureServices)) {
            try {
                preconfigureServiceType = PreconfigureServiceType.valueOf(preconfigureServices.toUpperCase());
            }
            catch (Throwable t) {
                preconfigureServiceType = PreconfigureServiceType.DEFAULT;
            }
        }
        return preconfigureServiceType == null ? PreconfigureServiceType.DEFAULT : preconfigureServiceType;
    }

    private boolean isDowngrade() {
        return Direction.DOWNGRADE.name().equalsIgnoreCase(this.getCommandParameterValue(UPGRADE_DIRECTION_KEY));
    }

    private StackId getTargetStackId(Cluster cluster) throws OBDPException {
        UpgradeContext upgradeContext = this.getUpgradeContext(cluster);
        HashSet<StackId> stackIds = new HashSet<StackId>();
        for (Service service : cluster.getServices().values()) {
            RepositoryVersionEntity targetRepoVersion = upgradeContext.getTargetRepositoryVersion(service.getName());
            StackId targetStackId = targetRepoVersion.getStackId();
            stackIds.add(targetStackId);
        }
        if (1 != stackIds.size()) {
            throw new OBDPException("Services are deployed from multiple stacks and cannot determine a unique one.");
        }
        return (StackId)stackIds.iterator().next();
    }

    private void processServiceComponentHosts(Cluster cluster, KerberosDescriptor kerberosDescriptor, Map<String, Map<String, String>> currentConfigurations, Map<String, Map<String, String>> kerberosConfigurations, Map<String, Set<String>> propertiesToBeIgnored, String realm) throws OBDPException {
        Collection<Host> hosts = cluster.getHosts();
        if (!hosts.isEmpty()) {
            HashMap<String, Object> filterContext = new HashMap<String, Object>();
            filterContext.put("configurations", currentConfigurations);
            filterContext.put("services", cluster.getServices().keySet());
            try {
                Map<String, Set<String>> propertiesToIgnore = null;
                HashMap<String, ResolvedKerberosKeytab> resolvedKeytabs = new HashMap<String, ResolvedKerberosKeytab>();
                for (Host host : hosts) {
                    for (ServiceComponentHost sch : cluster.getServiceComponentHosts(host.getHostName())) {
                        String hostName = sch.getHostName();
                        String serviceName = sch.getServiceName();
                        String componentName = sch.getServiceComponentName();
                        KerberosServiceDescriptor serviceDescriptor = kerberosDescriptor.getService(serviceName);
                        if (!StringUtils.isEmpty((String)hostName)) {
                            Map<String, String> generalProperties = currentConfigurations.get("");
                            if (generalProperties == null) {
                                generalProperties = new HashMap<String, String>();
                                currentConfigurations.put("", generalProperties);
                            }
                            generalProperties.put("host", hostName);
                            generalProperties.put("hostname", hostName);
                        }
                        if (serviceDescriptor == null) continue;
                        List<KerberosIdentityDescriptor> serviceIdentities = serviceDescriptor.getIdentities(true, filterContext);
                        this.kerberosHelper.addIdentities(null, serviceIdentities, null, hostName, host.getHostId(), serviceName, componentName, kerberosConfigurations, currentConfigurations, resolvedKeytabs, realm);
                        propertiesToIgnore = this.gatherPropertiesToIgnore(serviceIdentities, propertiesToIgnore);
                        KerberosComponentDescriptor componentDescriptor = serviceDescriptor.getComponent(componentName);
                        if (componentDescriptor == null) continue;
                        List<KerberosIdentityDescriptor> componentIdentities = componentDescriptor.getIdentities(true, filterContext);
                        this.kerberosHelper.mergeConfigurations(kerberosConfigurations, componentDescriptor.getConfigurations(true), currentConfigurations, null);
                        this.kerberosHelper.addIdentities(null, componentIdentities, null, hostName, host.getHostId(), serviceName, componentName, kerberosConfigurations, currentConfigurations, resolvedKeytabs, realm);
                        propertiesToIgnore = this.gatherPropertiesToIgnore(componentIdentities, propertiesToIgnore);
                    }
                }
                if (this.kerberosHelper.createAmbariIdentities(currentConfigurations.get("kerberos-env"))) {
                    List<KerberosIdentityDescriptor> ambariIdentities = this.kerberosHelper.getAmbariServerIdentities(kerberosDescriptor);
                    for (KerberosIdentityDescriptor identity : ambariIdentities) {
                        String componentName = "obdp-server".equals(identity.getName()) ? "AMBARI_SERVER_SELF" : RootComponent.OBDP_SERVER.name();
                        List<KerberosIdentityDescriptor> componentIdentities = Collections.singletonList(identity);
                        this.kerberosHelper.addIdentities(null, componentIdentities, null, "obdp_server", this.ambariServerHostID(), RootService.OBDP.name(), componentName, kerberosConfigurations, currentConfigurations, resolvedKeytabs, realm);
                        propertiesToIgnore = this.gatherPropertiesToIgnore(componentIdentities, propertiesToIgnore);
                    }
                }
                if (propertiesToBeIgnored != null && propertiesToIgnore != null) {
                    propertiesToBeIgnored.putAll(propertiesToIgnore);
                }
                List<KerberosKeytabPrincipalEntity> keytabList = this.kerberosKeytabPrincipalDAO.findAll();
                resolvedKeytabs.values().forEach(keytab -> this.kerberosHelper.createResolvedKeytab((ResolvedKerberosKeytab)keytab, keytabList));
            }
            catch (IOException e) {
                throw new OBDPException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private Map<String, Set<String>> gatherPropertiesToIgnore(List<KerberosIdentityDescriptor> identities, Map<String, Set<String>> propertiesToIgnore) {
        Map<String, Map<String, String>> identityConfigurations = this.kerberosHelper.getIdentityConfigurations(identities);
        if (!MapUtils.isEmpty(identityConfigurations)) {
            if (propertiesToIgnore == null) {
                propertiesToIgnore = new HashMap<String, Set<String>>();
            }
            for (Map.Entry<String, Map<String, String>> entry : identityConfigurations.entrySet()) {
                String configType = entry.getKey();
                Map<String, String> properties = entry.getValue();
                if (!MapUtils.isEmpty(properties)) continue;
                Set<String> propertyNames = propertiesToIgnore.get(configType);
                if (propertyNames == null) {
                    propertyNames = new HashSet<String>();
                    propertiesToIgnore.put(configType, propertyNames);
                }
                propertyNames.addAll(properties.keySet());
            }
        }
        return propertiesToIgnore;
    }

    private void processConfigurationChanges(Cluster cluster, StackId targetStackId, KerberosDescriptor kerberosDescriptor, Map<String, Map<String, String>> kerberosConfigurations, Map<String, Set<String>> propertiesToBeRemoved, Map<String, Map<String, String>> variableReplaments) throws OBDPException {
        this.actionLog.writeStdOut("Determining configuration changes");
        if (!kerberosConfigurations.isEmpty()) {
            String configType;
            Map<String, Set<String>> authToLocalProperties;
            Map<String, Service> installedServices = cluster.getServices();
            HashMap<String, Set<String>> propertyFilter = new HashMap<String, Set<String>>();
            Map<String, KerberosServiceDescriptor> serviceDescriptors = kerberosDescriptor.getServices();
            if (serviceDescriptors != null) {
                for (KerberosServiceDescriptor kerberosServiceDescriptor : serviceDescriptors.values()) {
                    if (installedServices.containsKey(kerberosServiceDescriptor.getName()) || !kerberosServiceDescriptor.shouldPreconfigure()) continue;
                    this.buildFilter(Collections.singleton(kerberosServiceDescriptor), propertyFilter, variableReplaments);
                }
            }
            if (!MapUtils.isEmpty(authToLocalProperties = this.kerberosHelper.translateConfigurationSpecifications(kerberosDescriptor.getAllAuthToLocalProperties()))) {
                for (Map.Entry<String, Set<String>> entry : authToLocalProperties.entrySet()) {
                    Set<String> set = entry.getValue();
                    if (CollectionUtils.isEmpty(set)) continue;
                    String configurationType = entry.getKey();
                    HashSet<String> propertyNames = (HashSet<String>)propertyFilter.get(configurationType);
                    if (propertyNames == null) {
                        propertyNames = new HashSet<String>();
                        propertyFilter.put(configurationType, propertyNames);
                    }
                    propertyNames.addAll(set);
                }
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry<String, Map<String, String>> entry : kerberosConfigurations.entrySet()) {
                Set<String> propertiesToRemove;
                configType = entry.getKey();
                String service = cluster.getServiceByConfigType(configType);
                Set allowedProperties = (Set)propertyFilter.get(configType);
                if (!installedServices.containsKey(service) || CollectionUtils.isEmpty((Collection)allowedProperties)) continue;
                Map<String, String> propertiesToUpdate = entry.getValue();
                Set<String> set = propertiesToRemove = propertiesToBeRemoved == null ? null : propertiesToBeRemoved.get(configType);
                if (propertiesToUpdate != null) {
                    Iterator<Map.Entry<String, String>> mapIterator = propertiesToUpdate.entrySet().iterator();
                    while (mapIterator.hasNext()) {
                        Map.Entry<String, String> entry2 = mapIterator.next();
                        if (allowedProperties.contains(entry2.getKey())) continue;
                        mapIterator.remove();
                    }
                }
                if (propertiesToRemove != null) {
                    Iterator<String> setIterator = propertiesToRemove.iterator();
                    while (setIterator.hasNext()) {
                        String string = setIterator.next();
                        if (allowedProperties.contains(string)) continue;
                        setIterator.remove();
                    }
                }
                hashSet.add(configType);
                if (MapUtils.isEmpty(propertiesToUpdate) && CollectionUtils.isEmpty(propertiesToRemove)) continue;
                if (!MapUtils.isEmpty(propertiesToUpdate)) {
                    for (Map.Entry entry3 : propertiesToUpdate.entrySet()) {
                        this.actionLog.writeStdOut(String.format("Setting: %s/%s = %s", configType, entry3.getKey(), entry3.getValue()));
                    }
                }
                if (!CollectionUtils.isEmpty(propertiesToRemove)) {
                    for (String string : propertiesToRemove) {
                        this.actionLog.writeStdOut(String.format("Removing: %s/%s", configType, string));
                    }
                }
                this.configHelper.updateConfigType(cluster, targetStackId, this.ambariManagementController, configType, propertiesToUpdate, propertiesToRemove, this.ambariManagementController.getAuthName(), "Preconfiguring for Kerberos during upgrade");
            }
            if (!MapUtils.isEmpty(propertiesToBeRemoved)) {
                for (Map.Entry<String, Set<String>> entry : propertiesToBeRemoved.entrySet()) {
                    Set<String> propertiesToRemove;
                    configType = entry.getKey();
                    if (hashSet.contains(configType) || CollectionUtils.isEmpty(propertiesToRemove = entry.getValue())) continue;
                    for (String property : propertiesToRemove) {
                        this.actionLog.writeStdOut(String.format("Removing: %s/%s", configType, property));
                    }
                    this.configHelper.updateConfigType(cluster, targetStackId, this.ambariManagementController, configType, null, (Collection<String>)entry.getValue(), this.ambariManagementController.getAuthName(), "Preconfiguring for Kerberos during upgrade");
                }
            }
        }
    }

    private void buildFilter(Collection<? extends AbstractKerberosDescriptorContainer> containers, Map<String, Set<String>> propertyFilter, Map<String, Map<String, String>> replacements) throws OBDPException {
        if (containers != null) {
            for (AbstractKerberosDescriptorContainer abstractKerberosDescriptorContainer : containers) {
                Collection<? extends AbstractKerberosDescriptorContainer> childContainers;
                Map<String, KerberosConfigurationDescriptor> configurationDescriptors = abstractKerberosDescriptorContainer.getConfigurations(false);
                if (!MapUtils.isEmpty(configurationDescriptors)) {
                    for (KerberosConfigurationDescriptor configurationDescriptor : configurationDescriptors.values()) {
                        Map<String, String> properties = configurationDescriptor.getProperties();
                        if (MapUtils.isEmpty(properties)) continue;
                        String configType = configurationDescriptor.getType();
                        Set<String> propertyNames = propertyFilter.get(configType);
                        if (propertyNames == null) {
                            propertyNames = new HashSet<String>();
                            propertyFilter.put(configType, propertyNames);
                        }
                        for (String propertyName : properties.keySet()) {
                            propertyNames.add(this.variableReplacementHelper.replaceVariables(propertyName, replacements));
                        }
                    }
                }
                if ((childContainers = abstractKerberosDescriptorContainer.getChildContainers()) == null) continue;
                this.buildFilter(childContainers, propertyFilter, replacements);
            }
        }
    }

    protected Long ambariServerHostID() {
        String ambariServerHostName = StageUtils.getHostName();
        HostEntity ambariServerHostEntity = this.hostDAO.findByName(ambariServerHostName);
        return ambariServerHostEntity == null ? null : ambariServerHostEntity.getHostId();
    }
}

