/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.upgrades;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.serveraction.upgrades.AbstractUpgradeServerAction;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.spi.ClusterInformation;
import id.onyx.obdp.spi.exceptions.UpgradeActionException;
import id.onyx.obdp.spi.upgrade.UpgradeAction;
import id.onyx.obdp.spi.upgrade.UpgradeActionOperations;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginUpgradeServerAction
extends AbstractUpgradeServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(PluginUpgradeServerAction.class);

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        Object standardOutput;
        UpgradeAction upgradeAction;
        String clusterName = this.getExecutionCommand().getClusterName();
        Cluster cluster = this.m_clusters.getCluster(clusterName);
        UpgradeContext upgradeContext = this.getUpgradeContext(cluster);
        UpgradePack upgradePack = upgradeContext.getUpgradePack();
        StackId stackId = upgradePack.getOwnerStackId();
        StackInfo stackInfo = ((OBDPMetaInfo)this.m_metainfoProvider.get()).getStack(stackId);
        URLClassLoader pluginClassLoader = stackInfo.getLibraryClassLoader();
        if (null == pluginClassLoader) {
            return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", "", "There is no plugin classloader defined for stack " + stackId);
        }
        String pluginClassName = this.getActionClassName();
        try {
            upgradeAction = (UpgradeAction)stackInfo.getLibraryInstance(pluginClassName);
        }
        catch (Exception exception) {
            LOG.error("Unable to load the upgrade action {}", (Object)pluginClassName, (Object)exception);
            return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", "", "Unable to load the upgrade class  " + pluginClassName);
        }
        try {
            ClusterInformation clusterInformation = cluster.buildClusterInformation();
            UpgradeActionOperations upgradeActionOperations = upgradeAction.getOperations(clusterInformation, upgradeContext.buildUpgradeInformation());
            this.changeConfigurations(cluster, upgradeActionOperations.getConfigurationChanges(), upgradeContext);
            this.removeConfigurationTypes(cluster, upgradeActionOperations.getConfigurationTypeRemovals());
            standardOutput = "Successfully executed " + pluginClassName;
            if (null != upgradeActionOperations.getStandardOutput()) {
                standardOutput = upgradeActionOperations.getStandardOutput();
            }
        }
        catch (UpgradeActionException exception) {
            LOG.error("Unable to run the upgrade action {}", (Object)pluginClassName, (Object)exception);
            return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", "", exception.getMessage());
        }
        catch (Exception exception) {
            LOG.error("Unable to run the upgrade action {}", (Object)pluginClassName, (Object)exception);
            String standardError = "Unable to run " + pluginClassName;
            return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", "", standardError);
        }
        this.agentConfigsHolder.updateData(cluster.getClusterId(), cluster.getHosts().stream().map(Host::getHostId).collect(Collectors.toList()));
        return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", (String)standardOutput, "");
    }

    private void changeConfigurations(Cluster cluster, List<UpgradeActionOperations.ConfigurationChanges> configurationChanges, UpgradeContext upgradeContext) throws OBDPException {
        if (null == configurationChanges) {
            return;
        }
        for (UpgradeActionOperations.ConfigurationChanges configTypeChanges : configurationChanges) {
            String configType = configTypeChanges.getConfigType();
            Config config = cluster.getDesiredConfigByType(configType);
            if (null == config) {
                if (configTypeChanges.isOnlyRemovals()) continue;
                Direction direction = upgradeContext.getDirection();
                String serviceVersionNote = String.format("%s %s %s", direction.getText(true), direction.getPreposition(), upgradeContext.getRepositoryVersion().getVersion());
                this.m_configHelper.createConfigType(cluster, upgradeContext.getRepositoryVersion().getStackId(), this.m_amc, configType, new HashMap<String, String>(), this.m_amc.getAuthName(), serviceVersionNote);
                config = cluster.getDesiredConfigByType(configType);
                if (null == config) {
                    throw new OBDPException(String.format("Unable to create the % configuration type", configType));
                }
            }
            List propertyChanges = configTypeChanges.getPropertyChanges();
            block5: for (UpgradeActionOperations.PropertyChange propertyChange : propertyChanges) {
                UpgradeActionOperations.ChangeType changeType = propertyChange.getChangeType();
                switch (changeType) {
                    case REMOVE: {
                        config.deleteProperties(Collections.singletonList(propertyChange.getPropertyName()));
                        continue block5;
                    }
                    case SET: {
                        HashMap<String, String> propertyMap = new HashMap<String, String>();
                        propertyMap.put(propertyChange.getPropertyName(), propertyChange.getPropertyValue());
                        config.updateProperties(propertyMap);
                        continue block5;
                    }
                }
                LOG.error("Unknown configuration action type {}", (Object)changeType);
                throw new OBDPException("Unable to update configurations because " + changeType + " is an unknown type");
            }
            config.save();
        }
    }

    private void removeConfigurationTypes(Cluster cluster, Set<String> configurationTypeRemovals) throws OBDPException {
        if (null == configurationTypeRemovals) {
            return;
        }
        for (String configType : configurationTypeRemovals) {
            this.m_configHelper.removeConfigsByType(cluster, configType);
        }
    }

    private String getActionClassName() throws OBDPException {
        String wrappedClassName = this.getCommandParameterValue("WRAPPED_CLASS_NAME");
        if (null == wrappedClassName) {
            throw new OBDPException("The name of the upgrade action class to execute was not found.");
        }
        return wrappedClassName;
    }
}

