/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.upgrades;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.serveraction.kerberos.KDCType;
import id.onyx.obdp.server.serveraction.upgrades.AbstractUpgradeServerAction;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Config;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class KerberosKeytabsAction
extends AbstractUpgradeServerAction {
    private static final String KERBEROS_ENV = "kerberos-env";
    private static final String KDC_TYPE_KEY = "kdc_type";
    @Inject
    private KerberosHelper m_kerberosHelper;

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        String clusterName = this.getExecutionCommand().getClusterName();
        Cluster cluster = this.getClusters().getCluster(clusterName);
        StringBuilder stdout = new StringBuilder();
        stdout.append(String.format("Checking %s is secured by Kerberos... %s", clusterName, this.m_kerberosHelper.isClusterKerberosEnabled(cluster))).append(System.lineSeparator());
        if (!this.m_kerberosHelper.isClusterKerberosEnabled(cluster)) {
            stdout.append(String.format("Cluster %s is not secured by Kerberos.  No action required.", clusterName));
            return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", stdout.toString(), "");
        }
        stdout.append(String.format("Loading %s for cluster %s", KERBEROS_ENV, clusterName)).append(System.lineSeparator());
        Config kerberosEnv = cluster.getDesiredConfigByType(KERBEROS_ENV);
        if (kerberosEnv == null) {
            stdout.append(String.format("Configuration %s was not found.  No action required.", KERBEROS_ENV));
            return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", stdout.toString(), "");
        }
        Map<String, String> kerbProperties = kerberosEnv.getProperties();
        KDCType kdcType = KDCType.NONE;
        if (null != kerbProperties && kerbProperties.containsKey(KDC_TYPE_KEY)) {
            kdcType = KDCType.translate(kerbProperties.get(KDC_TYPE_KEY));
        }
        stdout.append(String.format("Checking KDC type... %s", new Object[]{kdcType})).append(System.lineSeparator());
        if (KDCType.NONE == kdcType) {
            stdout.append(String.format("KDC Type is %s, keytabs are managed manually.  No action required.", new Object[]{kdcType}));
            return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", stdout.toString(), "");
        }
        stdout.append(String.format("Ambari is managing Kerberos keytabs.  Regenerate keytabs after upgrade is complete.", new Object[0]));
        return this.createCommandReport(0, HostRoleStatus.HOLDING, "{}", stdout.toString(), "");
    }
}

