/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.upgrades;

import com.google.common.base.MoreObjects;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.events.StackUpgradeFinishEvent;
import id.onyx.obdp.server.events.publishers.VersionEventPublisher;
import id.onyx.obdp.server.orm.dao.HostComponentStateDAO;
import id.onyx.obdp.server.orm.dao.HostVersionDAO;
import id.onyx.obdp.server.orm.entities.HostComponentStateEntity;
import id.onyx.obdp.server.orm.entities.HostVersionEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.serveraction.upgrades.AbstractUpgradeServerAction;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.RepositoryVersionState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.UpgradeState;
import id.onyx.obdp.server.state.repository.AvailableService;
import id.onyx.obdp.server.state.repository.VersionDefinitionXml;
import id.onyx.obdp.spi.RepositoryType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.text.StrBuilder;

public class FinalizeUpgradeAction
extends AbstractUpgradeServerAction {
    public static final String PREVIOUS_UPGRADE_NOT_COMPLETED_MSG = "It is possible that a previous upgrade was not finalized. For this reason, Ambari will not remove any configs. Please ensure that all database records are correct.";
    @Inject
    private HostVersionDAO hostVersionDAO;
    @Inject
    private HostComponentStateDAO hostComponentStateDAO;
    @Inject
    private OBDPMetaInfo obdpMetaInfo;
    @Inject
    private VersionEventPublisher versionEventPublisher;

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        String clusterName = this.getExecutionCommand().getClusterName();
        Cluster cluster = this.getClusters().getCluster(clusterName);
        UpgradeContext upgradeContext = this.getUpgradeContext(cluster);
        if (upgradeContext.getDirection() == Direction.UPGRADE) {
            return this.finalizeUpgrade(upgradeContext);
        }
        return this.finalizeDowngrade(upgradeContext);
    }

    private CommandReport finalizeUpgrade(UpgradeContext upgradeContext) throws OBDPException, InterruptedException {
        Direction direction = upgradeContext.getDirection();
        RepositoryType repositoryType = upgradeContext.getOrchestrationType();
        StringBuilder outSB = new StringBuilder();
        StringBuilder errSB = new StringBuilder();
        try {
            String message;
            Cluster cluster = upgradeContext.getCluster();
            RepositoryVersionEntity repositoryVersion = upgradeContext.getRepositoryVersion();
            String version = repositoryVersion.getVersion();
            if (upgradeContext.getOrchestrationType() == RepositoryType.STANDARD) {
                message = MessageFormat.format("Finalizing the upgrade to {0} for all cluster services.", version);
            } else {
                Set<String> servicesInUpgrade = upgradeContext.getSupportedServices();
                message = MessageFormat.format("Finalizing the upgrade to {0} for the following services: {1}", version, StringUtils.join(servicesInUpgrade, (char)','));
            }
            outSB.append(message).append(System.lineSeparator());
            Set<InfoTuple> errors = this.validateComponentVersions(upgradeContext);
            if (!errors.isEmpty()) {
                StrBuilder messageBuff = new StrBuilder(String.format("The following %d host component(s) have not been upgraded to version %s. Please install and upgrade the Stack Version on those hosts and try again.\nHost components:", errors.size(), version)).append(System.lineSeparator());
                for (InfoTuple error : errors) {
                    messageBuff.append(String.format("%s on host %s\n", error.componentName, error.hostName));
                }
                throw new OBDPException(messageBuff.toString());
            }
            List<HostVersionEntity> hostVersions = this.hostVersionDAO.findHostVersionByClusterAndRepository(cluster.getClusterId(), repositoryVersion);
            HashSet<HostVersionEntity> hostVersionsAllowed = new HashSet<HostVersionEntity>();
            HashSet<String> hostsWithoutCorrectVersionState = new HashSet<String>();
            block6: for (HostVersionEntity hostVersion : hostVersions) {
                RepositoryVersionState hostVersionState = hostVersion.getState();
                switch (hostVersionState) {
                    case CURRENT: 
                    case NOT_REQUIRED: {
                        hostVersionsAllowed.add(hostVersion);
                        continue block6;
                    }
                }
                hostsWithoutCorrectVersionState.add(hostVersion.getHostName());
            }
            if (hostsWithoutCorrectVersionState.size() > 0) {
                message = String.format("The following %d host(s) have not been upgraded to version %s. Please install and upgrade the Stack Version on those hosts and try again.\nHosts: %s", hostsWithoutCorrectVersionState.size(), version, StringUtils.join(hostsWithoutCorrectVersionState, (String)", "));
                outSB.append(message);
                outSB.append(System.lineSeparator());
                throw new OBDPException(message);
            }
            outSB.append(String.format("Finalizing the upgrade state and repository version for %d host(s).", hostVersionsAllowed.size())).append(System.lineSeparator());
            for (HostVersionEntity hostVersion : hostVersionsAllowed) {
                List<HostComponentStateEntity> hostComponentStates = this.hostComponentStateDAO.findByHost(hostVersion.getHostName());
                for (HostComponentStateEntity hostComponentStateEntity : hostComponentStates) {
                    hostComponentStateEntity.setUpgradeState(UpgradeState.NONE);
                    this.hostComponentStateDAO.merge(hostComponentStateEntity);
                }
            }
            this.finalizeHostVersionsNotDesired(cluster, upgradeContext);
            if (upgradeContext.getOrchestrationType() == RepositoryType.STANDARD) {
                outSB.append(String.format("Finalizing the version for cluster %s.\n", cluster.getClusterName()));
                cluster.setCurrentStackVersion(cluster.getDesiredStackVersion());
            }
            if (repositoryType.isRevertable() && direction == Direction.UPGRADE) {
                UpgradeEntity upgradeEntity = cluster.getUpgradeInProgress();
                upgradeEntity.setRevertAllowed(true);
                upgradeEntity = this.m_upgradeDAO.merge(upgradeEntity);
            }
            cluster.setUpgradeEntity(null);
            this.versionEventPublisher.publish(new StackUpgradeFinishEvent(cluster));
            message = String.format("The upgrade to %s has completed.", version);
            outSB.append(message).append(System.lineSeparator());
            return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", outSB.toString(), errSB.toString());
        }
        catch (Exception e) {
            errSB.append(e.getMessage());
            return this.createCommandReport(-1, HostRoleStatus.FAILED, "{}", outSB.toString(), errSB.toString());
        }
    }

    private CommandReport finalizeDowngrade(UpgradeContext upgradeContext) throws OBDPException, InterruptedException {
        StringBuilder outSB = new StringBuilder();
        StringBuilder errSB = new StringBuilder();
        try {
            Cluster cluster = upgradeContext.getCluster();
            RepositoryVersionEntity downgradeFromRepositoryVersion = upgradeContext.getRepositoryVersion();
            String downgradeFromVersion = downgradeFromRepositoryVersion.getVersion();
            Set<String> servicesInUpgrade = upgradeContext.getSupportedServices();
            String message = upgradeContext.getOrchestrationType() == RepositoryType.STANDARD ? MessageFormat.format("Finalizing the downgrade from {0} for all cluster services.", downgradeFromVersion) : MessageFormat.format("Finalizing the downgrade from {0} for the following services: {1}", downgradeFromVersion, StringUtils.join(servicesInUpgrade, (char)','));
            outSB.append(message).append(System.lineSeparator());
            Set<InfoTuple> errors = this.validateComponentVersions(upgradeContext);
            if (!errors.isEmpty()) {
                StrBuilder messageBuff = new StrBuilder(String.format("The following %d host component(s) have not been downgraded to their desired versions:", errors.size())).append(System.lineSeparator());
                for (InfoTuple error : errors) {
                    messageBuff.append(String.format("%s: %s (current = %s, desired = %s)", error.hostName, error.componentName, error.currentVersion, error.targetVersion));
                    messageBuff.append(System.lineSeparator());
                }
                throw new OBDPException(messageBuff.toString());
            }
            this.finalizeHostVersionsNotDesired(cluster, upgradeContext);
            Map<String, RepositoryVersionEntity> targetVersionsByService = upgradeContext.getTargetVersions();
            HashSet<RepositoryVersionEntity> targetRepositoryVersions = new HashSet<RepositoryVersionEntity>();
            for (String service : targetVersionsByService.keySet()) {
                targetRepositoryVersions.add(targetVersionsByService.get(service));
            }
            for (RepositoryVersionEntity targetRepositoryVersion : targetRepositoryVersions) {
                List<HostVersionEntity> hostVersions = this.hostVersionDAO.findHostVersionByClusterAndRepository(cluster.getClusterId(), targetRepositoryVersion);
                outSB.append(String.format("Finalizing %d host(s) back to %s", hostVersions.size(), targetRepositoryVersion.getVersion())).append(System.lineSeparator());
                for (HostVersionEntity hostVersion : hostVersions) {
                    if (hostVersion.getState() != RepositoryVersionState.CURRENT) {
                        hostVersion.setState(RepositoryVersionState.CURRENT);
                        this.hostVersionDAO.merge(hostVersion);
                    }
                    List<HostComponentStateEntity> hostComponentStates = this.hostComponentStateDAO.findByHost(hostVersion.getHostName());
                    for (HostComponentStateEntity hostComponentState : hostComponentStates) {
                        hostComponentState.setUpgradeState(UpgradeState.NONE);
                        this.hostComponentStateDAO.merge(hostComponentState);
                    }
                }
            }
            for (String serviceName : servicesInUpgrade) {
                StackId targetStackId;
                RepositoryVersionEntity sourceRepositoryVersion = upgradeContext.getSourceRepositoryVersion(serviceName);
                RepositoryVersionEntity targetRepositoryVersion = upgradeContext.getTargetRepositoryVersion(serviceName);
                StackId sourceStackId = sourceRepositoryVersion.getStackId();
                if (sourceStackId.equals(targetStackId = targetRepositoryVersion.getStackId())) continue;
                outSB.append(String.format("Removing %s configurations for %s", sourceStackId, serviceName)).append(System.lineSeparator());
                cluster.removeConfigurations(sourceStackId, serviceName);
            }
            this.versionEventPublisher.publish(new StackUpgradeFinishEvent(cluster));
            cluster.setUpgradeEntity(null);
            message = String.format("The downgrade from %s has completed.", downgradeFromVersion);
            outSB.append(message).append(System.lineSeparator());
            return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", outSB.toString(), errSB.toString());
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            errSB.append(sw);
            return this.createCommandReport(-1, HostRoleStatus.FAILED, "{}", outSB.toString(), errSB.toString());
        }
    }

    protected Set<InfoTuple> validateComponentVersions(UpgradeContext upgradeContext) throws OBDPException {
        TreeSet<InfoTuple> errors = new TreeSet<InfoTuple>();
        Cluster cluster = upgradeContext.getCluster();
        Set<String> servicesParticipating = upgradeContext.getSupportedServices();
        for (String serviceName : servicesParticipating) {
            Service service = cluster.getService(serviceName);
            RepositoryVersionEntity repositoryVersionEntity = upgradeContext.getTargetRepositoryVersion(serviceName);
            StackId targetStackId = repositoryVersionEntity.getStackId();
            String targetVersion = repositoryVersionEntity.getVersion();
            for (ServiceComponent serviceComponent : service.getServiceComponents().values()) {
                ComponentInfo componentInfo = this.obdpMetaInfo.getComponent(targetStackId.getStackName(), targetStackId.getStackVersion(), service.getName(), serviceComponent.getName());
                if (!componentInfo.isVersionAdvertised()) continue;
                for (ServiceComponentHost serviceComponentHost : serviceComponent.getServiceComponentHosts().values()) {
                    if (StringUtils.equals((String)targetVersion, (String)serviceComponentHost.getVersion())) continue;
                    errors.add(new InfoTuple(service.getName(), serviceComponent.getName(), serviceComponentHost.getHostName(), serviceComponentHost.getVersion(), targetVersion));
                }
            }
        }
        return errors;
    }

    private void finalizeHostVersionsNotDesired(Cluster cluster, UpgradeContext upgradeContext) throws OBDPException {
        HashSet<RepositoryVersionEntity> desiredRepoVersions = new HashSet<RepositoryVersionEntity>();
        Set<String> serviceNames = cluster.getServices().keySet();
        for (String string : serviceNames) {
            Service service = cluster.getService(string);
            desiredRepoVersions.add(service.getDesiredRepositoryVersion());
        }
        List<HostVersionEntity> currentHostVersions = this.hostVersionDAO.findByClusterAndState(cluster.getClusterName(), RepositoryVersionState.CURRENT);
        for (HostVersionEntity hostVersionEntity : currentHostVersions) {
            RepositoryVersionEntity hostRepoVersion = hostVersionEntity.getRepositoryVersion();
            if (desiredRepoVersions.contains(hostRepoVersion)) continue;
            hostVersionEntity.setState(RepositoryVersionState.INSTALLED);
            hostVersionEntity = this.hostVersionDAO.merge(hostVersionEntity);
        }
        if (upgradeContext.isPatchRevert()) {
            VersionDefinitionXml vdfXml;
            RepositoryVersionEntity repositoryVersionEntity = upgradeContext.getRepositoryVersion();
            try {
                vdfXml = repositoryVersionEntity.getRepositoryXml();
            }
            catch (Exception exception) {
                throw new OBDPException("The VDF's XML could not be deserialized", (Throwable)exception);
            }
            StackInfo stack = this.obdpMetaInfo.getStack(repositoryVersionEntity.getStackId());
            Collection<AvailableService> availableServices = vdfXml.getAvailableServices(stack);
            Set<String> participatingServices = upgradeContext.getSupportedServices();
            Set<String> clusterServices = cluster.getServices().keySet();
            boolean resetRepoStateToOutOfSync = false;
            for (AvailableService availableService : availableServices) {
                if (!clusterServices.contains(availableService.getName()) || participatingServices.contains(availableService.getName())) continue;
                resetRepoStateToOutOfSync = true;
                break;
            }
            if (resetRepoStateToOutOfSync) {
                List<HostVersionEntity> hostVersions = this.hostVersionDAO.findHostVersionByClusterAndRepository(cluster.getClusterId(), repositoryVersionEntity);
                for (HostVersionEntity hostVersion : hostVersions) {
                    hostVersion.setState(RepositoryVersionState.OUT_OF_SYNC);
                    hostVersion = this.hostVersionDAO.merge(hostVersion);
                }
            }
        }
    }

    protected static class InfoTuple
    implements Comparable<InfoTuple> {
        protected final String serviceName;
        protected final String componentName;
        protected final String hostName;
        protected final String currentVersion;
        protected final String targetVersion;

        protected InfoTuple(String service, String component, String host, String version, String desiredVersion) {
            this.serviceName = service;
            this.componentName = component;
            this.hostName = host;
            this.currentVersion = version;
            this.targetVersion = desiredVersion;
        }

        @Override
        public int compareTo(InfoTuple that) {
            int compare = this.hostName.compareTo(that.hostName);
            if (compare != 0) {
                return compare;
            }
            compare = this.serviceName.compareTo(that.serviceName);
            if (compare != 0) {
                return compare;
            }
            compare = this.componentName.compareTo(that.componentName);
            if (compare != 0) {
                return compare;
            }
            return compare;
        }

        public int hashCode() {
            return Objects.hash(this.hostName, this.serviceName, this.componentName, this.currentVersion, this.targetVersion);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            InfoTuple that = (InfoTuple)object;
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            equalsBuilder.append((Object)this.hostName, (Object)that.hostName);
            equalsBuilder.append((Object)this.serviceName, (Object)that.serviceName);
            equalsBuilder.append((Object)this.componentName, (Object)that.componentName);
            equalsBuilder.append((Object)this.currentVersion, (Object)that.currentVersion);
            equalsBuilder.append((Object)this.targetVersion, (Object)that.targetVersion);
            return equalsBuilder.isEquals();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("host", (Object)this.hostName).add("component", (Object)this.componentName).add("current", (Object)this.currentVersion).add("target", (Object)this.targetVersion).toString();
        }
    }
}

