/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.upgrades;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.controller.internal.DeleteHostComponentStatusMetaData;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.orm.entities.UpgradeHistoryEntity;
import id.onyx.obdp.server.serveraction.upgrades.AbstractUpgradeServerAction;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentSupport;
import id.onyx.obdp.server.topology.STOMPComponentsDeleteHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DeleteUnsupportedServicesAndComponents
extends AbstractUpgradeServerAction {
    @Inject
    private ServiceComponentSupport serviceComponentSupport;
    @Inject
    private STOMPComponentsDeleteHandler STOMPComponentsDeleteHandler;

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        Cluster cluster = this.getClusters().getCluster(this.getExecutionCommand().getClusterName());
        if (cluster.getUpgradeInProgress().isDowngradeAllowed().booleanValue()) {
            throw new OBDPException(this.getClass() + " should not be used in upgrade packs with downgrade support");
        }
        UpgradeContext upgradeContext = this.getUpgradeContext(cluster);
        Set<String> removedComponents = this.deleteUnsupportedComponents(cluster, upgradeContext.getRepositoryVersion());
        Set<String> removedServices = this.deleteUnsupportedServices(cluster, upgradeContext.getRepositoryVersion());
        return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", "Removed services: " + StringUtils.join((Collection)CollectionUtils.union(removedComponents, removedServices), (String)", "), "");
    }

    private Set<String> deleteUnsupportedServices(Cluster cluster, RepositoryVersionEntity repoVersion) throws OBDPException {
        Set<String> servicesToBeRemoved = this.serviceComponentSupport.unsupportedServices(cluster, repoVersion.getStackName(), repoVersion.getStackVersion());
        for (String serviceName : servicesToBeRemoved) {
            DeleteHostComponentStatusMetaData deleteMetaData = new DeleteHostComponentStatusMetaData();
            cluster.deleteService(serviceName, deleteMetaData);
            this.STOMPComponentsDeleteHandler.processDeleteByMetaDataException(deleteMetaData);
            this.STOMPComponentsDeleteHandler.processDeleteByMetaData(deleteMetaData);
            this.deleteUpgradeHistory(cluster, history -> serviceName.equals(history.getServiceName()));
        }
        return servicesToBeRemoved;
    }

    private Set<String> deleteUnsupportedComponents(Cluster cluster, RepositoryVersionEntity repoVersion) throws OBDPException {
        HashSet<String> deletedComponents = new HashSet<String>();
        for (ServiceComponent component : this.serviceComponentSupport.unsupportedComponents(cluster, repoVersion.getStackName(), repoVersion.getStackVersion())) {
            DeleteHostComponentStatusMetaData deleteMetaData = new DeleteHostComponentStatusMetaData();
            cluster.getService(component.getServiceName()).deleteServiceComponent(component.getName(), deleteMetaData);
            this.STOMPComponentsDeleteHandler.processDeleteByMetaDataException(deleteMetaData);
            this.STOMPComponentsDeleteHandler.processDeleteByMetaData(deleteMetaData);
            this.deleteUpgradeHistory(cluster, history -> component.getName().equals(history.getComponentName()));
            deletedComponents.add(component.getName());
        }
        return deletedComponents;
    }

    private void deleteUpgradeHistory(Cluster cluster, Predicate<UpgradeHistoryEntity> predicate) {
        UpgradeEntity upgradeInProgress = cluster.getUpgradeInProgress();
        List<UpgradeHistoryEntity> removed = upgradeInProgress.getHistory().stream().filter(each -> each != null && predicate.test((UpgradeHistoryEntity)each)).collect(Collectors.toList());
        upgradeInProgress.removeHistories(removed);
        this.m_upgradeDAO.merge(upgradeInProgress);
    }
}

