/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.upgrades;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.serveraction.upgrades.ConfigureAction;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.StackId;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateAndConfigureAction
extends ConfigureAction {
    private static final Logger LOG = LoggerFactory.getLogger(CreateAndConfigureAction.class);
    @Inject
    private Clusters m_clusters;
    @Inject
    private OBDPManagementController m_controller;
    @Inject
    private ConfigHelper m_configHelper;

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        StackId targetStackId;
        LOG.info("Create and Configure...");
        Map<String, String> commandParameters = this.getCommandParameters();
        if (null == commandParameters || commandParameters.isEmpty()) {
            return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", "", "Unable to change configuration values without command parameters");
        }
        String clusterName = commandParameters.get("clusterName");
        Cluster cluster = this.m_clusters.getCluster(clusterName);
        UpgradeContext upgradeContext = this.getUpgradeContext(cluster);
        Direction direction = upgradeContext.getDirection();
        if (direction == Direction.DOWNGRADE) {
            return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", "", "Skip changing configuration values for downgrade");
        }
        String configType = commandParameters.get("configure-task-config-type");
        String serviceName = cluster.getServiceByConfigType(configType);
        if (StringUtils.isBlank((String)serviceName)) {
            serviceName = commandParameters.get("configure-task-associated-service");
        }
        RepositoryVersionEntity sourceRepoVersion = upgradeContext.getSourceRepositoryVersion(serviceName);
        RepositoryVersionEntity targetRepoVersion = upgradeContext.getTargetRepositoryVersion(serviceName);
        StackId sourceStackId = sourceRepoVersion.getStackId();
        if (!sourceStackId.equals(targetStackId = targetRepoVersion.getStackId())) {
            return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", "", "Unable to change configuration values across stacks. Use regular config task type instead.");
        }
        Map<String, DesiredConfig> desiredConfigs = cluster.getDesiredConfigs();
        DesiredConfig desiredConfig = desiredConfigs.get(configType);
        if (desiredConfig == null) {
            LOG.info(String.format("Could not find desired config type with name %s. Create it with default values.", configType));
            Map<String, Map<String, String>> newServiceDefaultConfigsByType = this.m_configHelper.getDefaultProperties(targetStackId, serviceName);
            if (!newServiceDefaultConfigsByType.containsKey(configType)) {
                String error = String.format("%s in %s does not contain configuration type %s", serviceName, targetStackId.getStackId(), configType);
                LOG.error(error);
                return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", "", error);
            }
            Map<String, String> defaultConfigsForType = newServiceDefaultConfigsByType.get(configType);
            Iterator<Map.Entry<String, String>> iter = defaultConfigsForType.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                if (entry.getValue() != null) continue;
                iter.remove();
            }
            String serviceVersionNote = String.format("%s %s %s", direction.getText(true), direction.getPreposition(), upgradeContext.getRepositoryVersion().getVersion());
            this.m_configHelper.createConfigType(cluster, targetStackId, this.m_controller, configType, defaultConfigsForType, this.m_controller.getAuthName(), serviceVersionNote);
        }
        return super.execute(requestSharedDataContext);
    }
}

