/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.upgrades;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Provider;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.agent.stomp.AgentConfigsHolder;
import id.onyx.obdp.server.agent.stomp.MetadataHolder;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPManagementControllerImpl;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.serveraction.upgrades.AbstractUpgradeServerAction;
import id.onyx.obdp.server.stack.upgrade.ConfigUpgradeChangeDefinition;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.stack.upgrade.PropertyKeyState;
import id.onyx.obdp.server.stack.upgrade.TransferOperation;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.ConfigMergeHelper;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.StackId;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigureAction
extends AbstractUpgradeServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigureAction.class);
    private static final String ALL_SYMBOL = "*";
    @Inject
    private OBDPManagementController m_controller;
    @Inject
    private ConfigHelper m_configHelper;
    @Inject
    private Configuration m_configuration;
    @Inject
    private Provider<OBDPMetaInfo> m_ambariMetaInfo;
    @Inject
    private ConfigMergeHelper m_mergeHelper;
    @Inject
    private Gson m_gson;
    @Inject
    private Provider<OBDPManagementControllerImpl> m_ambariManagementController;
    @Inject
    private Provider<MetadataHolder> m_metadataHolder;
    @Inject
    private Provider<AgentConfigsHolder> m_agentConfigsHolder;

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        Map<String, String> commandParameters = this.getCommandParameters();
        if (null == commandParameters || commandParameters.isEmpty()) {
            return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", "", "Unable to change configuration values without command parameters");
        }
        String clusterName = commandParameters.get("clusterName");
        Cluster cluster = this.getClusters().getCluster(clusterName);
        UpgradeContext upgradeContext = this.getUpgradeContext(cluster);
        String configType = commandParameters.get("configure-task-config-type");
        String serviceName = cluster.getServiceByConfigType(configType);
        if (StringUtils.isBlank((String)serviceName)) {
            serviceName = commandParameters.get("configure-task-associated-service");
        }
        RepositoryVersionEntity sourceRepoVersion = upgradeContext.getSourceRepositoryVersion(serviceName);
        RepositoryVersionEntity targetRepoVersion = upgradeContext.getTargetRepositoryVersion(serviceName);
        StackId sourceStackId = sourceRepoVersion.getStackId();
        StackId targetStackId = targetRepoVersion.getStackId();
        List<ConfigUpgradeChangeDefinition.ConfigurationKeyValue> keyValuePairs = Collections.emptyList();
        String keyValuePairJson = commandParameters.get("configure-task-key-value-pairs");
        if (null != keyValuePairJson) {
            keyValuePairs = (List<ConfigUpgradeChangeDefinition.ConfigurationKeyValue>)this.m_gson.fromJson(keyValuePairJson, new TypeToken<List<ConfigUpgradeChangeDefinition.ConfigurationKeyValue>>(){}.getType());
            keyValuePairs = this.getAllowedSets(cluster, configType, keyValuePairs);
        }
        List<ConfigUpgradeChangeDefinition.Transfer> transfers = Collections.emptyList();
        String transferJson = commandParameters.get("configure-task-transfers");
        if (null != transferJson) {
            transfers = (List<ConfigUpgradeChangeDefinition.Transfer>)this.m_gson.fromJson(transferJson, new TypeToken<List<ConfigUpgradeChangeDefinition.Transfer>>(){}.getType());
            transfers = this.getAllowedTransfers(cluster, configType, transfers);
        }
        List<ConfigUpgradeChangeDefinition.Replace> replacements = Collections.emptyList();
        String replaceJson = commandParameters.get("configure-task-replacements");
        if (null != replaceJson) {
            replacements = (List<ConfigUpgradeChangeDefinition.Replace>)this.m_gson.fromJson(replaceJson, new TypeToken<List<ConfigUpgradeChangeDefinition.Replace>>(){}.getType());
            replacements = this.getAllowedReplacements(cluster, configType, replacements);
        }
        List<ConfigUpgradeChangeDefinition.Insert> insertions = Collections.emptyList();
        String insertJson = commandParameters.get("configure-task-insertions");
        if (null != insertJson) {
            insertions = (List<ConfigUpgradeChangeDefinition.Insert>)this.m_gson.fromJson(insertJson, new TypeToken<List<ConfigUpgradeChangeDefinition.Insert>>(){}.getType());
            insertions = this.getAllowedInsertions(cluster, configType, insertions);
        }
        if (keyValuePairs.isEmpty() && transfers.isEmpty() && replacements.isEmpty() && insertions.isEmpty()) {
            String message = "cluster={0}, type={1}, transfers={2}, replacements={3}, insertions={4}, configurations={5}";
            message = MessageFormat.format(message, clusterName, configType, transfers, replacements, insertions, keyValuePairs);
            StringBuilder buffer = new StringBuilder("Skipping this configuration task since none of the conditions were met and there are no transfers, replacements, or insertions.").append("\n");
            buffer.append(message);
            return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", buffer.toString(), "");
        }
        if (null == clusterName || null == configType || keyValuePairs.isEmpty() && transfers.isEmpty() && replacements.isEmpty() && insertions.isEmpty()) {
            String message = "cluster={0}, type={1}, transfers={2}, replacements={3}, insertions={4}, configurations={5}";
            message = MessageFormat.format(message, clusterName, configType, transfers, replacements, insertions, keyValuePairs);
            return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", "", message);
        }
        Map<String, DesiredConfig> desiredConfigs = cluster.getDesiredConfigs();
        DesiredConfig desiredConfig = desiredConfigs.get(configType);
        if (desiredConfig == null) {
            throw new OBDPException("Could not find desired config type with name " + configType);
        }
        Config config = cluster.getConfig(configType, desiredConfig.getTag());
        if (config == null) {
            throw new OBDPException("Could not find config type with name " + configType);
        }
        StackId configStack = config.getStackId();
        Map<String, String> base = config.getProperties();
        HashMap<String, String> newValues = new HashMap<String, String>(base);
        boolean changedValues = false;
        StringBuilder outputBuffer = new StringBuilder(250);
        for (ConfigUpgradeChangeDefinition.Transfer transfer : transfers) {
            switch (transfer.operation) {
                case COPY: {
                    Object valueToCopy = null;
                    if (null == transfer.fromType) {
                        valueToCopy = base.get(transfer.fromKey);
                    } else {
                        Map<String, String> map;
                        Config other = cluster.getDesiredConfigByType(transfer.fromType);
                        if (null != other && (map = other.getProperties()).containsKey(transfer.fromKey)) {
                            valueToCopy = map.get(transfer.fromKey);
                        }
                    }
                    if (StringUtils.isBlank((String)valueToCopy) && !StringUtils.isBlank((String)transfer.defaultValue)) {
                        valueToCopy = transfer.defaultValue;
                    }
                    if (!StringUtils.isNotBlank((String)valueToCopy)) break;
                    if (transfer.coerceTo != null) {
                        switch (transfer.coerceTo) {
                            case YAML_ARRAY: {
                                String[] splitValues = StringUtils.split((String)valueToCopy, (char)',');
                                ArrayList<CallSite> arrayList = new ArrayList<CallSite>(splitValues.length);
                                for (String splitValue : splitValues) {
                                    arrayList.add((CallSite)((Object)("'" + StringUtils.trim((String)splitValue) + "'")));
                                }
                                valueToCopy = "[" + StringUtils.join(arrayList, (char)',') + "]";
                                break;
                            }
                        }
                    }
                    changedValues = true;
                    newValues.put(transfer.toKey, (String)valueToCopy);
                    this.updateBufferWithMessage(outputBuffer, MessageFormat.format("Created {0}/{1} = \"{2}\"", configType, transfer.toKey, ConfigureAction.mask(transfer, (String)valueToCopy)));
                    break;
                }
                case MOVE: {
                    if (newValues.containsKey(transfer.fromKey)) {
                        newValues.put(transfer.toKey, (String)newValues.remove(transfer.fromKey));
                        changedValues = true;
                        this.updateBufferWithMessage(outputBuffer, MessageFormat.format("Renamed {0}/{1} to {2}/{3}", configType, transfer.fromKey, configType, transfer.toKey));
                        break;
                    }
                    if (!StringUtils.isNotBlank((String)transfer.defaultValue)) break;
                    newValues.put(transfer.toKey, transfer.defaultValue);
                    changedValues = true;
                    this.updateBufferWithMessage(outputBuffer, MessageFormat.format("Created {0}/{1} with default value \"{2}\"", configType, transfer.toKey, ConfigureAction.mask(transfer, transfer.defaultValue)));
                    break;
                }
                case DELETE: {
                    if (ALL_SYMBOL.equals(transfer.deleteKey)) {
                        newValues.clear();
                        this.updateBufferWithMessage(outputBuffer, MessageFormat.format("Deleted all keys from {0}", configType));
                        for (String string : transfer.keepKeys) {
                            if (!base.containsKey(string) || base.get(string) == null) continue;
                            newValues.put(string, base.get(string));
                            this.updateBufferWithMessage(outputBuffer, MessageFormat.format("Preserved {0}/{1} after delete", configType, string));
                        }
                        if (transfer.preserveEdits) {
                            List<String> edited = this.findValuesToPreserve(clusterName, config);
                            for (String changed : edited) {
                                newValues.put(changed, base.get(changed));
                                this.updateBufferWithMessage(outputBuffer, MessageFormat.format("Preserved {0}/{1} after delete", configType, changed));
                            }
                        }
                        changedValues = true;
                        break;
                    }
                    newValues.remove(transfer.deleteKey);
                    changedValues = true;
                    this.updateBufferWithMessage(outputBuffer, MessageFormat.format("Deleted {0}/{1}", configType, transfer.deleteKey));
                }
            }
        }
        if (!keyValuePairs.isEmpty()) {
            for (ConfigUpgradeChangeDefinition.ConfigurationKeyValue keyValuePair : keyValuePairs) {
                String key = keyValuePair.key;
                String value = keyValuePair.value;
                if (null == key) continue;
                String string = base.get(key);
                if (StringUtils.equals((String)value, (String)string) && sourceStackId.equals(targetStackId) && !changedValues) {
                    this.updateBufferWithMessage(outputBuffer, MessageFormat.format("{0}/{1} for cluster {2} would not change, skipping setting", configType, key, clusterName));
                    continue;
                }
                newValues.put(key, value);
                String message = StringUtils.isEmpty((String)value) ? MessageFormat.format("{0}/{1} changed to an empty value", configType, key) : MessageFormat.format("{0}/{1} changed to \"{2}\"", configType, key, ConfigureAction.mask(keyValuePair, value));
                this.updateBufferWithMessage(outputBuffer, message);
            }
        }
        for (ConfigUpgradeChangeDefinition.Replace replacement : replacements) {
            String toReplace = (String)newValues.get(replacement.key);
            if (StringUtils.isNotBlank((String)toReplace)) {
                if (!toReplace.contains(replacement.find)) {
                    this.updateBufferWithMessage(outputBuffer, MessageFormat.format("String \"{0}\" was not found in {1}/{2}", replacement.find, configType, replacement.key));
                    continue;
                }
                String replaced = StringUtils.replace((String)toReplace, (String)replacement.find, (String)replacement.replaceWith);
                newValues.put(replacement.key, replaced);
                if (StringUtils.isEmpty((String)replacement.replaceWith)) {
                    this.updateBufferWithMessage(outputBuffer, MessageFormat.format("Removed \"{0}\" from {1}/{2}", replacement.find, configType, replacement.key));
                    continue;
                }
                this.updateBufferWithMessage(outputBuffer, MessageFormat.format("Replaced {0}/{1} containing \"{2}\" with \"{3}\"", configType, replacement.key, replacement.find, replacement.replaceWith));
                continue;
            }
            this.updateBufferWithMessage(outputBuffer, MessageFormat.format("Skipping replacement for {0}/{1} because it does not exist or is empty.", configType, replacement.key));
        }
        for (ConfigUpgradeChangeDefinition.Insert insert : insertions) {
            Object valueToInsertInto = (String)newValues.get(insert.key);
            if (StringUtils.isNotBlank((String)valueToInsertInto)) {
                if (StringUtils.contains((String)valueToInsertInto, (String)insert.value)) {
                    this.updateBufferWithMessage(outputBuffer, MessageFormat.format("Skipping insertion for {0}/{1} because it already contains {2}", configType, insert.key, insert.value));
                    continue;
                }
                Object valueToInsert = insert.value;
                if (insert.newlineBefore) {
                    valueToInsert = System.lineSeparator() + (String)valueToInsert;
                }
                if (insert.newlineAfter) {
                    valueToInsert = (String)valueToInsert + System.lineSeparator();
                }
                switch (insert.insertType) {
                    case APPEND: {
                        valueToInsertInto = (String)valueToInsertInto + (String)valueToInsert;
                        break;
                    }
                    case PREPEND: {
                        valueToInsertInto = (String)valueToInsert + (String)valueToInsertInto;
                        break;
                    }
                    default: {
                        LOG.error("Unable to insert {0}/{1} with unknown insertion type of {2}", new Object[]{configType, insert.key, insert.insertType});
                    }
                }
                newValues.put(insert.key, (String)valueToInsertInto);
                this.updateBufferWithMessage(outputBuffer, MessageFormat.format("Updated {0}/{1} by inserting \"{2}\"", configType, insert.key, insert.value));
                continue;
            }
            this.updateBufferWithMessage(outputBuffer, MessageFormat.format("Skipping insertion for {0}/{1} because it does not exist or is empty.", configType, insert.key));
        }
        if (!targetStackId.equals(sourceStackId) && targetStackId.equals(configStack)) {
            config.setProperties(newValues);
            config.save();
            ((MetadataHolder)this.m_metadataHolder.get()).updateData(((OBDPManagementControllerImpl)this.m_ambariManagementController.get()).getClusterMetadataOnConfigsUpdate(cluster));
            ((AgentConfigsHolder)this.m_agentConfigsHolder.get()).updateData(cluster.getClusterId(), null);
            return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", outputBuffer.toString(), "");
        }
        Direction direction = upgradeContext.getDirection();
        String serviceVersionNote = String.format("%s %s %s", direction.getText(true), direction.getPreposition(), upgradeContext.getRepositoryVersion().getVersion());
        String auditName = this.getExecutionCommand().getRoleParams().get("ACTION_USER_NAME");
        if (auditName == null) {
            auditName = this.m_configuration.getAnonymousAuditName();
        }
        this.m_configHelper.createConfigType(cluster, targetStackId, this.m_controller, configType, newValues, auditName, serviceVersionNote);
        return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", outputBuffer.toString(), "");
    }

    private List<String> findValuesToPreserve(String clusterName, Config config) throws OBDPException {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, Map<String, ConfigMergeHelper.ThreeWayValue>> conflicts = this.m_mergeHelper.getConflicts(clusterName, config.getStackId());
        Map<String, ConfigMergeHelper.ThreeWayValue> conflictMap = conflicts.get(config.getType());
        if (null != conflictMap && !conflictMap.isEmpty()) {
            for (Map.Entry<String, ConfigMergeHelper.ThreeWayValue> entry : conflictMap.entrySet()) {
                ConfigMergeHelper.ThreeWayValue twv = entry.getValue();
                if (null == twv.oldStackValue) {
                    result.add(entry.getKey());
                    continue;
                }
                if (null == twv.savedValue || twv.oldStackValue.equals(twv.savedValue)) continue;
                result.add(entry.getKey());
            }
        }
        String configType = config.getType();
        Cluster cluster = this.getClusters().getCluster(clusterName);
        StackId oldStack = cluster.getCurrentStackVersion();
        HashSet<String> stackPropertiesForType = new HashSet<String>(50);
        for (String string : cluster.getServices().keySet()) {
            Set<PropertyInfo> serviceProperties = ((OBDPMetaInfo)this.m_ambariMetaInfo.get()).getServiceProperties(oldStack.getStackName(), oldStack.getStackVersion(), string);
            for (PropertyInfo property : serviceProperties) {
                String type = ConfigHelper.fileNameToConfigType(property.getFilename());
                if (!type.equals(configType)) continue;
                stackPropertiesForType.add(property.getName());
            }
        }
        Set<PropertyInfo> stackProperties = ((OBDPMetaInfo)this.m_ambariMetaInfo.get()).getStackProperties(oldStack.getStackName(), oldStack.getStackVersion());
        for (PropertyInfo property : stackProperties) {
            String type = ConfigHelper.fileNameToConfigType(property.getFilename());
            if (!type.equals(configType)) continue;
            stackPropertiesForType.add(property.getName());
        }
        Map<String, String> map = config.getProperties();
        Set<String> baseKeys = map.keySet();
        for (String baseKey : baseKeys) {
            if (stackPropertiesForType.contains(baseKey)) continue;
            result.add(baseKey);
        }
        return result;
    }

    private static String mask(ConfigUpgradeChangeDefinition.Masked mask, String value) {
        if (mask.mask) {
            return StringUtils.repeat((String)ALL_SYMBOL, (int)value.length());
        }
        return value;
    }

    private List<ConfigUpgradeChangeDefinition.Replace> getAllowedReplacements(Cluster cluster, String configType, List<ConfigUpgradeChangeDefinition.Replace> replacements) {
        ArrayList<ConfigUpgradeChangeDefinition.Replace> allowedReplacements = new ArrayList<ConfigUpgradeChangeDefinition.Replace>();
        for (ConfigUpgradeChangeDefinition.Replace replacement : replacements) {
            if (!this.isOperationAllowed(cluster, configType, replacement.key, replacement)) continue;
            allowedReplacements.add(replacement);
        }
        return allowedReplacements;
    }

    private List<ConfigUpgradeChangeDefinition.ConfigurationKeyValue> getAllowedSets(Cluster cluster, String configType, List<ConfigUpgradeChangeDefinition.ConfigurationKeyValue> sets) {
        ArrayList<ConfigUpgradeChangeDefinition.ConfigurationKeyValue> allowedSets = new ArrayList<ConfigUpgradeChangeDefinition.ConfigurationKeyValue>();
        for (ConfigUpgradeChangeDefinition.ConfigurationKeyValue configurationKeyValue : sets) {
            if (!this.isOperationAllowed(cluster, configType, configurationKeyValue.key, configurationKeyValue)) continue;
            allowedSets.add(configurationKeyValue);
        }
        return allowedSets;
    }

    private List<ConfigUpgradeChangeDefinition.Transfer> getAllowedTransfers(Cluster cluster, String configType, List<ConfigUpgradeChangeDefinition.Transfer> transfers) {
        ArrayList<ConfigUpgradeChangeDefinition.Transfer> allowedTransfers = new ArrayList<ConfigUpgradeChangeDefinition.Transfer>();
        Iterator<ConfigUpgradeChangeDefinition.Transfer> iterator = transfers.iterator();
        while (iterator.hasNext()) {
            ConfigUpgradeChangeDefinition.Transfer transfer;
            String key = transfer.operation == TransferOperation.DELETE ? transfer.deleteKey : transfer.fromKey;
            if (!this.isOperationAllowed(cluster, configType, key, transfer = iterator.next())) continue;
            allowedTransfers.add(transfer);
        }
        return allowedTransfers;
    }

    private List<ConfigUpgradeChangeDefinition.Insert> getAllowedInsertions(Cluster cluster, String configType, List<ConfigUpgradeChangeDefinition.Insert> insertions) {
        return insertions.stream().filter(insertion -> this.isOperationAllowed(cluster, configType, insertion.key, (ConfigUpgradeChangeDefinition.ConditionalField)insertion)).collect(Collectors.toList());
    }

    private boolean isOperationAllowed(Cluster cluster, String configType, String targetPropertyKey, ConfigUpgradeChangeDefinition.ConditionalField operationItem) {
        boolean isAllowed = true;
        boolean ifKeyIsNotBlank = StringUtils.isNotBlank((String)operationItem.ifKey);
        boolean ifTypeIsNotBlank = StringUtils.isNotBlank((String)operationItem.ifType);
        boolean ifValueIsBlank = StringUtils.isBlank((String)operationItem.ifValue);
        if (ifKeyIsNotBlank && ifTypeIsNotBlank && ifValueIsBlank && operationItem.ifKeyState == PropertyKeyState.ABSENT) {
            boolean keyPresent = this.getDesiredConfigurationKeyPresence(cluster, operationItem.ifType, operationItem.ifKey);
            if (keyPresent) {
                LOG.info("Skipping property operation for {}/{} as the key {} for {} is present", new Object[]{configType, targetPropertyKey, operationItem.ifKey, operationItem.ifType});
                isAllowed = false;
            }
        } else if (ifKeyIsNotBlank && ifTypeIsNotBlank && ifValueIsBlank && operationItem.ifKeyState == PropertyKeyState.PRESENT) {
            boolean keyPresent = this.getDesiredConfigurationKeyPresence(cluster, operationItem.ifType, operationItem.ifKey);
            if (!keyPresent) {
                LOG.info("Skipping property operation for {}/{} as the key {} for {} is not present", new Object[]{configType, targetPropertyKey, operationItem.ifKey, operationItem.ifType});
                isAllowed = false;
            }
        } else if (ifKeyIsNotBlank && ifTypeIsNotBlank && !ifValueIsBlank) {
            boolean keyPresent;
            String checkValue = this.getDesiredConfigurationValue(cluster, operationItem.ifType, operationItem.ifKey);
            if (operationItem.ifKeyState == PropertyKeyState.ABSENT && !(keyPresent = this.getDesiredConfigurationKeyPresence(cluster, operationItem.ifType, operationItem.ifKey))) {
                return true;
            }
            if (operationItem.ifValueMatchType == ConfigUpgradeChangeDefinition.IfValueMatchType.PARTIAL) {
                if (!StringUtils.containsIgnoreCase((String)checkValue, (String)operationItem.ifValue) ^ operationItem.ifValueNotMatched) {
                    LOG.info("Skipping property operation for {}/{} as the value {} for {}/{} is not found in {}", new Object[]{configType, targetPropertyKey, operationItem.ifValue, operationItem.ifType, operationItem.ifKey, checkValue});
                    isAllowed = false;
                }
            } else if (!StringUtils.equalsIgnoreCase((String)operationItem.ifValue, (String)checkValue) ^ operationItem.ifValueNotMatched) {
                LOG.info("Skipping property operation for {}/{} as the value {} for {}/{} is not equal to {}", new Object[]{configType, targetPropertyKey, checkValue, operationItem.ifType, operationItem.ifKey, operationItem.ifValue});
                isAllowed = false;
            }
        }
        return isAllowed;
    }

    private boolean getDesiredConfigurationKeyPresence(Cluster cluster, String configType, String propertyKey) {
        Map<String, DesiredConfig> desiredConfigs = cluster.getDesiredConfigs();
        DesiredConfig desiredConfig = desiredConfigs.get(configType);
        if (null == desiredConfig) {
            return false;
        }
        Config config = cluster.getConfig(configType, desiredConfig.getTag());
        if (null == config) {
            return false;
        }
        return config.getProperties().containsKey(propertyKey);
    }

    private String getDesiredConfigurationValue(Cluster cluster, String configType, String propertyKey) {
        Map<String, DesiredConfig> desiredConfigs = cluster.getDesiredConfigs();
        DesiredConfig desiredConfig = desiredConfigs.get(configType);
        if (null == desiredConfig) {
            return null;
        }
        Config config = cluster.getConfig(configType, desiredConfig.getTag());
        if (null == config) {
            return null;
        }
        return config.getProperties().get(propertyKey);
    }

    private void updateBufferWithMessage(StringBuilder buffer, String message) {
        buffer.append(message).append(System.lineSeparator());
    }
}

