/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.upgrades;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.serveraction.upgrades.FinalizeUpgradeAction;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.state.Cluster;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;

public class ComponentVersionCheckAction
extends FinalizeUpgradeAction {
    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        String clusterName = this.getExecutionCommand().getClusterName();
        Cluster cluster = this.getClusters().getCluster(clusterName);
        UpgradeContext upgradeContext = this.getUpgradeContext(cluster);
        Set<FinalizeUpgradeAction.InfoTuple> errors = this.validateComponentVersions(upgradeContext);
        StringBuilder outSB = new StringBuilder();
        StringBuilder errSB = new StringBuilder();
        if (errors.isEmpty()) {
            outSB.append("All service components are reporting the correct version.");
            return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", outSB.toString(), errSB.toString());
        }
        String structuredOut = this.getErrors(outSB, errSB, errors);
        return this.createCommandReport(-1, HostRoleStatus.FAILED, structuredOut, outSB.toString(), errSB.toString());
    }

    private String getErrors(StringBuilder outSB, StringBuilder errSB, Set<FinalizeUpgradeAction.InfoTuple> errors) {
        errSB.append("Finalization will not be able to completed because of the following version inconsistencies:");
        errSB.append(System.lineSeparator());
        TreeSet<String> hosts = new TreeSet<String>();
        HashMap<String, JsonArray> hostDetails = new HashMap<String, JsonArray>();
        for (FinalizeUpgradeAction.InfoTuple infoTuple : errors) {
            errSB.append("  ");
            errSB.append(infoTuple.hostName).append(": ");
            errSB.append(System.lineSeparator()).append("    ");
            errSB.append(infoTuple.serviceName).append('/').append(infoTuple.componentName);
            errSB.append(" reports ").append(StringUtils.trimToEmpty((String)infoTuple.currentVersion));
            errSB.append(" but expects ").append(infoTuple.targetVersion);
            errSB.append(System.lineSeparator());
            hosts.add(infoTuple.hostName);
            if (!hostDetails.containsKey(infoTuple.hostName)) {
                hostDetails.put(infoTuple.hostName, new JsonArray());
            }
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("service", infoTuple.serviceName);
            jsonObject.addProperty("component", infoTuple.componentName);
            jsonObject.addProperty("version", infoTuple.currentVersion);
            jsonObject.addProperty("targetVersion", infoTuple.targetVersion);
            ((JsonArray)hostDetails.get(infoTuple.hostName)).add((JsonElement)jsonObject);
        }
        JsonArray hostJson = new JsonArray();
        for (String string : hosts) {
            hostJson.add((JsonElement)new JsonPrimitive(string));
        }
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry entry : hostDetails.entrySet()) {
            jsonObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        outSB.append(String.format("There were errors on the following hosts: %s", StringUtils.join(hosts, (String)", ")));
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.add("hosts", (JsonElement)hostJson);
        jsonObject2.add("host_detail", (JsonElement)jsonObject);
        return jsonObject2.toString();
    }
}

