/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.upgrades;

import com.google.gson.Gson;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.actionmanager.ServiceComponentHostEventWrapper;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.metadata.ActionMetadata;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.UpgradeGroupEntity;
import id.onyx.obdp.server.orm.entities.UpgradeItemEntity;
import id.onyx.obdp.server.serveraction.upgrades.AbstractUpgradeServerAction;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ServiceComponentHostEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSkipFailedSummaryAction
extends AbstractUpgradeServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(AutoSkipFailedSummaryAction.class);
    private static final String FAILURE_STD_OUT_TEMPLATE = "There were {0} skipped failure(s) that must be addressed before you can proceed. Please resolve each failure before continuing with the upgrade.";
    private static final String SKIPPED_SERVICE_CHECK = "service_check";
    private static final String SKIPPED_HOST_COMPONENT = "host_component";
    private static final String SKIPPED = "skipped";
    private static final String FAILURES = "failures";
    @Inject
    private HostRoleCommandDAO m_hostRoleCommandDAO;
    @Inject
    private Gson m_gson;
    @Inject
    private ActionMetadata actionMetadata;
    private Map<String, Object> m_structuredFailures = new HashMap<String, Object>();

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        HostRoleCommand hostRoleCommand = this.getHostRoleCommand();
        long requestId = hostRoleCommand.getRequestId();
        long stageId = hostRoleCommand.getStageId();
        String clusterName = hostRoleCommand.getExecutionCommandWrapper().getExecutionCommand().getClusterName();
        Cluster cluster = this.getClusters().getCluster(clusterName);
        UpgradeItemEntity upgradeItem = this.m_upgradeDAO.findUpgradeItemByRequestAndStage(requestId, stageId);
        UpgradeGroupEntity upgradeGroup = upgradeItem.getGroupEntity();
        long upgradeGroupId = upgradeGroup.getId();
        UpgradeGroupEntity upgradeGroupEntity = this.m_upgradeDAO.findUpgradeGroup(upgradeGroupId);
        List<UpgradeItemEntity> groupUpgradeItems = upgradeGroupEntity.getItems();
        TreeSet<Long> stageIds = new TreeSet<Long>();
        for (UpgradeItemEntity groupUpgradeItem : groupUpgradeItems) {
            stageIds.add(groupUpgradeItem.getStageId());
        }
        long minStageId = (Long)stageIds.first();
        long maxStageId = (Long)stageIds.last();
        List<HostRoleCommandEntity> skippedTasks = this.m_hostRoleCommandDAO.findByStatusBetweenStages(hostRoleCommand.getRequestId(), HostRoleStatus.SKIPPED_FAILED, minStageId, maxStageId);
        if (skippedTasks.isEmpty()) {
            return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", "There were no skipped failures", null);
        }
        StringBuilder buffer = new StringBuilder("The following steps failed but were automatically skipped:\n");
        HashSet<String> skippedCategories = new HashSet<String>();
        HashMap<String, Cloneable> skippedFailures = new HashMap<String, Cloneable>();
        HashSet<String> skippedServiceChecks = new HashSet<String>();
        HashMap hostComponents = new HashMap();
        HashMap publishedHostComponents = new HashMap();
        for (HostRoleCommandEntity skippedTask : skippedTasks) {
            try {
                String skippedCategory;
                if (skippedTask.getRoleCommand().equals((Object)RoleCommand.SERVICE_CHECK)) {
                    skippedCategory = SKIPPED_SERVICE_CHECK;
                    String serviceCheckActionName = skippedTask.getRole().toString();
                    String service = this.actionMetadata.getServiceNameByServiceCheckAction(serviceCheckActionName);
                    skippedServiceChecks.add(service);
                    skippedFailures.put(SKIPPED_SERVICE_CHECK, skippedServiceChecks);
                    this.m_structuredFailures.put(FAILURES, skippedFailures);
                } else {
                    skippedCategory = SKIPPED_HOST_COMPONENT;
                    String hostName = skippedTask.getHostName();
                    if (null != hostName) {
                        Role role;
                        Set publishedHostComponentsOnHost;
                        ArrayList failures = (ArrayList)hostComponents.get(hostName);
                        if (null == failures) {
                            failures = new ArrayList();
                            hostComponents.put(hostName, failures);
                            publishedHostComponents.put(hostName, new HashSet());
                        }
                        if (!(publishedHostComponentsOnHost = (Set)publishedHostComponents.get(hostName)).contains(role = skippedTask.getRole())) {
                            HashMap<String, String> details = new HashMap<String, String>();
                            String service = cluster.getServiceByComponentName(role.toString()).getName();
                            details.put("service", service);
                            details.put("component", role.toString());
                            failures.add(details);
                        }
                    }
                    skippedFailures.put(SKIPPED_HOST_COMPONENT, hostComponents);
                    this.m_structuredFailures.put(FAILURES, skippedFailures);
                }
                skippedCategories.add(skippedCategory);
                ServiceComponentHostEventWrapper eventWrapper = new ServiceComponentHostEventWrapper(skippedTask.getEvent());
                ServiceComponentHostEvent event = eventWrapper.getEvent();
                buffer.append(event.getServiceComponentName());
                if (null != event.getHostName()) {
                    buffer.append(" on ");
                    buffer.append(event.getHostName());
                }
                buffer.append(": ");
                buffer.append(skippedTask.getCommandDetail());
                buffer.append("\n");
            }
            catch (Exception exception) {
                LOG.warn("Unable to extract failure information for {}", (Object)skippedTask);
                buffer.append(": ");
                buffer.append(skippedTask);
            }
        }
        this.m_structuredFailures.put(SKIPPED, skippedCategories);
        String structuredOutput = this.m_gson.toJson(this.m_structuredFailures);
        String standardOutput = MessageFormat.format(FAILURE_STD_OUT_TEMPLATE, skippedTasks.size());
        String standardError = buffer.toString();
        return this.createCommandReport(0, HostRoleStatus.HOLDING, structuredOutput, standardOutput, standardError);
    }
}

