/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.upgrades;

import com.google.gson.Gson;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ServiceComponentNotFoundException;
import id.onyx.obdp.server.ServiceNotFoundException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.events.listeners.upgrade.StackVersionListener;
import id.onyx.obdp.server.serveraction.upgrades.AbstractUpgradeServerAction;
import id.onyx.obdp.server.stack.MasterHostResolver;
import id.onyx.obdp.server.stack.upgrade.AddComponentTask;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.State;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class AddComponentAction
extends AbstractUpgradeServerAction {
    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        ServiceComponent serviceComponent;
        Service service;
        Map<String, String> commandParameters = this.getCommandParameters();
        if (null == commandParameters || commandParameters.isEmpty()) {
            return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", "", "Unable to add a new component to the cluster as there is no information on what to add.");
        }
        String clusterName = commandParameters.get("clusterName");
        Cluster cluster = this.getClusters().getCluster(clusterName);
        UpgradeContext upgradeContext = this.getUpgradeContext(cluster);
        if (upgradeContext.isDowngradeAllowed() || upgradeContext.isPatchRevert()) {
            return this.createCommandReport(0, HostRoleStatus.SKIPPED_FAILED, "{}", "", "Unable to add a component during an upgrade which can be downgraded.");
        }
        String serializedJson = commandParameters.get("add-component-task");
        Gson gson = this.getGson();
        AddComponentTask task = (AddComponentTask)gson.fromJson(serializedJson, AddComponentTask.class);
        try {
            service = cluster.getService(task.service);
        }
        catch (ServiceNotFoundException snfe) {
            return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", "", String.format("%s was not installed in this cluster since %s is not an installed service.", task.component, task.service));
        }
        Collection<Host> candidates = MasterHostResolver.getCandidateHosts(cluster, task.hosts, task.hostService, task.hostComponent);
        if (candidates.isEmpty()) {
            return this.createCommandReport(0, HostRoleStatus.FAILED, "{}", "", String.format("Unable to add a new component to the cluster as there are no hosts which contain %s's %s", task.hostService, task.hostComponent));
        }
        try {
            serviceComponent = service.getServiceComponent(task.component);
        }
        catch (ServiceComponentNotFoundException scnfe) {
            serviceComponent = service.addServiceComponent(task.component);
            serviceComponent.setDesiredState(State.INSTALLED);
        }
        StringBuilder buffer = new StringBuilder(String.format("Successfully added %s's %s to the cluster", task.service, task.component)).append(System.lineSeparator());
        Map<String, ServiceComponentHost> existingSCHs = serviceComponent.getServiceComponentHosts();
        for (Host host2 : candidates) {
            if (existingSCHs.containsKey(host2.getHostName())) {
                buffer.append("  ").append(host2.getHostName()).append(": ").append("Already Installed").append(System.lineSeparator());
                continue;
            }
            ServiceComponentHost sch = serviceComponent.addServiceComponentHost(host2.getHostName());
            sch.setDesiredState(State.INSTALLED);
            sch.setState(State.INSTALLED);
            sch.setVersion(StackVersionListener.UNKNOWN_VERSION);
            buffer.append("  ").append(host2.getHostName()).append(": ").append("Installed").append(System.lineSeparator());
        }
        Set sortedHosts = candidates.stream().map(host -> host.getHostName()).collect(Collectors.toCollection(() -> new TreeSet()));
        LinkedHashMap<String, Object> structureOutMap = new LinkedHashMap<String, Object>();
        structureOutMap.put("service", task.service);
        structureOutMap.put("component", task.component);
        structureOutMap.put("hosts", sortedHosts);
        return this.createCommandReport(0, HostRoleStatus.COMPLETED, gson.toJson(structureOutMap), buffer.toString(), "");
    }
}

