/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos.stageutils;

import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosKeytab;
import id.onyx.obdp.server.utils.StageUtils;

public class ResolvedKerberosPrincipal {
    private Long hostId;
    private String hostName;
    private String principal;
    private boolean isService;
    private String cacheFile;
    private Multimap<String, String> serviceMapping = ArrayListMultimap.create();
    private String keytabPath;
    private ResolvedKerberosKeytab resolvedKerberosKeytab;

    public ResolvedKerberosPrincipal(Long hostId, String hostName, String principal, boolean isService, String cacheFile, String serviceName, String componentName, String keytabPath) {
        this.hostId = hostId;
        this.hostName = hostName;
        this.principal = principal;
        this.isService = isService;
        this.cacheFile = cacheFile;
        this.keytabPath = keytabPath;
        this.addComponentMapping(serviceName, componentName);
    }

    public ResolvedKerberosPrincipal(Long hostId, String hostName, String principal, boolean isService, String cacheFile, String keytabPath) {
        this.hostId = hostId;
        this.hostName = hostName;
        this.principal = principal;
        this.isService = isService;
        this.cacheFile = cacheFile;
        this.keytabPath = keytabPath;
    }

    public ResolvedKerberosPrincipal(Long hostId, String hostName, String principal, boolean isService, String cacheFile, String keytabPath, Multimap<String, String> serviceMapping) {
        this.hostId = hostId;
        this.hostName = hostName;
        this.principal = principal;
        this.isService = isService;
        this.cacheFile = cacheFile;
        this.keytabPath = keytabPath;
        this.serviceMapping = serviceMapping;
    }

    public void addComponentMapping(String serviceName, String componentName) {
        if (serviceName == null) {
            serviceName = "";
        }
        if (componentName == null) {
            componentName = "*";
        }
        this.serviceMapping.get((Object)serviceName).add(componentName);
    }

    public void mergeComponentMapping(ResolvedKerberosPrincipal other) {
        this.serviceMapping.putAll(other.getServiceMapping());
    }

    public String getKeytabPath() {
        return this.keytabPath;
    }

    public void setKeytabPath(String keytabPath) {
        this.keytabPath = keytabPath;
    }

    public Long getHostId() {
        return this.hostId;
    }

    public void setHostId(Long hostId) {
        this.hostId = hostId;
    }

    public String getHostName() {
        if (this.hostName == null) {
            return StageUtils.getHostName();
        }
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public boolean isService() {
        return this.isService;
    }

    public void setService(boolean service) {
        this.isService = service;
    }

    public String getCacheFile() {
        return this.cacheFile;
    }

    public void setCacheFile(String cacheFile) {
        this.cacheFile = cacheFile;
    }

    public Multimap<String, String> getServiceMapping() {
        return this.serviceMapping;
    }

    public void setServiceMapping(Multimap<String, String> serviceMapping) {
        this.serviceMapping = serviceMapping;
    }

    public ResolvedKerberosKeytab getResolvedKerberosKeytab() {
        return this.resolvedKerberosKeytab;
    }

    public void setResolvedKerberosKeytab(ResolvedKerberosKeytab resolvedKerberosKeytab) {
        this.resolvedKerberosKeytab = resolvedKerberosKeytab;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedKerberosPrincipal principal1 = (ResolvedKerberosPrincipal)o;
        return this.isService == principal1.isService && Objects.equal((Object)this.hostId, (Object)principal1.hostId) && Objects.equal((Object)this.hostName, (Object)principal1.hostName) && Objects.equal((Object)this.principal, (Object)principal1.principal) && Objects.equal((Object)this.cacheFile, (Object)principal1.cacheFile) && Objects.equal(this.serviceMapping, principal1.serviceMapping) && Objects.equal((Object)this.keytabPath, (Object)principal1.keytabPath);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.hostId, this.hostName, this.principal, this.isService, this.cacheFile, this.serviceMapping, this.keytabPath});
    }
}

